<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
    exit("Unauthorized");
}

$view = $_GET['view'] ?? 'active';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>User Management</title>
<link rel="icon" type="image/png" href="images/logo.png">

<style>
@keyframes pop {
  from { transform:scale(0.9); opacity:0; }
  to { transform:scale(1); opacity:1; }
}

.locked { filter: blur(6px); pointer-events: none; user-select: none; }

.modal-bg{
  display:none;
  position:fixed;
  inset:0;
  background:rgba(0,0,0,.5);
  align-items:center;
  justify-content:center;
  z-index:99999;
}

.modal{
  background:#fff;
  padding:25px;
  width:400px;
  border-radius:12px;
  animation:pop .25s ease;
  box-shadow:0 20px 50px rgba(0,0,0,.3);
}

.confirm-btn{
  padding:8px 14px;
  border:none;
  border-radius:6px;
  cursor:pointer;
}

.freeze { color: orange; }
</style>
</head>
<body>

<!-- SECURITY MODAL -->
<div id="securityModal" class="modal-bg" style="display:flex;">
<div class="modal">
  <h3 style="margin-top:0;color:#0f2a44;">🔐 Security Verification</h3>
  <p>Please re-enter your password to continue.</p>

  <input id="verify_password" type="password"
    placeholder="Enter your password"
    style="width:100%;padding:10px;margin-bottom:15px;border-radius:6px;border:1px solid #ccc;">

  <div style="text-align:right;">
    <button onclick="verifyAccess()" class="confirm-btn" style="background:#0f2a44;color:#fff;">
      Verify
    </button>
  </div>

  <p id="verify_error" style="color:red;font-size:13px;margin-top:10px;"></p>
</div>
</div>

<!-- MAIN CONTENT -->
<div id="usersContent" class="locked">
<div class="card">

<div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:20px;">
  <h3 style="margin:0; color:#0f2a44;">
    <?= $view === 'deleted' ? 'Deleted Users' : 'User Management' ?>
  </h3>

  <?php if ($view !== 'deleted'): ?>
  <button onclick="openAddUserModal()" style="padding:8px 14px;background:#0f2a44;color:#fff;border:none;border-radius:8px;cursor:pointer;">
    ➕ Add User
  </button>
  <?php endif; ?>
</div>

<div style="overflow-x:auto;">
<table style="width:100%;border-collapse:collapse;font-size:14px;">
<thead>
<tr style="background:#f4f6f9;">
  <th>Username</th>
  <th>Email</th>
  <th>ID</th>
  <th>Role</th>
  <th>Status</th>
  <th>Date Added</th>
  <th>Actions</th>
</tr>
</thead>
<tbody>

<?php
$where = ($view === 'deleted')
    ? "WHERE status='deleted'"
    : "WHERE status!='deleted'";

$result = $conn->query("
  SELECT id, username, email, role, status, created_at
  FROM users
  $where
  ORDER BY created_at DESC
");

while($u=$result->fetch_assoc()):

$role = !empty($u['role']) ? $u['role'] : 'user';

$isFrozen = ($u['status'] === 'frozen');

$freezeClass = $isFrozen ? 'freeze' : '';
$freezeText  = $isFrozen ? 'Unfreeze' : 'Freeze';
?>

<tr class="<?= $freezeClass ?>" id="userRow<?= (int)$u['id'] ?>">
  <td><?= htmlspecialchars($u['username']) ?></td>
  <td><?= htmlspecialchars($u['email']) ?></td>
  <td><?= (int)$u['id'] ?></td>
  <td><?= ucfirst($role) ?></td>
  <td id="status<?= (int)$u['id'] ?>"><?= ucfirst($u['status']) ?></td>
  <td><?= date('Y-m-d',strtotime($u['created_at'])) ?></td>
  <td>

    <span onclick="openEditUser(
      <?= (int)$u['id'] ?>,
      '<?= htmlspecialchars($u['username'],ENT_QUOTES) ?>',
      '<?= htmlspecialchars($u['email'],ENT_QUOTES) ?>',
      '<?= $role ?>'
    )" style="cursor:pointer;">✏ Edit</span> |

    <span id="freezeBtn<?= (int)$u['id'] ?>"
      onclick="updateUser(<?= (int)$u['id'] ?>,'freeze')"
      style="cursor:pointer; color:<?= $isFrozen ? 'orange':'inherit' ?>;">
      <?= $freezeText ?>
    </span> |

    <span onclick="updateUser(<?= (int)$u['id'] ?>,'delete')" style="cursor:pointer;color:#dc3545;">🗑 Delete</span>

  </td>
</tr>

<?php endwhile; ?>

</tbody>
</table>
</div>
</div>
</div>

<script>
function verifyAccess(){
  document.getElementById('securityModal').style.display='none';
  document.getElementById('usersContent').classList.remove('locked');
}

function updateUser(id,action){

  fetch('user_action.php',{
    method:'POST',
    headers:{'Content-Type':'application/x-www-form-urlencoded'},
    body:`action=${action}&user_id=${id}`
  })
  .then(r=>r.text())
  .then(r=>{

    if(r !== 'success'){
      alert(r);
      return;
    }

    loadPage('users.php','User Management');

  });
}
</script>

</body>
</html>
