<?php
require_once "db.php";

/* ===============================
   SESSION / ACCESS CONTROL
================================ */
if (
    !isset($_SESSION['user_id']) ||
    !isset($_SESSION['login_time']) ||
    (time() - $_SESSION['login_time']) > 86400
) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}

/* ROLE PROTECTION */
if ($_SESSION['role'] !== 'user') {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Lifeshed User Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://fonts.googleapis.com/css?family=Poppins:400,600,700&display=swap" rel="stylesheet">

<style>
body{margin:0;font-family:'Poppins',sans-serif;background:#f4f6f9}
a{text-decoration:none;cursor:pointer}
.sidebar{width:260px;background:#0f2a44;color:#fff;display:flex;flex-direction:column}
.sidebar a{padding:14px 25px;color:#fff;display:block;transition:.3s}
.sidebar a:hover{background:rgba(255,255,255,.15);padding-left:32px}
.sidebar a.active{background:rgba(255,255,255,.2);font-weight:600}
.topbar{background:#fff;padding:16px 25px;box-shadow:0 4px 12px rgba(0,0,0,.08)}
.card{background:#fff;padding:25px;border-radius:16px;box-shadow:0 10px 30px rgba(0,0,0,.08)}
.card:hover{transform:translateY(-6px);box-shadow:0 18px 40px rgba(0,0,0,.12)}
</style>
</head>

<body>

<div style="display:flex;min-height:100vh">

<div class="sidebar">

  <div style="padding:12px 20px;border-bottom:1px solid rgba(255,255,255,.1);text-align:center">
    <a href="index.php">
      <img src="images/logo.png" style="max-width:120px">
    </a>
    <p style="font-size:12px;opacity:.8">User Panel</p>
  </div>

  <div style="flex:1">
    <a id="btn-property" class="active" onclick="loadPage('property.php','Property Management',this)">🏘 Property Management</a>
    <a onclick="loadPage('bookings.php','Bookings',this)">💰 Bookings</a>
    <a onclick="loadPage('landlord_requests.php','Management Requests',this)">📋 Management Requests</a>
    <a onclick="loadPage('messages.php','Messages',this)">💬 Messages</a>
  </div>

  <div style="padding:15px 25px;border-top:1px solid rgba(255,255,255,.1)">
    <a href="logout.php" style="color:#ffb3b3;font-weight:600">🚪 Logout</a>
  </div>
</div>

<div style="flex:1;display:flex;flex-direction:column">
  <div class="topbar">
    <h2 id="pageTitle" style="margin:0;color:#0f2a44">Property Management</h2>
  </div>

  <div style="padding:30px" id="mainContent"></div>
</div>
</div>

<script>
function setActive(el){
  document.querySelectorAll('.sidebar a').forEach(a=>a.classList.remove('active'));
  if(el) el.classList.add('active');
}

function loadPage(url,title,el){
  setActive(el);
  document.getElementById('pageTitle').innerText=title;

  fetch(url)
    .then(r=>r.text())
    .then(html=>{
      const c=document.getElementById('mainContent');
      c.innerHTML=html;

      c.querySelectorAll('script').forEach(s=>{
        const n=document.createElement('script');
        n.text=s.textContent;
        document.body.appendChild(n);
        s.remove();
      });
    });
}

document.addEventListener("DOMContentLoaded", function() {
  loadPage('property.php','Property Management',document.getElementById('btn-property'));
});
</script>

</body>
</html>
