<?php
require_once "db.php";

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Invalid request method');
}

// Collect and sanitize inputs
$name         = trim($_POST['name'] ?? '');
$phone        = trim($_POST['phone'] ?? '');
$propertyName = trim($_POST['property_name'] ?? '');
$location     = trim($_POST['location'] ?? '');
$description  = trim($_POST['description'] ?? '');

// Validate inputs
if (!$name || !$phone || !$propertyName || !$location || !$description) {
    http_response_code(400);
    exit('All fields are required');
}

// Optional: further sanitize (prevent overly long inputs)
if (strlen($name) > 255 || strlen($propertyName) > 255 || strlen($location) > 255) {
    http_response_code(400);
    exit('One or more fields exceed the maximum allowed length');
}

// Prepare insert statement
$stmt = $conn->prepare("
    INSERT INTO landlord_management_requests
        (name, phone, property_name, location, description, created_at)
    VALUES (?, ?, ?, ?, ?, NOW())
");

if (!$stmt) {
    http_response_code(500);
    exit('Server error: ' . $conn->error);
}

// Bind parameters
$stmt->bind_param("sssss", $name, $phone, $propertyName, $location, $description);

// Execute statement
if ($stmt->execute()) {
    echo 'success';
} else {
    http_response_code(500);
    echo 'Server error: ' . $stmt->error;
}

// Clean up
$stmt->close();
$conn->close();
