<?php
require_once "db.php";

$token = $_GET['token'] ?? '';
$error = "";
$message = "";
$validToken = false;
$user_id = null;

if ($token) {

    $stmt = $conn->prepare(
        "SELECT user_id, expires_at 
         FROM password_resets 
         WHERE token = ? 
         LIMIT 1"
    );
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows === 1) {

        $row = $result->fetch_assoc();

        if (strtotime($row['expires_at']) > time()) {
            $validToken = true;
            $user_id = $row['user_id'];
        } else {
            $error = "This reset link has expired.";
        }

    } else {
        $error = "Invalid reset token.";
    }

} else {
    $error = "No reset token provided.";
}

/* HANDLE PASSWORD UPDATE */
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["new_password"])) {

    $token = $_POST['token'];
    $new_password = $_POST["new_password"];
    $confirm_password = $_POST["confirm_password"];

    if ($new_password !== $confirm_password) {
        $error = "Passwords do not match.";
        $validToken = true;
    } elseif (strlen($new_password) < 6) {
        $error = "Password must be at least 6 characters.";
        $validToken = true;
    } else {

        $stmt = $conn->prepare(
            "SELECT user_id, expires_at 
             FROM password_resets 
             WHERE token = ? 
             LIMIT 1"
        );
        $stmt->bind_param("s", $token);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows === 1) {

            $row = $result->fetch_assoc();

            if (strtotime($row['expires_at']) > time()) {

                $user_id = $row['user_id'];
                $hashed = password_hash($new_password, PASSWORD_DEFAULT);

                // Update password
                $update = $conn->prepare(
                    "UPDATE users SET password = ? WHERE id = ?"
                );
                $update->bind_param("si", $hashed, $user_id);
                $update->execute();

                // Delete token after use
                $delete = $conn->prepare(
                    "DELETE FROM password_resets WHERE user_id = ?"
                );
                $delete->bind_param("i", $user_id);
                $delete->execute();

                $message = "Password reset successful! Redirecting to login...";
                $validToken = false;

                header("refresh:3;url=login.php");
            } else {
                $error = "This reset link has expired.";
            }

        } else {
            $error = "Invalid reset token.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Reset Password | Lifeshed Realtors</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
  <link href="css/style.css" rel="stylesheet" />
  <link href="css/responsive.css" rel="stylesheet" />

  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: #f4f6f9;
    }

    .reset-wrapper {
      min-height: calc(100vh - 300px);
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 60px 15px;
    }

    .reset-card {
      background: #fff;
      padding: 35px;
      border-radius: 16px;
      width: 100%;
      max-width: 400px;
      box-shadow: 0 15px 40px rgba(0,0,0,0.2);
    }

    .reset-card h2 {
      text-align: center;
      margin-bottom: 20px;
      color: #0f2a44;
    }

    .reset-card input {
      width: 100%;
      padding: 10px;
      margin-bottom: 15px;
      border-radius: 8px;
      border: 1px solid #ccc;
    }

    .reset-card button {
      width: 100%;
      padding: 10px;
      border: none;
      border-radius: 8px;
      background: #0f2a44;
      color: #fff;
      font-size: 16px;
      cursor: pointer;
    }

    .error {
      background: #ffe5e5;
      color: #b30000;
      padding: 10px;
      border-radius: 8px;
      margin-bottom: 15px;
      text-align: center;
    }

    .success {
      background: #e6ffed;
      color: #006622;
      padding: 10px;
      border-radius: 8px;
      margin-bottom: 15px;
      text-align: center;
    }
  </style>
</head>

<body>

<!-- NAVBAR -->
<header class="header_section">
  <div class="container-fluid">
    <nav class="navbar navbar-expand-lg custom_nav-container">
      <a class="navbar-brand" href="index.php">
        <img src="images/logo.png" alt="Lifeshed Realtors" />
      </a>
    </nav>
  </div>
</header>

<div class="reset-wrapper">
  <div class="reset-card">
    <h2>Reset Password</h2>

    <?php if ($error): ?>
      <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <?php if ($message): ?>
      <div class="success"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <?php if ($validToken): ?>
      <form method="POST">
        <input type="hidden" name="token" value="<?= htmlspecialchars($token) ?>">

        <input type="password" name="new_password" placeholder="New Password" required>
        <input type="password" name="confirm_password" placeholder="Confirm Password" required>

        <button type="submit">Reset Password</button>
      </form>
    <?php endif; ?>

  </div>
</div>

<section class="container-fluid footer_section">
  <div class="container">
    <p>&copy; <span id="displayYear"></span> Lifeshed Realtors</p>
  </div>
</section>

<script src="js/jquery-3.4.1.min.js"></script>
<script src="js/bootstrap.js"></script>

</body>
</html>
