<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
    exit("Unauthorized");
}

$property_id = (int)($_GET['property_id'] ?? 0);
if ($property_id <= 0) {
    exit("<div class='card'>Invalid property</div>");
}

/* FETCH PROPERTY */
$p = $conn->query("SELECT * FROM properties WHERE id=$property_id LIMIT 1")->fetch_assoc();
if (!$p) {
    exit("<div class='card'>Property not found</div>");
}

/* FETCH UNITS - Ensuring it tallies with property_units table */
$unit = $conn->query("
    SELECT units_count, vacant_count
    FROM property_units
    WHERE property_id=$property_id
    LIMIT 1
")->fetch_assoc();

// Fallback if no record exists in property_units yet
if (!$unit) {
    $unit = ['units_count' => 0, 'vacant_count' => 0];
}

/* IMAGES */
$images = $conn->query("SELECT * FROM property_images WHERE property_id=$property_id");

/* LANDLORD */
$landlord = null;
$totalManaged = 0;
if (!empty($p['landlord_id'])) {
    $landlord_id = (int)$p['landlord_id'];
    $landlord = $conn->query("SELECT id, name, phone, email FROM landlords WHERE id = $landlord_id LIMIT 1")->fetch_assoc();
    if ($landlord) {
        $totalManaged = $conn->query("SELECT COUNT(*) as total FROM properties WHERE landlord_id = $landlord_id")->fetch_assoc()['total'];
    }
}
?>

<div class="card">
    <div class="pm-header">
        <h3>🏠 <?= htmlspecialchars($p['name']) ?></h3>
        <div>
            <button id="editBtn" class="btn-glass" onclick="enableEdit()">✏️ Edit</button>
            <button class="btn-glass" onclick="loadPage('property.php','Property Management')">← Back</button>
        </div>
    </div>

    <div class="pm-grid">
        <div class="pm-section">
            <h4>Property Details</h4>
            <label>Name</label>
            <input id="p_name" value="<?= htmlspecialchars($p['name']) ?>" disabled>
            <label>Location</label>
            <input id="p_location" value="<?= htmlspecialchars($p['location']) ?>" disabled>
            <label>Category</label>
            <select id="p_type" disabled>
                <option value="single_house" <?= $p['property_type'] == 'single_house' ? 'selected' : '' ?>>Single House / Own Compound</option>
                <option value="apartment" <?= $p['property_type'] == 'apartment' ? 'selected' : '' ?>>Flats / Apartment</option>
            </select>
            <label>Description</label>
            <textarea id="p_description" rows="4" disabled><?= htmlspecialchars($p['description']) ?></textarea>
        </div>

        <div class="pm-section">
            <h4>Units & Vacancy</h4>
            <label>Total Units</label>
            <input type="number" id="totalUnits" value="<?= (int)$unit['units_count'] ?>" disabled>
            <label>Vacant Units</label>
            <input type="number" id="vacantUnits" value="<?= (int)$unit['vacant_count'] ?>" disabled>
        </div>
    </div>

    <div class="pm-section" style="margin-top:30px;">
        <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:15px;">
            <h4>Property Images</h4>
            <button id="addImgBtn" class="btn-glass" style="display:none; background:#555; font-size:12px;" onclick="document.getElementById('newPics').click()">+ Add Pictures</button>
            <input type="file" id="newPics" multiple accept="image/*" style="display:none;" onchange="previewNewPics(event)">
        </div>
        
        <div class="image-wrap" id="imageGallery">
            <?php while($img = $images->fetch_assoc()): ?>
                <div class="img-container" id="db_img_<?= $img['id'] ?>">
                    <img src="<?= $img['image_path'] ?>">
                    <button type="button" class="img-x" onclick="markForDeletion(<?= $img['id'] ?>)">×</button>
                </div>
            <?php endwhile; ?>
        </div>
    </div>

    <div class="pm-section landlord-box">
        <h4>👤 Landlord Details</h4>
        <input type="hidden" id="landlord_id" value="<?= $landlord['id'] ?? '' ?>">
        <label>Full Name</label>
        <input id="l_name" value="<?= htmlspecialchars($landlord['name'] ?? '') ?>" disabled>
        <label>Phone Number</label>
        <input id="l_phone" value="<?= htmlspecialchars($landlord['phone'] ?? '') ?>" disabled>
        <label>Email Address</label>
        <input id="l_email" value="<?= htmlspecialchars($landlord['email'] ?? '') ?>" disabled>
        <label>Total Properties Managed</label>
        <input value="<?= (int)$totalManaged ?>" disabled>
    </div>

    <div class="pm-footer-actions">
        <button id="saveBtn" class="btn-save" onclick="saveProperty()" style="display:none;">💾 Save Changes</button>
        <button id="deleteBtn" class="btn-delete" onclick="deleteProperty()">🗑️ Delete Property</button>
    </div>
</div>

<style>
.pm-header{ display:flex; justify-content:space-between; align-items:center; margin-bottom:25px; }
.pm-grid{ display:grid; grid-template-columns:1fr 1fr; gap:30px; }
.pm-section{ background:#fff; padding:20px; border-radius:12px; box-shadow:0 2px 10px rgba(0,0,0,0.05); }
.landlord-box{ margin-top:40px; background:#f9fbfd; border:1px solid #e2e8f0; }
label{ font-size:13px; font-weight:600; margin-top:12px; display:block; }
input, select, textarea{ width:100%; padding:9px; border-radius:8px; border:1px solid #ccc; margin-top:5px; }
.image-wrap{ display:flex; gap:15px; flex-wrap:wrap; }
.img-container{ position:relative; width:140px; height:110px; }
.img-container img{ width:100%; height:100%; object-fit:cover; border-radius:10px; border:1px solid #ddd; }
.img-x{ position:absolute; top:-5px; right:-5px; background:red; color:white; border:none; border-radius:50%; width:22px; height:22px; cursor:pointer; font-weight:bold; display:none; }
.btn-glass{ background:#0f2a44; color:#fff; padding:9px 18px; border:none; border-radius:10px; cursor:pointer; }
.btn-save{ background:#28a745; color:#fff; padding:10px 24px; border:none; border-radius:10px; cursor:pointer; font-weight:bold; }
.btn-delete{ background:#dc3545; color:#fff; padding:10px 24px; border:none; border-radius:10px; cursor:pointer; font-weight:bold; }
.pm-footer-actions { display: flex; justify-content: space-between; margin-top: 25px; padding-top: 20px; border-top: 1px solid #eee; }
</style>

<script>
let deletedImageIds = [];
let newFiles = [];

function enableEdit(){
    document.querySelectorAll('input,select,textarea').forEach(e=>{
        if(e.id !== '' && e.type !== 'hidden') e.disabled = false;
    });
    document.querySelectorAll('.img-x').forEach(btn => btn.style.display = 'block');
    document.getElementById('addImgBtn').style.display = 'block';
    document.getElementById('editBtn').style.display = 'none';
    document.getElementById('saveBtn').style.display = 'inline-block';
}

function previewNewPics(e) {
    const files = Array.from(e.target.files);
    files.forEach(file => {
        newFiles.push(file);
        const reader = new FileReader();
        reader.onload = (ex) => {
            const id = 'new_' + Math.random().toString(36).substr(2, 9);
            const div = document.createElement('div');
            div.className = 'img-container';
            div.id = id;
            div.innerHTML = `<img src="${ex.target.result}"><button class="img-x" style="display:block" onclick="removeNewPic('${id}', '${file.name}')">×</button>`;
            document.getElementById('imageGallery').appendChild(div);
        };
        reader.readAsDataURL(file);
    });
}

function removeNewPic(divId, fileName) {
    newFiles = newFiles.filter(f => f.name !== fileName);
    document.getElementById(divId).remove();
}

function markForDeletion(id) {
    deletedImageIds.push(id);
    document.getElementById('db_img_' + id).style.opacity = '0.3';
    document.getElementById('db_img_' + id).style.pointerEvents = 'none';
}

function saveProperty(){
    const fd = new FormData();
    fd.append('property_id', <?= $property_id ?>);
    fd.append('name', p_name.value);
    fd.append('location', p_location.value);
    fd.append('property_type', p_type.value);
    fd.append('description', p_description.value);
    fd.append('units_count', totalUnits.value);
    fd.append('vacant_count', vacantUnits.value);
    fd.append('landlord_id', landlord_id.value);
    fd.append('l_name', l_name.value);
    fd.append('l_phone', l_phone.value);
    fd.append('l_email', l_email.value);
    fd.append('delete_image_ids', JSON.stringify(deletedImageIds));
    newFiles.forEach(file => { fd.append('images[]', file); });

    fetch('property_full_save.php', { method:'POST', body:fd })
    .then(r=>r.json())
    .then(r=>{
        if(r.status==='success'){
            alert('✅ Changes saved successfully');
            loadPage('property_manage.php?property_id=<?= $property_id ?>','Manage Property');
        }else{
            alert('❌ Failed to save: ' + r.message);
        }
    })
    .catch(()=>alert('❌ Server error'));
}

function deleteProperty(){
    if(!confirm("⚠️ Are you sure you want to delete this property? This action cannot be undone.")) return;
    if(!confirm("FINAL WARNING: All unit data and images associated with this property will be removed. Proceed?")) return;

    const fd = new FormData();
    fd.append('property_id', <?= $property_id ?>);
    fd.append('action', 'delete');

    fetch('property_delete.php', { method:'POST', body:fd })
    .then(r=>r.json())
    .then(r=>{
        if(r.status==='success'){
            alert('🗑️ Property deleted successfully');
            loadPage('property.php','Property Management');
        }else{
            alert('❌ Error: ' + r.message);
        }
    })
    .catch(()=>alert('❌ Server error during deletion'));
}
</script>