<?php
require_once "db.php";
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(["status" => "error", "message" => "Unauthorized"]);
    exit;
}

$property_id = (int)($_POST['property_id'] ?? 0);
$action = $_POST['action'] ?? '';

if ($property_id <= 0 || $action !== 'delete') {
    echo json_encode(["status" => "error", "message" => "Invalid request"]);
    exit;
}

// Start transaction to ensure all related data is deleted or none at all
$conn->begin_transaction();

try {
    /* 1. DELETE UNIT DATA */
    $stmt1 = $conn->prepare("DELETE FROM property_units WHERE property_id = ?");
    $stmt1->bind_param("i", $property_id);
    $stmt1->execute();

    /* 2. DELETE PROPERTY IMAGES (Database records) */
    // Note: If you want to delete physical files, you'd fetch paths and unlink() here
    $stmt2 = $conn->prepare("DELETE FROM property_images WHERE property_id = ?");
    $stmt2->bind_param("i", $property_id);
    $stmt2->execute();

    /* 3. DELETE THE PROPERTY RECORD */
    $stmt3 = $conn->prepare("DELETE FROM properties WHERE id = ?");
    $stmt3->bind_param("i", $property_id);
    $stmt3->execute();

    if ($stmt3->affected_rows > 0) {
        $conn->commit();
        echo json_encode(["status" => "success", "message" => "Property deleted"]);
    } else {
        throw new Exception("Property record not found or already deleted.");
    }

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}