<?php
require_once "db.php";
if (!isset($_SESSION['user_id'])) {
    exit("Unauthorized");
}
?>

<style>
.pm-backdrop{ position:fixed; inset:0; background:rgba(0,0,0,0.45); backdrop-filter:blur(8px); display:flex; align-items:center; justify-content:center; z-index:9999; }
.pm-modal{ background:#fff; border-radius:20px; padding:25px; width:95%; max-width:600px; max-height:90vh; overflow-y:auto; box-shadow:0 25px 60px rgba(0,0,0,0.3); animation:pop .25s ease; }
@keyframes pop{ from{transform:scale(.85);opacity:0} to{transform:scale(1);opacity:1} }
.pm-form div{margin-bottom:12px;}
.pm-form input, .pm-form select, .pm-form textarea{ width:100%; padding:10px; border-radius:10px; border:1px solid #ddd; }
.checkbox-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px; background: #f9f9f9; padding: 15px; border-radius: 10px; border: 1px solid #eee; }
.checkbox-row { display: flex; align-items: center; gap: 8px; font-size: 13px; }
.checkbox-row input { width: auto; }

/* Image Preview Styles */
.image-preview-container { display: grid; grid-template-columns: repeat(4, 1fr); gap: 10px; margin-top: 10px; }
.preview-item { position: relative; width: 100%; padding-top: 100%; border-radius: 8px; overflow: hidden; border: 1px solid #ddd; }
.preview-item img { position: absolute; top: 0; left: 0; width: 100%; height: 100%; object-fit: cover; }
.remove-img { position: absolute; top: 2px; right: 2px; background: rgba(255,0,0,0.8); color: white; border: none; border-radius: 50%; width: 20px; height: 20px; cursor: pointer; font-size: 12px; display: flex; align-items: center; justify-content: center; }

.landlord-box { border: 1px dashed #0f2a44; padding: 15px; border-radius: 12px; background: #f0f4f8; }
.btn-save { background:#0f2a44; color:#fff; border:none; padding:12px 20px; border-radius:10px; cursor:pointer; width: 100%; font-weight: bold; }
</style>

<div class="pm-backdrop" onclick="closeAddProperty()">
    <div class="pm-modal" onclick="event.stopPropagation()">
        <h3 style="color:#0f2a44;">Add New Property</h3>

        <form class="pm-form" id="propertyForm" onsubmit="saveProperty(event)">
            <div>
                <input type="text" id="propName" placeholder="Property Name (e.g. Lifeshed Heights)" required>
            </div>
            <div>
                <input type="text" id="propLocation" placeholder="Location (e.g. Uganda Highway, Eldoret)" required>
            </div>

            <div>
                <select id="propCategory" onchange="toggleCategoryFields()" required>
                    <option value="">Select Category</option>
                    <option value="single_house">Single House / Own Compound</option>
                    <option value="apartment">Flats / Apartment</option>
                </select>
            </div>

            <div id="singleHouseWrap" style="display:none;">
                <div style="display:flex; gap:10px;">
                    <input type="number" id="bedrooms" placeholder="Bedrooms">
                    <input type="number" id="bathrooms" placeholder="Bathrooms">
                </div>
            </div>

            <div id="apartmentWrap" style="display:none;">
                <label style="font-size: 13px; font-weight: 600;">Available Unit Types:</label>
                <div class="checkbox-grid">
                    <div class="checkbox-row"><input type="checkbox" class="unit-opt" value="Studio"> Studio</div>
                    <div class="checkbox-row"><input type="checkbox" class="unit-opt" value="1BR"> 1 Bedroom</div>
                    <div class="checkbox-row"><input type="checkbox" class="unit-opt" value="2BR"> 2 Bedroom</div>
                    <div class="checkbox-row"><input type="checkbox" class="unit-opt" value="3BR"> 3 Bedroom</div>
                    <div class="checkbox-row"><input type="checkbox" class="unit-opt" value="4BR+"> 4 Bedroom+</div>
                    <div class="checkbox-row"><input type="text" id="customUnit" placeholder="Other (e.g. Shop)" style="padding: 2px 5px; font-size: 11px;"></div>
                </div>
            </div>

            <div>
                <textarea id="description" placeholder="Describe the property (amenities, security, etc.)" required></textarea>
            </div>

            <div class="landlord-box">
                <h4 style="margin:0 0 10px;">👤 Landlord Info</h4>
                <input type="text" id="landlordName" placeholder="Name" required style="margin-bottom:8px;">
                <div style="display:flex; gap:10px;">
                    <input type="text" id="landlordPhone" placeholder="Phone" required>
                    <input type="email" id="landlordEmail" placeholder="Email" required>
                </div>
            </div>

            <div style="margin-top:15px;">
                <label style="font-weight: 600;">Property Images</label>
                <input type="file" id="imgInput" multiple accept="image/*" onchange="handleImageSelect(event)" style="margin-top:5px;">
                <div class="image-preview-container" id="previewContainer"></div>
            </div>

            <div class="pm-actions">
                <button type="submit" class="btn-save">Publish Listing</button>
            </div>
        </form>
    </div>
</div>

<script>
let selectedFiles = [];

function toggleCategoryFields() {
    const cat = document.getElementById('propCategory').value;
    document.getElementById('singleHouseWrap').style.display = (cat === 'single_house') ? 'block' : 'none';
    document.getElementById('apartmentWrap').style.display = (cat === 'apartment') ? 'block' : 'none';
}

function handleImageSelect(e) {
    const files = Array.from(e.target.files);
    if (selectedFiles.length + files.length > 10) {
        alert("Max 10 images allowed.");
        return;
    }
    
    files.forEach(file => {
        selectedFiles.push(file);
        const reader = new FileReader();
        reader.onload = function(event) {
            const container = document.getElementById('previewContainer');
            const div = document.createElement('div');
            div.className = 'preview-item';
            div.innerHTML = `
                <img src="${event.target.result}">
                <button type="button" class="remove-img" onclick="removeImage(${selectedFiles.length - 1}, this)">X</button>
            `;
            container.appendChild(div);
        };
        reader.readAsDataURL(file);
    });
}

function removeImage(index, btn) {
    selectedFiles.splice(index, 1);
    btn.parentElement.remove();
}

function saveProperty(e) {
    e.preventDefault();
    const formData = new FormData();
    
    formData.append('name', document.getElementById('propName').value);
    formData.append('location', document.getElementById('propLocation').value);
    formData.append('property_type', document.getElementById('propCategory').value);
    formData.append('description', document.getElementById('description').value);
    
    // Landlord Data
    formData.append('l_name', document.getElementById('landlordName').value);
    formData.append('l_phone', document.getElementById('landlordPhone').value);
    formData.append('l_email', document.getElementById('landlordEmail').value);

    // Conditional Data logic
    if (document.getElementById('propCategory').value === 'single_house') {
        formData.append('bedrooms', document.getElementById('bedrooms').value);
        formData.append('bathrooms', document.getElementById('bathrooms').value);
    } else {
        let units = [];
        document.querySelectorAll('.unit-opt:checked').forEach(cb => units.push(cb.value));
        const custom = document.getElementById('customUnit').value;
        if(custom) units.push(custom);
        // This will be stored in description or a new column 'unit_types'
        formData.append('unit_types', units.join(', '));
    }

    selectedFiles.forEach(file => formData.append('images[]', file));

    fetch('property_save.php', { method: 'POST', body: formData })
    .then(res => res.json())
    .then(data => {
        if (data.status === 'success') {
            alert('Property Added!');
            location.reload();
        } else {
            alert(data.message);
        }
    });
}
</script>