<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
    exit("Unauthorized");
}

/* ---------------- FETCH PROPERTIES ---------------- */
$sql = "
  SELECT
    p.id,
    p.name,
    p.location,
    p.property_type,
    p.bedrooms,
    p.bathrooms,
    p.description,
    l.name AS landlord_name,
    l.phone AS landlord_phone,
    l.email AS landlord_email,
    
    /* TOTAL UNITS (For Apartments) */
    (SELECT COALESCE(SUM(u.units_count),0) FROM property_units u WHERE u.property_id = p.id) AS total_units,
    
    /* VACANT UNITS (For Apartments) */
    (SELECT COALESCE(SUM(u.vacant_count),0) FROM property_units u WHERE u.property_id = p.id) AS vacant_units

  FROM properties p
  LEFT JOIN landlords l ON p.landlord_id = l.id
  ORDER BY p.created_at DESC
";

$result = $conn->query($sql);
?>

<style>
.pm-header{display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;}
.pm-header h3{margin:0;color:#0f2a44;font-weight:700;}
.btn-glass{background:#001f3f;color:#FFD700;padding:10px 20px;border-radius:12px;border:none;cursor:pointer;font-weight:600;transition:0.3s;}
.btn-glass:hover{background:#003366;transform:translateY(-2px);}
.pm-table{width:100%;border-collapse:collapse;font-size:14px;background:#fff;}
.pm-table th,.pm-table td{padding:15px;border-bottom:1px solid #eee;vertical-align:middle;}
.pm-table th{background:#f8f9fa;text-align:left;color:#0f2a44;text-transform:uppercase;font-size:12px;letter-spacing:1px;}
.property-thumb{width:60px;height:45px;border-radius:8px;object-fit:cover;border:1px solid #ddd;background:#eee;}
.badge-type{padding:4px 8px;border-radius:20px;font-size:11px;font-weight:600;}
.badge-house{background:#e1f5fe;color:#01579b;}
.badge-apt{background:#fff3e0;color:#e65100;}
.landlord-info{font-size:13px;line-height:1.4;}
.landlord-info strong{display:block;color:#0f2a44;}
.unit-detail{font-size:12px;color:#666;}
</style>

<div class="card">
  <div class="pm-header">
    <h3>Property Portfolio</h3>
    <button class="btn-glass" onclick="openAddProperty()">➕ Add New Listing</button>
  </div>

  <div style="overflow-x:auto;">
    <table class="pm-table">
      <thead>
        <tr>
          <th>Photo</th>
          <th>Property Detail</th>
          <th>Type</th>
          <th>Landlord</th>
          <th>Capacity / Units</th>
          <th>Status</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>

<?php if ($result && $result->num_rows): while($p = $result->fetch_assoc()): ?>
<tr>
  <td>
    <?php
      $display_img = 'assets/no-image.png';
      // Fetch the first uploaded image for this property
      $imgRes = $conn->query("SELECT image_path FROM property_images WHERE property_id = {$p['id']} LIMIT 1");
      if ($imgRes && $imgRes->num_rows > 0) {
        $imgRow = $imgRes->fetch_assoc();
        $display_img = $imgRow['image_path'];
      }
    ?>
    <img src="<?= $display_img ?>" class="property-thumb" onerror="this.src='assets/no-image.png'">
  </td>

  <td>
    <strong style="color:#0f2a44;"><?= htmlspecialchars($p['name']) ?></strong><br>
    <small style="color:#888;"><i class="fa fa-map-marker"></i> <?= htmlspecialchars($p['location']) ?></small>
  </td>

  <td>
    <?php if($p['property_type'] === 'single_house'): ?>
        <span class="badge-type badge-house">🏠 Own Compound</span>
    <?php else: ?>
        <span class="badge-type badge-apt">🏢 Apartment</span>
    <?php endif; ?>
  </td>

  <td>
    <?php if($p['landlord_name']): ?>
      <div class="landlord-info">
        <strong><?= htmlspecialchars($p['landlord_name']) ?></strong>
        <span style="font-size:11px;">📞 <?= htmlspecialchars($p['landlord_phone']) ?></span>
      </div>
    <?php else: ?><span style="color:#ccc;">No Landlord</span><?php endif; ?>
  </td>

  <td>
    <?php if($p['property_type'] === 'single_house'): ?>
        <div class="unit-detail">
            <strong><?= (int)$p['bedrooms'] ?></strong> BR | <strong><?= (int)$p['bathrooms'] ?></strong> BA
        </div>
    <?php else: ?>
        <div class="unit-detail">
            Total Units: <strong><?= (int)$p['total_units'] ?></strong>
        </div>
    <?php endif; ?>
  </td>

  <td>
    <?php if($p['property_type'] === 'apartment'): ?>
        <span style="color:<?= $p['vacant_units'] > 0 ? '#28a745' : '#dc3545' ?>; font-weight:700;">
            <?= (int)$p['vacant_units'] ?> Vacant
        </span>
    <?php else: ?>
        <span style="color:#01579b; font-weight:600;">Available</span>
    <?php endif; ?>
  </td>

  <td>
    <button class="btn btn-sm btn-outline-primary" 
            onclick="manageProperty(<?= $p['id'] ?>,'<?= htmlspecialchars($p['name'],ENT_QUOTES) ?>')">
      ⚙️ Manage
    </button>
  </td>
</tr>
<?php endwhile; else: ?>
<tr>
  <td colspan="7" class="empty-state" style="text-align:center; padding:50px;">
      🏘 No properties listed yet.<br>
      <button class="btn btn-link" onclick="openAddProperty()">Add your first property</button>
  </td>
</tr>
<?php endif; ?>

      </tbody>
    </table>
  </div>
</div>

<div id="addPropertyModal" style="display:none; position:fixed; inset:0; z-index:9999; background:rgba(0,0,0,0.5); align-items:center; justify-content:center;"></div>

<script>
function openAddProperty(){
  const modal = document.getElementById('addPropertyModal');
  // Load the fresh property_add.php with the new logic
  fetch('property_add.php')
    .then(r => r.text())
    .then(html => {
      modal.innerHTML = html;
      modal.style.display = 'flex';
    });
}

function closeAddProperty(){
  document.getElementById('addPropertyModal').style.display = 'none';
}

function manageProperty(propertyId, propertyName){
  loadPage('property_manage.php?property_id=' + propertyId, 'Manage Property – ' + propertyName);
}
</script>