<?php
require_once "db.php";

/* Access control */
if (!isset($_SESSION['user_id'])) {
    exit("Unauthorized");
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    exit("Invalid request");
}

$id = (int)$_GET['id'];

/* Mark message as opened */
$update = $conn->prepare("UPDATE messages SET status='opened' WHERE id=?");
$update->bind_param("i", $id);
$update->execute();
$update->close();

/* Fetch message */
$stmt = $conn->prepare("
    SELECT 
        name, 
        email, 
        COALESCE(phone, '') AS phone,
        type, 
        subject, 
        message, 
        created_at
    FROM messages
    WHERE id = ?
    LIMIT 1
");

if (!$stmt) {
    exit("Query failed: " . $conn->error);
}

$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();

if (!$res->num_rows) {
    exit("Message not found");
}

$m = $res->fetch_assoc();
$stmt->close();
$conn->close();
?>

<div class="modal-backdrop-custom" onclick="closeMessage()">
  <div class="modal-card" onclick="event.stopPropagation()">

    <h3 style="margin-top:0;color:#0f2a44;">📩 Message Details</h3>

    <p><strong>Name:</strong> <?= htmlspecialchars($m['name']) ?></p>

    <p><strong>Phone:</strong> <?= htmlspecialchars($m['phone']) ?></p>

    <?php if (!empty($m['email'])): ?>
      <p><strong>Email:</strong> <?= htmlspecialchars($m['email']) ?></p>
    <?php endif; ?>

    <p><strong>Type:</strong> <?= ucfirst($m['type']) ?></p>
    <p><strong>Subject:</strong> <?= htmlspecialchars($m['subject']) ?></p>

    <hr style="margin:15px 0;">

    <p style="white-space:pre-wrap;">
      <?= nl2br(htmlspecialchars($m['message'])) ?>
    </p>

    <p style="margin-top:15px;font-size:12px;color:#777;">
      Received on <?= date('F j, Y, g:i a', strtotime($m['created_at'])) ?>
    </p>

    <div style="text-align:right;margin-top:20px;">
      <button onclick="closeMessage()"
        style="padding:8px 16px;border:none;border-radius:10px;
               background:#0f2a44;color:#fff;cursor:pointer;">
        Close
      </button>
    </div>

  </div>
</div>
