<?php
require_once "db.php";

/* Only accept POST requests */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit("Invalid request method");
}

/* Collect & sanitize inputs */
$name    = trim($_POST['name'] ?? '');
$email   = trim($_POST['email'] ?? '');
$phone   = trim($_POST['phone'] ?? '');
$type    = trim($_POST['type'] ?? '');
$subject = trim($_POST['subject'] ?? '');
$message = trim($_POST['message'] ?? '');

/* Validate inputs */
$errors = [];

if ($name === '') {
    $errors[] = "Name is required";
}
if ($phone === '') {
    $errors[] = "Phone number is required";
}
if (!in_array($type, ['general', 'complaint'])) {
    $errors[] = "Please select a valid message type";
}
if ($subject === '') {
    $errors[] = "Subject is required";
}
if ($message === '') {
    $errors[] = "Message cannot be empty";
}
if ($email !== '' && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $errors[] = "Email address is invalid";
}

if (!empty($errors)) {
    http_response_code(422);
    exit(implode(". ", $errors));
}

/* Insert message with default status 'new' */
$stmt = $conn->prepare("
    INSERT INTO messages (name, email, phone, type, subject, message, status, created_at)
    VALUES (?, ?, ?, ?, ?, ?, 'new', NOW())
");

if (!$stmt) {
    http_response_code(500);
    exit("Database error: failed to prepare statement");
}

/* Bind parameters and execute */
$stmt->bind_param("ssssss", $name, $email, $phone, $type, $subject, $message);

if (!$stmt->execute()) {
    http_response_code(500);
    exit("Database error: failed to save message");
}

echo "success";

$stmt->close();
$conn->close();
