<?php
require_once "db.php";

// Security check
session_start();
if(!isset($_SESSION['user_id'])){
    http_response_code(403);
    exit("Unauthorized");
}

$type = $_GET['type'] ?? '';
$id   = (int)($_GET['id'] ?? 0); // id of the item to mark as read

switch($type){
    case 'bookings':
        $table = 'bookings';
        break;
    case 'messages':
        $table = 'messages';
        break;
    case 'landlord_requests':
        $table = 'landlord_requests';
        break;
    default:
        http_response_code(400);
        exit("Invalid type");
}

if($id > 0){
    // Mark only the specific item as read
    $stmt = $conn->prepare("UPDATE $table SET is_read = 1 WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
}

// Return updated counts for sidebar badges
$data = [];

$r = $conn->query("SELECT COUNT(*) AS total FROM bookings WHERE is_read = 0");
$data['bookings'] = $r->fetch_assoc()['total'] ?? 0;

$r = $conn->query("SELECT COUNT(*) AS total FROM messages WHERE is_read = 0");
$data['messages'] = $r->fetch_assoc()['total'] ?? 0;

$r = $conn->query("SELECT COUNT(*) AS total FROM landlord_requests WHERE is_read = 0");
$data['requests'] = $r->fetch_assoc()['total'] ?? 0;

echo json_encode($data);
