<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
    exit("Unauthorized");
}
?>

<style>
.landlord-layout{
    display:flex;
    gap:25px;
    min-height:600px;
}

.landlord-list{
    width:320px;
    background:#fff;
    border-radius:14px;
    box-shadow:0 10px 30px rgba(0,0,0,.08);
    overflow:hidden;
}

.landlord-list h3{
    margin:0;
    padding:18px;
    background:#0f2a44;
    color:#fff;
    font-size:16px;
}

.landlord-item{
    padding:15px 18px;
    border-bottom:1px solid #eee;
    cursor:pointer;
    transition:.2s;
}

.landlord-item:hover{
    background:#f4f6f9;
}

.landlord-item.active{
    background:#e9f1ff;
    font-weight:600;
}

.landlord-panel{
    flex:1;
    background:#fff;
    border-radius:14px;
    box-shadow:0 10px 30px rgba(0,0,0,.08);
    padding:25px;
}

.stat-grid{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(150px,1fr));
    gap:20px;
    margin-bottom:30px;
}

.stat-card{
    background:#f4f6f9;
    padding:20px;
    border-radius:12px;
    text-align:center;
}

.stat-card h4{
    margin:0 0 10px;
    font-size:13px;
    color:#555;
}

.stat-card h2{
    margin:0;
    color:#0f2a44;
}

.tab-buttons{
    margin-bottom:20px;
}

.tab-buttons button{
    padding:8px 14px;
    border:none;
    background:#eee;
    border-radius:8px;
    cursor:pointer;
    margin-right:8px;
}

.tab-buttons button.active{
    background:#0f2a44;
    color:#fff;
}

input,select,textarea{
    width:100%;
    padding:10px;
    margin-bottom:12px;
    border-radius:8px;
    border:1px solid #ccc;
}

.manage-btn{
    padding:8px 14px;
    background:#2563eb;
    color:#fff;
    border-radius:8px;
    text-decoration:none;
    font-size:13px;
    display:inline-block;
    margin-top:10px;
}
.manage-btn:hover{
    opacity:.9;
}
</style>

<div class="landlord-layout">

<!-- LEFT: LANDLORD LIST -->
<div class="landlord-list">
<h3>🏢 Landlords</h3>

<?php
$landlords = $conn->query("
    SELECT l.id, l.name, l.email
    FROM landlords l
    ORDER BY l.created_at DESC
");

while($l = $landlords->fetch_assoc()):
?>
<div class="landlord-item"
     onclick="loadLandlord(<?= $l['id'] ?>,this)">
    <?= htmlspecialchars($l['name']) ?><br>
    <small><?= htmlspecialchars($l['email']) ?></small>
</div>
<?php endwhile; ?>

</div>


<!-- RIGHT: LANDLORD PANEL -->
<div class="landlord-panel" id="landlordPanel">
    <h3>Select a landlord to manage</h3>
    <p style="color:#777;margin-top:10px;">
        Click a landlord on the left to:
    </p>
    <ul style="color:#555;">
        <li>View statistics</li>
        <li>Manage properties</li>
        <li>Track repairs</li>
        <li>View income summary</li>
    </ul>
</div>

</div>

<script>
let currentLandlord = null;

function loadLandlord(id,el){
    document.querySelectorAll('.landlord-item')
        .forEach(i=>i.classList.remove('active'));
    el.classList.add('active');

    currentLandlord = id;

    fetch('landlord_details.php?id='+id)
        .then(r=>r.text())
        .then(html=>{
            document.getElementById('landlordPanel').innerHTML=html;
        });
}
</script>
