<?php
require_once "db.php";

/* Extra safety */
if (!isset($_SESSION['user_id'])) {
    exit("Unauthorized");
}

/* FETCH LANDLORD REQUESTS */
$result = $conn->query("
    SELECT 
        id,
        name,
        phone,
        property_name,
        location,
        description,
        created_at
    FROM landlord_management_requests
    ORDER BY created_at DESC
");
?>

<div class="card">
    <h3 style="margin-top:0;color:#0f2a44;">🏘 Landlord Management Requests</h3>

    <?php if (!$result || $result->num_rows === 0): ?>
        <p style="opacity:.7">No management requests yet.</p>
    <?php else: ?>
        <div style="overflow-x:auto;">
            <table style="width:100%;border-collapse:collapse;margin-top:15px;">
                <thead>
                    <tr style="background:#f4f6f9;text-align:left;">
                        <th style="padding:10px;">Name</th>
                        <th style="padding:10px;">Phone</th>
                        <th style="padding:10px;">Property</th>
                        <th style="padding:10px;">Location</th>
                        <th style="padding:10px;">Request</th>
                        <th style="padding:10px;">Date</th>
                        <th style="padding:10px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($r = $result->fetch_assoc()): ?>
                        <tr id="req-row-<?= $r['id'] ?>" style="border-bottom:1px solid #eee;">
                            <td style="padding:10px;font-weight:600;">
                                <?= htmlspecialchars($r['name']) ?>
                            </td>
                            <td style="padding:10px;">
                                <?= htmlspecialchars($r['phone']) ?>
                            </td>
                            <td style="padding:10px;">
                                <?= htmlspecialchars($r['property_name']) ?>
                            </td>
                            <td style="padding:10px;">
                                <?= htmlspecialchars($r['location']) ?>
                            </td>
                            <td style="padding:10px;max-width:260px;">
                                <?= nl2br(htmlspecialchars($r['description'])) ?>
                            </td>
                            <td style="padding:10px;font-size:13px;opacity:.7;">
                                <?= date("d M Y, H:i", strtotime($r['created_at'])) ?>
                            </td>
                            <td style="padding:10px;">
                                <button
                                    onclick='openRequestModal(<?= json_encode($r) ?>)'
                                    style="padding:5px 10px;border-radius:6px;border:1px solid #0f2a44;background:#fff;">
                                    View
                                </button>
                                <button
                                    onclick="deleteRequest(<?= $r['id'] ?>)"
                                    style="padding:5px 10px;border-radius:6px;border:none;background:#dc3545;color:#fff;margin-left:6px;">
                                    Delete
                                </button>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<!-- REQUEST DETAILS MODAL -->
<div id="requestModal" style="
    display:none;
    position:fixed;
    inset:0;
    background:rgba(0,0,0,.55);
    align-items:center;
    justify-content:center;
    z-index:9999;
">
    <div style="
        background:#fff;
        padding:25px;
        width:100%;
        max-width:500px;
        border-radius:14px;
        position:relative;
    ">
        <button onclick="closeRequestModal()"
            style="position:absolute;top:12px;right:14px;border:none;background:none;font-size:22px;cursor:pointer;">
            &times;
        </button>

        <h3 style="margin-top:0;color:#0f2a44;">Request Details</h3>

        <p><strong>Name:</strong> <span id="m_name"></span></p>
        <p><strong>Phone:</strong> <span id="m_phone"></span></p>
        <p><strong>Property:</strong> <span id="m_property"></span></p>
        <p><strong>Location:</strong> <span id="m_location"></span></p>
        <p><strong>Request:</strong><br><span id="m_desc"></span></p>
        <p style="font-size:13px;opacity:.7;">
            <strong>Date:</strong> <span id="m_date"></span>
        </p>
    </div>
</div>

<script>
function openRequestModal(r){
    m_name.innerText = r.name;
    m_phone.innerText = r.phone;
    m_property.innerText = r.property_name;
    m_location.innerText = r.location;
    m_desc.innerText = r.description;
    m_date.innerText = r.created_at;

    document.getElementById('requestModal').style.display = 'flex';
}

function closeRequestModal(){
    document.getElementById('requestModal').style.display = 'none';
}

function deleteRequest(id){
    if (!confirm('Delete this request?')) return;

    fetch('delete_landlord_request.php', {
        method: 'POST',
        headers: {'Content-Type':'application/x-www-form-urlencoded'},
        body: 'id=' + id
    })
    .then(r => r.text())
    .then(r => {
        if (r === 'success') {
            document.getElementById('req-row-' + id).remove();
        } else {
            alert(r);
        }
    })
    .catch(() => alert('Network error'));
}
</script>
