<?php
require_once "db.php";
header('Content-Type: application/json');

/* ================== SANITIZE INPUT ================== */
$landlord_id = (int)($_POST['landlord_id'] ?? 0);
$name        = trim($_POST['name'] ?? '');
$location    = trim($_POST['location'] ?? '');
$type        = $_POST['category'] ?? '';
$description = trim($_POST['description'] ?? '');
$bedrooms    = (int)($_POST['bedrooms'] ?? 0);
$bathrooms   = (int)($_POST['bathrooms'] ?? 0);

$mixedUnits  = json_decode($_POST['mixedUnits'] ?? '[]', true);
$unitType    = $_POST['unitType'] ?? '';
$unitCount   = (int)($_POST['unitCount'] ?? 0);

/* ================== VALIDATION ================== */
if ($landlord_id <= 0) {
    echo json_encode(["status"=>"error","message"=>"Invalid landlord ID"]);
    exit;
}

if ($name === '' || $location === '' || !in_array($type,['single_house','apartment'])) {
    echo json_encode(["status"=>"error","message"=>"Required property fields are missing"]);
    exit;
}

/* ================== INSERT PROPERTY ================== */
$code = strtoupper(substr(md5(time().$name), 0, 8));

$stmt = $conn->prepare("INSERT INTO properties (landlord_id, name, code, location, property_type, description, bedrooms, bathrooms) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("isssssii", $landlord_id, $name, $code, $location, $type, $description, $bedrooms, $bathrooms);

if ($stmt->execute()) {
    $property_id = $stmt->insert_id;
    $stmt->close();

    /* ================== HANDLE APARTMENT MIXED UNITS ================== */
    if ($type === 'apartment') {

        if ($unitType === 'mixed' && count($mixedUnits) > 0) {
            // store as comma separated types in description (optional) or separate table if needed
            $description .= "\nMixed Units: " . implode(", ", $mixedUnits);

            $stmt = $conn->prepare("UPDATE properties SET description=? WHERE id=?");
            $stmt->bind_param("si", $description, $property_id);
            $stmt->execute();
            $stmt->close();
        }

        if ($unitCount > 0) {
            // Optional: store total units in property_units table
            $stmt = $conn->prepare("INSERT INTO property_units (property_id, units_count, vacant_count) VALUES (?,?,?)");
            $stmt->bind_param("iii", $property_id, $unitCount, $unitCount);
            $stmt->execute();
            $stmt->close();
        }
    }

    echo json_encode(["status"=>"success","message"=>"Property added successfully"]);

} else {
    echo json_encode(["status"=>"error","message"=>"Database error: ".$conn->error]);
}
