<?php
require_once "db.php";

if (!isset($_GET['id'])) exit("Invalid request");

$landlord_id = (int) $_GET['id'];

/* ---------------- LANDLORD INFO ---------------- */
$stmt = $conn->prepare("SELECT * FROM landlords WHERE id=? LIMIT 1");
$stmt->bind_param("i", $landlord_id);
$stmt->execute();
$landlord = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$landlord) exit("Landlord not found");

/* ---------------- STATS ---------------- */
/* Total properties */
$stmt = $conn->prepare("SELECT COUNT(*) AS c FROM properties WHERE landlord_id=?");
$stmt->bind_param("i", $landlord_id);
$stmt->execute();
$totalProps = $stmt->get_result()->fetch_assoc()['c'] ?? 0;
$stmt->close();

/* Total repairs - only if table exists */
$totalRepairs = 0;
$tableExists = $conn->query("SHOW TABLES LIKE 'repairs'");
if ($tableExists && $tableExists->num_rows > 0) {
    $stmt = $conn->prepare("SELECT COUNT(*) AS c FROM repairs WHERE landlord_id=?");
    $stmt->bind_param("i", $landlord_id);
    $stmt->execute();
    $totalRepairs = $stmt->get_result()->fetch_assoc()['c'] ?? 0;
    $stmt->close();
}
?>

<h2><?= htmlspecialchars($landlord['name']) ?></h2>
<p>Email: <?= htmlspecialchars($landlord['email']) ?></p>
<p>Phone: <?= htmlspecialchars($landlord['phone']) ?></p>

<div class="stat-grid">
    <div class="stat-card">
        <h4>Properties</h4>
        <h2><?= $totalProps ?></h2>
    </div>
    <div class="stat-card">
        <h4>Repairs</h4>
        <h2><?= $totalRepairs ?></h2>
    </div>
</div>

<div class="tab-buttons">
    <button onclick="showTab('properties', this)" class="active">Properties</button>
    <button onclick="showTab('repairs', this)">Repairs</button>
</div>

<div id="tabContent">
    <!-- DEFAULT PROPERTIES TAB -->
    <h3>Add Property</h3>

    <form id="landlordPropertyForm" onsubmit="addProperty(event, <?= $landlord_id ?>)">

      <div>
        <input type="text" id="propName" placeholder="Property Name" required>
      </div>

      <div>
        <input type="text" id="propLocation" placeholder="Location" required>
      </div>

      <div>
        <select id="propCategory" onchange="toggleCategoryFields()" required>
          <option value="">Select Category</option>
          <option value="single_house">Single House / Own Compound</option>
          <option value="apartment">Flats / Apartment</option>
        </select>
      </div>

      <div id="singleHouseWrap" style="display:none;">
        <div><input type="number" id="bedrooms" min="0" placeholder="Number of Bedrooms"></div>
        <div><input type="number" id="bathrooms" min="0" placeholder="Number of Bathrooms"></div>
      </div>

      <div id="apartmentWrap" style="display:none;">
        <div>
          <select id="unitType" onchange="toggleUnitType()">
            <option value="">Select Type of Units</option>
            <option value="studio">Studio / Bedsitter</option>
            <option value="1br">1 Bedroom</option>
            <option value="2br">2 Bedroom</option>
            <option value="3br">3 Bedroom</option>
            <option value="4br">4 Bedroom</option>
            <option value="4plus">4+ Bedroom</option>
            <option value="mixed">Mixed</option>
          </select>
        </div>

        <div id="mixedWrap" style="display:none;">
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="studio"> Studio</div>
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="1br"> 1 Bedroom</div>
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="2br"> 2 Bedroom</div>
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="3br"> 3 Bedroom</div>
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="4br"> 4 Bedroom</div>
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="4plus"> 4+ Bedroom</div>
        </div>

        <div id="unitCountWrap" style="display:none;">
          <input type="number" id="unitCount" min="1" placeholder="Total Number of Units">
        </div>

      </div>

      <div>
        <textarea id="description" placeholder="Property Description"></textarea>
      </div>

      <div class="pm-actions">
        <button type="submit" class="btn-save" style="background:#0f2a44;color:#fff;">Add Property</button>
      </div>

    </form>

    <hr>

    <h3>Existing Properties</h3>

    <?php
    $stmt = $conn->prepare("SELECT * FROM properties WHERE landlord_id=?");
    $stmt->bind_param("i", $landlord_id);
    $stmt->execute();
    $props = $stmt->get_result();

    while($p = $props->fetch_assoc()):
    ?>
    <div style="padding:10px 0;border-bottom:1px solid #eee">
        <strong><?= htmlspecialchars($p['name']) ?></strong><br>
        <small><?= htmlspecialchars($p['location']) ?></small>
    </div>
    <?php endwhile; $stmt->close(); ?>
</div>

<script>
function showTab(tab, btn){
    document.querySelectorAll('.tab-buttons button')
        .forEach(b => b.classList.remove('active'));
    btn.classList.add('active');

    fetch(`landlord_tab.php?id=<?= $landlord_id ?>&tab=${tab}`)
        .then(r => r.text())
        .then(html => {
            document.getElementById('tabContent').innerHTML = html;
        });
}

function toggleCategoryFields(){
    singleHouseWrap.style.display = (propCategory.value === 'single_house') ? 'block' : 'none';
    apartmentWrap.style.display = (propCategory.value === 'apartment') ? 'block' : 'none';
}

function toggleUnitType(){
    mixedWrap.style.display = (unitType.value === 'mixed') ? 'block' : 'none';
    unitCountWrap.style.display = unitType.value ? 'block' : 'none';
}

function addProperty(e, landlordId){
    e.preventDefault();

    const formData = new FormData();

    formData.append('landlord_id', landlordId);
    formData.append('name', propName.value);
    formData.append('location', propLocation.value);
    formData.append('category', propCategory.value);
    formData.append('description', description.value);

    if(propCategory.value === 'single_house'){
        formData.append('bedrooms', bedrooms.value);
        formData.append('bathrooms', bathrooms.value);
    }

    if(propCategory.value === 'apartment'){
        formData.append('unitType', unitType.value);
        formData.append('unitCount', unitCount.value);

        if(unitType.value === 'mixed'){
            let selected = [];
            document.querySelectorAll('.mixedUnit:checked').forEach(cb=>{
                selected.push(cb.value);
            });
            formData.append('mixedUnits', JSON.stringify(selected));
        }
    }

    fetch('landlord_property_save.php',{method:'POST',body:formData})
        .then(res=>res.json())
        .then(data=>{
            if(data.status === 'success'){
                alert('✅ Property added successfully');
                showTab('properties', document.querySelector('.tab-buttons button.active'));
            }else{
                alert(data.message || '❌ Failed to add property');
            }
        })
        .catch(()=>alert('❌ Failed to add property'));
}
</script>
