<?php
require_once "db.php";

/* FETCH VACANT HOUSE HIGHLIGHTS (MAX 6) */
$vacantHouses = $conn->query("
  SELECT 
    p.id,
    p.name,
    p.location,
    p.description,
    p.main_image,
    (
      SELECT COALESCE(SUM(u.vacant_count),0)
      FROM property_units u
      WHERE u.property_id = p.id
    ) AS vacant_units
  FROM properties p
  HAVING vacant_units > 0
  ORDER BY p.created_at DESC
  LIMIT 6
");
?>


<!DOCTYPE html>
<html>

<head>
  <!-- Basic -->
  <meta charset="utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <!-- Mobile Metas -->
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <!-- Site Metas -->
  <meta name="keywords" content="" />
  <meta name="description" content="" />
  <meta name="author" content="" />

  <title>Lifeshed Realtors</title>
<link rel="icon" type="image/png" href="images/Lifeshedlogo.png">

  <!-- bootstrap core css -->
  <link rel="stylesheet" type="text/css" href="css/bootstrap.css" />

  <!-- fonts style -->
  <link href="https://fonts.googleapis.com/css?family=Poppins:400,700|Raleway:400,700&display=swap" rel="stylesheet">
  <!-- Custom styles for this template -->
  <link href="css/style.css" rel="stylesheet" />
  <!-- responsive style -->
  <link href="css/responsive.css" rel="stylesheet" />
</head>

<body>
<div class="hero_area">
  <header class="header_section" style="background: #001f3f; border-bottom: 2px solid #FFD700;">
    <div class="container-fluid">
      <nav class="navbar navbar-expand-lg custom_nav-container">
        <a class="navbar-brand" href="index.php">
          <img src="images/Lifeshedlogo.png" alt="Lifeshed Realtors" style="max-width: 180px;" />
        </a>
        
        <div class="navbar-collapse d-flex justify-content-end align-items-center" id="">
          <ul class="navbar-nav">
            <li class="nav-item">
              <?php if (!isset($_SESSION['user_id'])): ?>
                <a href="login.php" class="nav-link login-btn" style="
                  color: #001f3f; 
                  background: #FFD700; 
                  padding: 8px 25px; 
                  border-radius: 5px; 
                  font-weight: 700; 
                  transition: 0.3s;
                  margin-right: 20px;
                  text-transform: uppercase;
                  font-size: 14px;
                ">Login</a>
              <?php else: ?>
                <a href="logout.php" class="nav-link" style="color: #FFD700; font-weight: 600;">Logout</a>
              <?php endif; ?>
            </li>
          </ul>

          <div class="custom_menu-btn">
            <button onclick="openNav()" style="border: none; background: transparent;">
              <span class="s-1" style="background: #FFD700;"></span>
              <span class="s-2" style="background: #FFD700;"></span>
              <span class="s-3" style="background: #FFD700;"></span>
            </button>
          </div>

          <div id="myNav" class="overlay" style="background-color: rgba(0, 31, 63, 0.95);">
            <div class="overlay-content">
              <a href="index.php" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Home</a>
              <a href="about.html" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">The Story of Lifeshed</a>
              <a href="house.php" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">House Listings</a>
              <a href="contact.php" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Contact Lifeshed Now</a>
            </div>
          </div>
        </div>
      </nav>
    </div>
  </header>
</div>

<style>
  /* Custom Styles for the Header Elements */
  .login-btn:hover {
    background: #fff !important;
    color: #001f3f !important;
    box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);
  }

  .custom_menu-btn button span {
    display: block;
    width: 30px;
    height: 3px;
    margin-bottom: 5px;
    transition: all 0.3s;
  }
  
  .overlay-content a {
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 1px;
    transition: 0.3s;
  }
</style>
    <!-- end header section -->


    <!-- slider section -->
<!-- Google Font -->
<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Poppins:wght@300;400;500&display=swap" rel="stylesheet">

<section class="slider_section">
  <div class="container-fluid">
    <div class="row align-items-center">

      <!-- LEFT CONTENT -->
      <div class="col-md-5 offset-md-1">
        <div class="detail-box">
          <h1>
            <span>Lifeshed</span> <br>
            Realtors <br>
            & Property Managers
          </h1>

<p style="color: #ffffff; opacity: 1;">
  We provide reliable property management, rental solutions, and real estate services 
  designed to give you peace of mind and lasting value.
</p>

          <div class="btn-box">
            <a href="house.php" class="gold-btn">
              View Properties
            </a>
          </div>
        </div>
      </div>

      <!-- RIGHT LOGO -->
      <div class="col-md-5 text-center">
        <div class="logo-box">
          <img src="images/Lifeshedlogo.png" alt="Lifeshed Logo">
        </div>
      </div>

    </div>
  </div>
</section>

<style>

/* ================= HERO SECTION ================= */

.slider_section {
  min-height: 100vh;
  display: flex;
  align-items: center;
  background: linear-gradient(135deg, #081c3a, #0d2c63, #0a1f44);
  color: #ffffff;
  position: relative;
  overflow: hidden;
  padding: 80px 0;
}

/* GOLD AMBIENT GLOW */
.slider_section::before {
  content: "";
  position: absolute;
  top: -150px;
  right: -150px;
  width: 500px;
  height: 500px;
  background: radial-gradient(circle, rgba(212,175,55,0.25) 0%, transparent 70%);
  animation: pulseGlow 6s ease-in-out infinite;
}

/* ================= TEXT ================= */

.detail-box {
  animation: slideInLeft 1.2s ease forwards;
  opacity: 0;
  position: relative;
  z-index: 2;
}

.detail-box h1 {
  font-family: 'Playfair Display', serif;
  font-size: 3rem;
  font-weight: 700;
  line-height: 1.2;
  color: #ffffff;
}

/* Lifeshed in PURE WHITE */
.slider_section .detail-box h1 span {
  color: #ffffff !important;
  letter-spacing: 1px;
  text-shadow: 
    0 0 10px rgba(212,175,55,0.8),
    0 0 20px rgba(212,175,55,0.7),
    0 0 35px rgba(212,175,55,0.6);
}

/* Gold accent for second line */
.detail-box h1 br + text {
  color: #d4af37;
}

.detail-box p {
  margin-top: 20px;
  font-family: 'Poppins', sans-serif;
  font-size: 16px;
  color: #f1f1f1;
  line-height: 1.6;
  max-width: 500px;
}

/* ================= BUTTON ================= */

.gold-btn {
  display: inline-block;
  margin-top: 30px;
  padding: 14px 35px;
  background: linear-gradient(45deg, #d4af37, #f6e27a);
  color: #081c3a;
  font-weight: 600;
  border-radius: 40px;
  text-decoration: none;
  transition: all 0.4s ease;
  box-shadow: 0 6px 20px rgba(212,175,55,0.5);
}

.gold-btn:hover {
  transform: translateY(-6px);
  box-shadow: 0 12px 35px rgba(212,175,55,0.8);
  background: linear-gradient(45deg, #f6e27a, #d4af37);
}

/* ================= LOGO ================= */

.logo-box {
  animation: slideInRight 1.5s ease forwards;
  opacity: 0;
  position: relative;
  z-index: 2;
}

.logo-box img {
  max-width: 80%;
  filter: drop-shadow(0 0 25px rgba(212,175,55,0.6));
  transition: transform 0.6s ease, filter 0.6s ease;
}

.logo-box img:hover {
  transform: scale(1.08);
  filter: drop-shadow(0 0 40px rgba(212,175,55,0.9));
}

/* ================= ANIMATIONS ================= */

@keyframes slideInLeft {
  from {
    transform: translateX(-80px);
    opacity: 0;
  }
  to {
    transform: translateX(0);
    opacity: 1;
  }
}

@keyframes slideInRight {
  from {
    transform: translateX(80px);
    opacity: 0;
  }
  to {
    transform: translateX(0);
    opacity: 1;
  }
}

@keyframes pulseGlow {
  0%, 100% { opacity: 0.4; transform: scale(1); }
  50% { opacity: 0.8; transform: scale(1.15); }
}

/* ================= RESPONSIVE ================= */

@media (max-width: 768px) {
  .detail-box h1 {
    font-size: 2.2rem;
  }

  .logo-box {
    margin-top: 40px;
  }
}

</style>
<!-- end slider section -->

  </div>



<section id="what-we-do" style="padding: 80px 0; background: linear-gradient(135deg, #f5f7fa, #e4ebf5); overflow: hidden;">

  <style>
    /* Base Glass Morphism Styling */
    .glass-card {
      height: 100%;
      padding: 35px 25px;
      border-radius: 24px;
      background: rgba(255, 255, 255, 0.3);
      backdrop-filter: blur(15px);
      -webkit-backdrop-filter: blur(15px);
      border: 1px solid rgba(255, 255, 255, 0.5);
      box-shadow: 0 8px 32px rgba(31, 38, 135, 0.1);
      transition: all 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
      text-align: center;
      cursor: pointer;
    }

    .glass-card:hover {
      transform: translateY(-12px);
      box-shadow: 0 20px 45px rgba(31, 38, 135, 0.2);
      background: rgba(255, 255, 255, 0.5);
      border: 1px solid rgba(255, 255, 255, 0.8);
    }

    .glass-card h4 {
      font-weight: 700;
      color: #2c3e50;
      margin-bottom: 15px;
    }

    .glass-card p {
      color: #555;
      font-size: 15px;
      line-height: 1.7;
    }

    /* Directional Entry Animations */
    .reveal-left {
      opacity: 0;
      transform: translateX(-100px);
      transition: all 1s ease-out;
    }

    .reveal-right {
      opacity: 0;
      transform: translateX(100px);
      transition: all 1s ease-out;
    }

    .reveal-center {
      opacity: 0;
      transform: scale(0.8);
      transition: all 0.8s ease-out;
    }

    /* Active States triggered by JS */
    .reveal-left.show,
    .reveal-right.show {
      opacity: 1;
      transform: translateX(0);
    }

    .reveal-center.show {
      opacity: 1;
      transform: scale(1);
    }

    .what-we-do-heading h2 {
      font-weight: 800;
      letter-spacing: -0.5px;
      margin-bottom: 10px;
    }

    @media(max-width: 768px) {
      .reveal-left, .reveal-right {
        transform: translateY(40px); /* Better for mobile */
      }
    }
  </style>

<section class="what-we-do-section">
  <div class="container">
    <div class="row">
      <div class="col-12 text-center what-we-do-heading">
        <h2>What We Do</h2>
        <p>Professional real estate solutions you can trust</p>
      </div>
    </div>

    <div class="row justify-content-center">

      <div class="col-md-4 mb-4 reveal-left">
        <div class="glass-card">
          <h4>Property Management</h4>
          <p>
            We offer comprehensive property management services including rent
            collection, tenant relations, maintenance coordination, and
            detailed reporting for property owners.
          </p>
        </div>
      </div>

      <div class="col-md-4 mb-4 reveal-center">
        <div class="glass-card">
          <h4>Estate Agency</h4>
          <p>
            Our estate agency services connect buyers, sellers, landlords,
            and tenants through professional marketing, leasing, and sales
            solutions.
          </p>
        </div>
      </div>

      <div class="col-md-4 mb-4 reveal-right">
        <div class="glass-card">
          <h4>Consultancy</h4>
          <p>
            We provide expert real estate consultancy, offering market insights,
            property valuation guidance, and investment advisory services.
          </p>
        </div>
      </div>

    </div>
  </div>
</section>

<style>

/* SECTION BACKGROUND */
.what-we-do-section {
  padding: 100px 0;
  background: linear-gradient(135deg, #0a1f44, #0d2c63);
  position: relative;
  overflow: hidden;
  color: #ffffff;
}

/* Gold Glow Accent */
.what-we-do-section::before {
  content: "";
  position: absolute;
  top: -200px;
  right: -200px;
  width: 500px;
  height: 500px;
  background: radial-gradient(circle, rgba(212,175,55,0.25) 0%, transparent 70%);
  z-index: 0;
}

/* HEADING */
.what-we-do-heading h2 {
  font-size: 40px;
  font-weight: 700;
  color: #ffffff;
  position: relative;
  display: inline-block;
}

.what-we-do-heading h2::after {
  content: "";
  display: block;
  width: 70px;
  height: 4px;
  margin: 12px auto 0;
  background: linear-gradient(to right, #d4af37, #f6e27a);
  border-radius: 2px;
}

.what-we-do-heading p {
  margin-top: 15px;
  color: #e6e6e6;
  font-size: 16px;
}

/* CARD STYLE */
.glass-card {
  background: rgba(255, 255, 255, 0.08);
  border: 1px solid rgba(212, 175, 55, 0.3);
  backdrop-filter: blur(10px);
  padding: 35px;
  border-radius: 15px;
  text-align: center;
  transition: all 0.4s ease;
  position: relative;
  z-index: 1;
  height: 100%;
}

/* CARD TITLE */
.glass-card h4 {
  color: #d4af37;
  font-weight: 600;
  margin-bottom: 15px;
}

/* CARD TEXT */
.glass-card p {
  color: #ffffff;
  font-size: 15px;
  line-height: 1.6;
}

/* HOVER EFFECT */
.glass-card:hover {
  transform: translateY(-10px);
  background: rgba(255, 255, 255, 0.12);
  box-shadow: 0 10px 30px rgba(212,175,55,0.4);
  border: 1px solid #d4af37;
}

/* ENTRY ANIMATIONS */
.reveal-left {
  animation: slideLeft 1s ease forwards;
}

.reveal-center {
  animation: fadeUp 1.2s ease forwards;
}

.reveal-right {
  animation: slideRight 1s ease forwards;
}

@keyframes slideLeft {
  from { opacity: 0; transform: translateX(-60px); }
  to { opacity: 1; transform: translateX(0); }
}

@keyframes slideRight {
  from { opacity: 0; transform: translateX(60px); }
  to { opacity: 1; transform: translateX(0); }
}

@keyframes fadeUp {
  from { opacity: 0; transform: translateY(40px); }
  to { opacity: 1; transform: translateY(0); }
}

/* RESPONSIVE */
@media (max-width: 768px) {
  .what-we-do-heading h2 {
    font-size: 30px;
  }
}

</style>

  <script>
    // Simple script to trigger animations on scroll
    const observerOptions = { threshold: 0.2 };
    
    const observer = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          entry.target.classList.add('show');
        }
      });
    }, observerOptions);

    document.querySelectorAll('.reveal-left, .reveal-center, .reveal-right').forEach(el => {
      observer.observe(el);
    });
  </script>

</section>






 <section class="action-section">
  <div class="container">
    <div class="row justify-content-center">

      <!-- Book a vacant house -->
      <div class="col-md-4 mb-4 reveal-up">
        <div class="action-card">
          <h4>Book a Vacant House</h4>
          <p>
            Looking for a house to rent? Browse our available properties and
            book a vacant house that suits your needs.
          </p>
          <a href="house.php">View Vacancies</a>
        </div>
      </div>

      <!-- Landlord management request -->
      <div class="col-md-4 mb-4 reveal-up">
        <div class="action-card">
          <h4>Are You a Landlord?</h4>
          <p>
            Let Lifeshed Realtors manage your property professionally.
            Request for property management services today.
          </p>
          <a href="javascript:void(0)" onclick="openLandlordModal()">Request Management</a>
        </div>
      </div>

      <!-- Tenant suggestion box -->
      <div class="col-md-4 mb-4 reveal-up">
        <div class="action-card">
          <h4>Tenant Comments/Complains</h4>
          <p>
            We value your feedback. Share your suggestions or concerns to
            help us improve our services.
          </p>
          <a href="contact.php">Talk To Us</a>
        </div>
      </div>

    </div>
  </div>
</section>

<style>

/* ================= ACTION SECTION ================= */

.action-section {
  padding: 100px 0;
  background: linear-gradient(135deg, #081c3a, #0d2c63);
  position: relative;
  overflow: hidden;
}

/* Soft gold ambient glow */
.action-section::before {
  content: "";
  position: absolute;
  bottom: -150px;
  left: -150px;
  width: 450px;
  height: 450px;
  background: radial-gradient(circle, rgba(212,175,55,0.25) 0%, transparent 70%);
}

/* CARD STYLE */
.action-card {
  height: 100%;
  padding: 40px 30px;
  border-radius: 20px;
  background: rgba(255,255,255,0.06);
  border: 1px solid rgba(212,175,55,0.3);
  backdrop-filter: blur(12px);
  -webkit-backdrop-filter: blur(12px);
  text-align: center;
  transition: all 0.4s ease;
  color: #ffffff;
  box-shadow: 0 12px 35px rgba(0,0,0,0.3);
}

/* CARD TITLE */
.action-card h4 {
  font-weight: 700;
  margin-bottom: 15px;
  color: #f6e27a;
}

/* CARD TEXT */
.action-card p {
  color: #e6edf7;
  line-height: 1.6;
  margin-bottom: 25px;
}

/* BUTTON */
.action-card a {
  display: inline-block;
  padding: 12px 30px;
  background: linear-gradient(45deg, #d4af37, #f6e27a);
  color: #081c3a;
  border-radius: 40px;
  font-weight: 600;
  text-decoration: none;
  transition: all 0.3s ease;
}

/* HOVER EFFECT */
.action-card:hover {
  transform: translateY(-10px);
  box-shadow: 0 20px 45px rgba(212,175,55,0.4);
  border: 1px solid #d4af37;
}

.action-card a:hover {
  transform: translateY(-4px);
  box-shadow: 0 8px 25px rgba(212,175,55,0.7);
}

/* ENTRY ANIMATION */
.reveal-up {
  opacity: 0;
  transform: translateY(40px);
  animation: fadeUp 1s ease forwards;
}

@keyframes fadeUp {
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

/* RESPONSIVE */
@media (max-width: 768px) {
  .action-card {
    padding: 30px 20px;
  }
}

</style>
<!-- end action section -->

  <!-- about section -->
<!-- about section -->
<section class="about_section layout_padding-bottom" style="padding-bottom: 80px;">

  <style>
    .about_lifeshed h2 {
      font-weight: 700;
      margin-bottom: 15px;
    }

    .about_lifeshed p {
      color: #444;
      line-height: 1.7;
      margin-bottom: 20px;
    }

    .about_lifeshed ul {
      padding-left: 18px;
      margin-bottom: 25px;
    }

    .about_lifeshed ul li {
      margin-bottom: 8px;
      color: #333;
    }

    .about_lifeshed a {
      display: inline-block;
      padding: 10px 28px;
      background: #2c2c2c;
      color: #fff;
      text-decoration: none;
      border-radius: 6px;
      transition: background 0.3s ease;
    }

    .about_lifeshed a:hover {
      background: #000;
    }

    .about_img img {
      border-radius: 18px;
      box-shadow: 0 15px 40px rgba(0,0,0,0.15);
    }
  </style>









  <div class="square-box">
    <img src="images/hao" alt="hao11.JPG">
  </div>

  <div class="container">
    <div class="row align-items-center">

      <div class="col-md-6">
        <div class="img-box about_img">
          <img src="images/Lifeshedlogo.png" alt="Lifeshed Realtors">
        </div>
      </div>

      <div class="col-md-6">
        <div class="detail-box about_lifeshed">
          <div class="heading_container">
            <h2>About Lifeshed Realtors</h2>
          </div>

          <p>
            Lifeshed Realtors is a trusted real estate firm specializing in
            property management, estate agency, and real estate consultancy.
            We are committed to delivering reliable, transparent, and
            value-driven property solutions.
          </p>

          <p>
            Our approach combines market knowledge, professional service,
            and modern systems to ensure property owners, tenants, and
            investors experience seamless real estate management.
          </p>

          <ul>
            <li>✔ Professional property management</li>
            <li>✔ Transparent rent collection & reporting</li>
            <li>✔ Strategic property marketing</li>
            <li>✔ Expert real estate advisory</li>
          </ul>

          <a href="about.html">Learn More</a>
        </div>
      </div>

    </div>
  </div>
</section>
<!-- end about section -->


<!-- Our Happy Partners Section -->
<section style="padding: 70px 0; background: #001f3f; overflow: hidden;"> <style>
    .partners-heading h2 {
      font-weight: 700;
      margin-bottom: 10px;
      color: #FFD700; /* Gold */
    }

    .partners-heading p {
      color: #ffffff; /* White */
      margin-bottom: 40px;
      opacity: 0.9;
    }

    .partners-wrapper {
      width: 100%;
      overflow: hidden;
      position: relative;
    }

    .partners-track {
      display: flex;
      width: max-content;
      animation: scrollPartners 30s linear infinite;
    }

    /* REMOVED: .partners-wrapper:hover .partners-track 
       This ensures the animation NEVER stops even when touched */

    .partner-card {
      min-width: 260px;
      margin: 0 15px;
      padding: 25px 20px;
      border-radius: 16px;
      background: #ffffff; /* Pure White Card */
      border: 2px solid #FFD700; /* Gold Border */
      box-shadow: 0 10px 30px rgba(0,0,0,0.3);
      text-align: center;
      flex-shrink: 0;
    }

    .partner-card img {
      width: 70px;
      height: 70px;
      object-fit: contain;
      margin-bottom: 15px;
      /* Optional: gives images a professional look if they have white backgrounds */
      filter: drop-shadow(0px 2px 4px rgba(0,0,0,0.1));
    }

    .partner-card h5 {
      font-weight: 700;
      margin-bottom: 6px;
      color: #001f3f; /* Navy Blue Text */
    }

    .partner-card p {
      font-size: 14px;
      color: #555; /* Dark Grey for readability */
      margin: 0;
      font-weight: 500;
    }

    /* TRUE infinite scroll animation */
    @keyframes scrollPartners {
      from {
        transform: translateX(0);
      }
      to {
        transform: translateX(-50%);
      }
    }
  </style>

  <div class="container">
    <div class="row">
      <div class="col-12 text-center partners-heading">
        <h2>Our Happy Partners</h2>
        <p>Trusted collaborations that help us deliver excellence</p>
      </div>
    </div>
  </div>

  <div class="partners-wrapper">
    <div class="partners-track">

      <div class="partner-card">
        <img src="images/greenfield.jpg" alt="Greenfield Holdings">
        <h5>Greenfield Holdings</h5>
        <p>Residential Property Owners</p>
      </div>

      <div class="partner-card">
        <img src="images/abancrestpng.png" alt="Urban Crest Ltd">
        <h5>Urban Crest Ltd</h5>
        <p>Commercial Real Estate</p>
      </div>

      <div class="partner-card">
        <img src="images/rimeStayHomes.jpg" alt="PrimeStay Homes">
        <h5>PrimeStay Homes</h5>
        <p>Rental Apartments</p>
      </div>

      <div class="partner-card">
        <img src="images/bluerock.png" alt="BlueRock Developers">
        <h5>BlueRock Developers</h5>
        <p>Property Development</p>
      </div>

      <div class="partner-card">
        <img src="images/vista.png" alt="Vista Property Group">
        <h5>Vista Property Group</h5>
        <p>Mixed-Use Properties</p>
      </div>

      <div class="partner-card">
        <img src="images/elitepng.png" alt="Elite Living Spaces">
        <h5>Elite Living Spaces</h5>
        <p>Luxury Housing</p>
      </div>

      <div class="partner-card">
        <img src="images/greenfield.jpg" alt="Greenfield Holdings">
        <h5>Greenfield Holdings</h5>
        <p>Residential Property Owners</p>
      </div>

      <div class="partner-card">
        <img src="images/abancrestpng.png" alt="Urban Crest Ltd">
        <h5>Urban Crest Ltd</h5>
        <p>Commercial Real Estate</p>
      </div>

      <div class="partner-card">
        <img src="images/rimeStayHomes.jpg" alt="PrimeStay Homes">
        <h5>PrimeStay Homes</h5>
        <p>Rental Apartments</p>
      </div>

      <div class="partner-card">
        <img src="images/bluerock.png" alt="BlueRock Developers">
        <h5>BlueRock Developers</h5>
        <p>Property Development</p>
      </div>

      <div class="partner-card">
        <img src="images/vista.png" alt="Vista Property Group">
        <h5>Vista Property Group</h5>
        <p>Mixed-Use Properties</p>
      </div>

      <div class="partner-card">
        <img src="images/elitepng.png" alt="Elite Living Spaces">
        <h5>Elite Living Spaces</h5>
        <p>Luxury Housing</p>
      </div>
    </div>
  </div>
</section>
</section>
<!-- end our happy partners section -->









<!-- 3 combo column start section -->

<!-- action section -->
<section style="padding: 80px 0; background: linear-gradient(135deg, #f7f9fc, #eef2f7);">

  <style>
    .action-card {
      height: 100%;
      padding: 35px 28px;
      border-radius: 18px;
      background: #ffffff;
      box-shadow: 0 12px 35px rgba(0,0,0,0.1);
      text-align: center;
      transition: all 0.35s ease;
    }

    .action-card:hover {
      transform: translateY(-10px);
      box-shadow: 0 20px 45px rgba(0,0,0,0.18);
    }

    .action-card h4 {
      font-weight: 700;
      margin-bottom: 15px;
    }

    .action-card p {
      color: #444;
      line-height: 1.6;
      margin-bottom: 25px;
    }

    .action-card a {
      display: inline-block;
      padding: 12px 28px;
      background: #2c2c2c;
      color: #ffffff;
      text-decoration: none;
      border-radius: 6px;
      font-weight: 500;
      transition: background 0.3s ease;
    }

    .action-card a:hover {
      background: #000000;
    }
  </style>

 


<!-- 3 column combo end section -->


<!--End of our partners sectuion-->




 <!-- house listings section -->
<section class="sale_section" style="padding: 70px 0; background: #001f3f; margin-top: 0; border-top: 1px solid rgba(255, 215, 0, 0.2);">

  <style>
    /* Heading Styles for Contrast */
    .heading_container h2 {
      font-weight: 700;
      color: #FFD700; /* Gold */
      text-transform: capitalize;
    }

    .heading_container p {
      color: #ffffff; /* White for dark bg */
      opacity: 0.9;
      margin-bottom: 30px;
    }

    .house-grid {
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      gap: 25px;
      margin-top: 40px;
    }

    @media (max-width: 1200px) {
      .house-grid { grid-template-columns: repeat(3, 1fr); }
    }

    @media (max-width: 992px) {
      .house-grid { grid-template-columns: repeat(2, 1fr); }
    }

    @media (max-width: 576px) {
      .house-grid { grid-template-columns: 1fr; }
    }

    .house-card {
      border-radius: 18px;
      overflow: hidden;
      text-decoration: none;
      background: #ffffff; /* Solid White Card */
      border: 2px solid #FFD700; /* Gold Border */
      box-shadow: 0 10px 30px rgba(0,0,0,0.4);
      transition: all 0.35s ease;
      display: block;
    }

    .house-card:hover {
      transform: translateY(-10px);
      box-shadow: 0 15px 40px rgba(255, 215, 0, 0.2); /* Subtle Gold glow */
      text-decoration: none;
    }

    .house-card img {
      width: 100%;
      height: 180px;
      object-fit: cover;
      border-bottom: 2px solid #FFD700;
    }

    .house-card-content {
      padding: 18px;
    }

    .house-card-content h6 {
      font-weight: 700;
      margin-bottom: 8px;
      color: #001f3f; /* Navy text on white card */
      font-size: 1.1rem;
    }

    .house-card-content p {
      font-size: 14px;
      margin: 0;
      color: #444; /* High contrast grey */
      font-weight: 500;
    }

    .vacant-count {
      display: inline-block;
      margin-top: 12px;
      font-weight: 700;
      font-size: 13px;
      color: #b8860b; /* Dark Gold/Bronze for visibility */
      background: rgba(255, 215, 0, 0.1);
      padding: 4px 10px;
      border-radius: 50px;
    }

    /* Button Styling */
    .btn-box a {
      display: inline-block;
      padding: 12px 35px;
      background-color: #FFD700;
      color: #001f3f;
      border: 2px solid #FFD700;
      border-radius: 8px;
      font-weight: 700;
      transition: all 0.3s ease;
      text-decoration: none;
    }

    .btn-box a:hover {
      background-color: transparent;
      color: #FFD700;
      text-decoration: none;
    }
  </style>

  <div class="container">
    <div class="heading_container text-center">
      <h2>Available Vacant Houses</h2>
      <p>Premium residences currently available for immediate move-in.</p>
    </div>

    <div class="house-grid">

      <?php if ($vacantHouses && $vacantHouses->num_rows > 0): ?>
        <?php while ($h = $vacantHouses->fetch_assoc()): ?>
          
          <a href="house.php?id=<?= $h['id'] ?>" class="house-card">

            <img src="<?= !empty($h['main_image']) && file_exists($h['main_image']) 
              ? $h['main_image'] 
              : 'images/no-image.png' ?>" alt="<?= htmlspecialchars($h['name']) ?>">

            <div class="house-card-content">
              <h6><?= htmlspecialchars($h['name']) ?></h6>

              <p>
                📍 <?= htmlspecialchars($h['location']) ?>
              </p>

              <span class="vacant-count">
                <?= (int)$h['vacant_units'] ?> Vacant Unit(s)
              </span>
            </div>

          </a>

        <?php endwhile; ?>
      <?php else: ?>
        <div style="grid-column: 1/-1; text-align: center; padding: 40px;">
          <p style="color: #ffffff; font-size: 18px; opacity: 0.8;">
            🚫 No vacant houses available at the moment. Please check back later.
          </p>
        </div>
      <?php endif; ?>

    </div>

    <div class="btn-box" style="margin-top: 50px; text-align: center;">
      <a href="house.php">View All Listings</a>
    </div>
  </div>
</section>
<!-- end house listings section -->


  <!-- end sale section -->

<!-- deal section -->
<section class="deal_section layout_padding-bottom">
  <div class="container">
    <div class="row align-items-center">

      <div class="col-md-6">
  <style>
    .detail-box {
      padding: 20px;
    }

    /* Heading in Navy Blue to match theme */
    .detail-box .heading_container h2 {
      color: #001f3f; 
      font-weight: 700;
      margin-bottom: 20px;
    }

    /* Paragraph set to Solid Black as requested */
    .detail-box p {
      color: #000000; 
      line-height: 1.6;
      font-size: 1.1rem;
      margin-bottom: 25px;
    }

    /* Button in Gold with Navy text for contrast */
    .detail-box a {
      display: inline-block;
      padding: 12px 30px;
      background-color: #FFD700;
      color: #001f3f;
      text-decoration: none;
      font-weight: 700;
      border-radius: 5px;
      transition: all 0.3s ease;
      border: 2px solid #FFD700;
    }

    .detail-box a:hover {
      background-color: #001f3f;
      color: #FFD700;
      border-color: #001f3f;
    }
  </style>

  <div class="detail-box">
    <div class="heading_container">
      <h2>
        Trusted Real Estate Solutions
      </h2>
    </div>
    <p>
      At Lifeshed Realtors, we simplify property ownership and renting.
      From professional property management to reliable tenant placement,
      we ensure every property is handled with care, transparency, and
      efficiency.
    </p>
    <a href="contact.php">
      Talk to Us Today
    </a>
  </div>
</div>

      <div class="col-md-6">
        <div class="img-box">
          <div class="box b1">
    <img src="images/hao3.jpg" alt="Lifeshed Realtors Property">
          </div>
          <div class="box b1">
            <img src="images/hao3.jpg" alt="Lifeshed Realtors Management">
          </div>
        </div>
      </div>

    </div>
  </div>
</section>
<!-- end deal section -->


<!-- us section -->
<section class="us_section layout_padding2" style="background: #ffffff; padding: 70px 0;">
  <style>
    /* Heading in Navy Blue */
    .us_section .heading_container h2 {
      color: #001f3f;
      font-weight: 700;
      text-align: center;
      margin-bottom: 40px;
    }

    .us_section .box {
      text-align: center;
      margin-top: 30px;
    }

    /* Round, themed image boxes */
    .us_section .img-box {
      width: 120px;
      height: 120px;
      margin: 0 auto 20px;
      border-radius: 50%;
      overflow: hidden;
      border: 3px solid #FFD700; /* Gold Border */
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    .us_section .img-box img {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }

    /* Feature Titles in Navy */
    .us_section .detail-box h5 {
      color: #001f3f;
      font-weight: 700;
      margin-bottom: 10px;
    }

    /* Paragraph descriptions in GREY for contrast */
    .us_section .detail-box p {
      color: #666666; /* Deep Grey */
      font-size: 14px;
      line-height: 1.6;
    }

    /* Themed Button */
    .us_section .btn-box {
      display: flex;
      justify-content: center;
      margin-top: 45px;
    }

    .us_section .btn-box a {
      padding: 12px 35px;
      background-color: #FFD700; /* Gold */
      color: #001f3f; /* Navy */
      font-weight: 700;
      border-radius: 5px;
      text-decoration: none;
      transition: all 0.3s ease;
      border: 2px solid #FFD700;
    }

    .us_section .btn-box a:hover {
      background-color: #001f3f;
      color: #FFD700;
      border-color: #001f3f;
    }
  </style>

  <div class="container">
    <div class="heading_container">
      <h2>
        Why Choose Lifeshed Realtors
      </h2>
    </div>

    <div class="row">

      <div class="col-md-3 col-sm-6">
        <div class="box">
          <div class="img-box">
            <img src="images/management.jpg" alt="Professional Management">
          </div>
          <div class="detail-box">
            <h5>
              Professional Management
            </h5>
            <p>
              We manage properties with transparency, accountability, and
              attention to detail to protect your investment.
            </p>
          </div>
        </div>
      </div>

      <div class="col-md-3 col-sm-6">
        <div class="box">
          <div class="img-box">
            <img src="images/hao3.jpg" alt="Reliable Tenants">
          </div>
          <div class="detail-box">
            <h5>
              Reliable Tenant Placement
            </h5>
            <p>
              We carefully screen tenants to ensure timely rent payments
              and peaceful occupancy.
            </p>
          </div>
        </div>
      </div>

      <div class="col-md-3 col-sm-6">
        <div class="box">
          <div class="img-box">
            <img src="images/communication.jpg" alt="Clear Communication">
          </div>
          <div class="detail-box">
            <h5>
              Clear Communication
            </h5>
            <p>
              Landlords and tenants stay informed through timely updates,
              reports, and support.
            </p>
          </div>
        </div>
      </div>

      <div class="col-md-3 col-sm-6">
        <div class="box">
          <div class="img-box">
            <img src="images/hao5.jpg" alt="Local Expertise">
          </div>
          <div class="detail-box">
            <h5>
              Local Market Expertise
            </h5>
            <p>
              Our deep understanding of the local real estate market helps
              maximize returns and reduce vacancies.
            </p>
          </div>
        </div>
      </div>

    </div>

    <div class="btn-box">
      <a href="contact.php">
        Talk to Lifeshed Realtors
      </a>
    </div>
  </div>
</section>
<!-- end us section -->

<!-- client section -->
<section class="client_section layout_padding" style="background: #001f3f; padding: 70px 0;">
  <style>
    /* Section Heading */
    .client_section .heading_container h2 {
      color: #FFD700; /* Gold */
      font-weight: 700;
      text-align: center;
      margin-bottom: 40px;
    }

    /* Testimonial Box */
    .client_section .box {
      background: #ffffff; /* White card */
      padding: 40px;
      border-radius: 15px;
      margin: 20px auto;
      max-width: 800px;
      text-align: center;
      box-shadow: 0 10px 30px rgba(0,0,0,0.3);
      border-bottom: 5px solid #FFD700; /* Gold accent bottom */
    }

    /* Circle Client Photos - Smaller & Round */
    .client_section .img-box {
      width: 100px; /* Perfectly sized - smaller than original but prominent */
      height: 100px;
      margin: 0 auto 20px;
      border-radius: 50%;
      overflow: hidden;
      border: 3px solid #FFD700; /* Gold border ring */
      background: #fff;
    }

    .client_section .img-box img {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }

    /* Detail Box Text */
    .client_section .detail-box h5 {
      color: #001f3f; /* Navy */
      font-weight: 700;
      text-transform: uppercase;
      letter-spacing: 1px;
    }

    .client_section .detail-box h5 span {
      display: block;
      margin-bottom: 5px;
    }

    .client_section .detail-box hr {
      width: 50px;
      border-top: 2px solid #FFD700; /* Gold line */
      margin: 10px auto;
    }

    /* Testimonial Text - High Contrast */
    .client_section .detail-box p {
      color: #333333; /* Dark grey for readability on white card */
      font-size: 1.1rem;
      line-height: 1.7;
      font-style: italic;
    }

    /* Carousel Controls Styling */
    .client_section .carousel-control-prev,
    .client_section .carousel-control-next {
      width: 50px;
      height: 50px;
      background: #FFD700;
      border-radius: 50%;
      top: 50%;
      transform: translateY(-50%);
      opacity: 0.8;
    }

    .client_section .carousel-control-prev:hover,
    .client_section .carousel-control-next:hover {
      background: #ffffff;
      opacity: 1;
    }
  </style>

  <div class="container-fluid">
    <div class="heading_container">
      <h2>
        What Our Clients Say
      </h2>
    </div>

    <div class="client_container">
      <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
        <div class="carousel-inner">

          <div class="carousel-item active">
            <div class="box">
              <div class="img-box">
                <img src="images/mse1.jpg" alt="Lifeshed Client">
              </div>
              <div class="detail-box">
                <h5>
                  <span>Landlord</span>
                  <hr>
                </h5>
                <p>
                  "Lifeshed Realtors has taken away the stress of managing my property.
                  Rent collection is timely, communication is clear, and my units
                  are well maintained."
                </p>
              </div>
            </div>
          </div>

          <div class="carousel-item">
            <div class="box">
              <div class="img-box">
                <img src="images/mse2.jpg" alt="Lifeshed Tenant">
              </div>
              <div class="detail-box">
                <h5>
                  <span>Tenant</span>
                  <hr>
                </h5>
                <p>
                  "The Lifeshed team is professional and responsive.
                  Any issues are handled quickly, and the rental process
                  was smooth and transparent."
                </p>
              </div>
            </div>
          </div>

          <div class="carousel-item">
            <div class="box">
              <div class="img-box">
                <img src="images/mse3.jpg" alt="Property Owner">
              </div>
              <div class="detail-box">
                <h5>
                  <span>Property Owner</span>
                  <hr>
                </h5>
                <p>
                  "I appreciate their honesty and market knowledge.
                  Lifeshed Realtors helped reduce vacancies and improved
                  the overall value of my investment."
                </p>
              </div>
            </div>
          </div>

        </div>

        <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
          <span class="sr-only">Previous</span>
        </a>
        <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
          <span class="sr-only">Next</span>
        </a>
      </div>
    </div>
  </div>
</section>
<!-- end client section -->

  <!-- end client section -->


            <a href="#"><img src="images/fb.png" alt=""></a>
            <a href="#"><img src="images/twitter.png" alt=""></a>
            <a href="#"><img src="images/linkedin.png" alt=""></a>
            <a href="#"><img src="images/youtube.png" alt=""></a>
          </div>
        </div>
      </div>


<!-- info section -->
<section class="info_section" style="background:#0f2a44; color:#ffffff;">
  <div class="container">
    <div class="row">

      <div class="col-md-3">
        <div class="info_contact">
          <h5 style="color:#ffffff;">
            Lifeshed Realtors
          </h5>

          <div style="display:flex; align-items:center; margin-bottom:8px;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/location.png" width="18px" alt="">
            </div>
            <p style="margin:0;">
              Highlands Mall, Eldoret (G7C8+94P)
            </p>
          </div>

          <div style="display:flex; align-items:center; margin-bottom:8px;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/phone.png" width="12px" alt="">
            </div>
            <p style="margin:0;">
              0725 608 170
            </p>
          </div>

          <div style="display:flex; align-items:center;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/mail.png" width="18px" alt="">
            </div>
            <p style="margin:0;">
              info@lifeshedrealtors.co.ke
            </p>
          </div>
        </div>
      </div>

      <div class="col-md-3">
        <div class="info_info">
          <h5 style="color:#ffffff;">
            About Us
          </h5>
          <p>
            Lifeshed Realtors offers professional property management,
            estate agency, and real estate consultancy services focused
            on value, trust, and long-term partnerships.
          </p>
        </div>
      </div>

      <div class="col-md-3">
        <div class="info_links">
          <h5 style="color:#ffffff;">
            Quick Links
          </h5>
          <ul>
            <li><a href="index.php" style="color:#ffffff;">Home</a></li>
            <li><a href="about.html" style="color:#ffffff;">About Us</a></li>
            <li><a href="house.php" style="color:#ffffff;">House Listings</a></li>
            <li><a href="contact.php" style="color:#ffffff;">Contact Us</a></li>
          </ul>
        </div>
      </div>

<div class="col-md-3">
  <div class="info_form">
    <h5 style="color:#ffffff;">
      Stay Connected
    </h5>

    <form action="admin_dashboard.php" method="get">
      <button style="margin-top:10px; width:100%; padding:10px; font-weight:600;">
        🔐 Log IN
      </button>
    </form>

  </div>
</div>


          <div class="social_box" style="margin-top:15px;">


    </div>
  </div>
</section>
<!-- end info section -->
  <!-- end info_section -->


  <!-- footer section -->
  <section class="container-fluid footer_section ">
    <div class="container">
      <p>
        &copy; <span id="displayYear"></span> All Rights Reserved By
        <a href="https://html.design/">Lifeshed Realtors </a>
      </p>
    </div>
  </section>
  <!-- end  footer section -->


  <script type="text/javascript" src="js/jquery-3.4.1.min.js"></script>
  <script type="text/javascript" src="js/bootstrap.js"></script>
  <script type="text/javascript" src="js/custom.js"></script>
	<!-- Landlord Management Modal -->
<div id="landlordModal" style="
  display:none;
  position:fixed;
  inset:0;
  background:rgba(0,0,0,0.5);
  align-items:center;
  justify-content:center;
  z-index:9999;
">
  <div style="
    background:#fff;
    padding:20px;
    width:100%;
    max-width:420px;
    border-radius:12px;
    animation:pop .2s ease;
  ">
    <h3 style="margin-top:0;color:#0f2a44;">Property Management Request</h3>

    <input id="lm_name" placeholder="Full Name"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <input id="lm_phone" placeholder="Phone Number"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <input id="lm_property" placeholder="Property Name"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <input id="lm_location" placeholder="Property Location"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <textarea id="lm_desc" placeholder="Describe the management you need"
      style="width:100%;padding:10px;height:90px;margin-bottom:15px;"></textarea>

    <div style="display:flex;justify-content:space-between;">
      <button onclick="closeLandlordModal()">Cancel</button>
      <button onclick="submitLandlordRequest()"
        style="background:#0f2a44;color:#fff;border:none;padding:8px 18px;border-radius:6px;">
        Submit
      </button>
    </div>
  </div>
</div>



<!-- Add User Modal -->
<div id="addUserModal" style="
  display:none;
  position:fixed;
  inset:0;
  background:rgba(0,0,0,0.5);
  align-items:center;
  justify-content:center;
  z-index:9999;
">
  <div style="
    background:#fff;
    padding:20px;
    width:100%;
    max-width:400px;
    border-radius:12px;
    animation:pop .2s ease;
  ">
    <h3 style="margin-top:0;color:#0f2a44;">Add User</h3>

    <input id="au_username" placeholder="Username" style="width:100%;padding:10px;margin-bottom:10px;">
    <input id="au_password" type="password" placeholder="Password" style="width:100%;padding:10px;margin-bottom:10px;">

    <select id="au_role" style="width:100%;padding:10px;margin-bottom:15px;">
      <option value="">Select role</option>
      <option value="admin">Admin</option>
      <option value="landlord">Landlord</option>
      <option value="user">User</option>
    </select>

    <div style="display:flex;justify-content:space-between;">
      <button onclick="closeAddUserModal()" style="padding:8px 14px;">Cancel</button>
      <button onclick="submitAddUser()" style="
        padding:8px 14px;
        background:#0f2a44;
        color:#fff;
        border:none;
        border-radius:6px;
      ">Save</button>
    </div>
  </div>
</div>




</body>
<script>
/* ---------- GENERIC MODAL HANDLER ---------- */
function openModal(modalId) {
  const modal = document.getElementById(modalId);
  if (modal) modal.style.display = 'flex';
}

function closeModal(modalId, clearFields = []) {
  const modal = document.getElementById(modalId);
  if (modal) modal.style.display = 'none';
  // Clear specified fields
  clearFields.forEach(id => {
    const el = document.getElementById(id);
    if (el) el.value = '';
  });
}

/* ---------- ADD USER MODAL ---------- */
function openAddUserModal() {
  openModal('addUserModal');
}

function closeAddUserModal() {
  closeModal('addUserModal', ['au_username','au_password','au_role']);
}

/* ---------- SUBMIT ADD USER (AJAX) ---------- */
function submitAddUser() {
  const username = document.getElementById('au_username')?.value.trim();
  const password = document.getElementById('au_password')?.value;
  const role     = document.getElementById('au_role')?.value;

  if (!username || !password || !role) {
    alert('All fields are required');
    return;
  }

  fetch('add_user.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `username=${encodeURIComponent(username)}&password=${encodeURIComponent(password)}&role=${encodeURIComponent(role)}`
  })
  .then(r => r.text())
  .then(r => {
    if (r === 'success') {
      closeAddUserModal();
      // Reload users dynamically if function exists
      if (typeof loadPage === 'function') {
        loadPage('users.php', 'User Management');
      } else {
        alert('User added successfully');
      }
    } else {
      alert(r);
    }
  })
  .catch(() => alert('Network error'));
}

/* ---------- LANDLORD MODAL ---------- */
function openLandlordModal() {
  openModal('landlordModal');
}

function closeLandlordModal() {
  closeModal('landlordModal', ['lm_name','lm_phone','lm_property','lm_location','lm_desc']);
}

function submitLandlordRequest() {
  const lm_name = document.getElementById('lm_name')?.value.trim();
  const lm_phone = document.getElementById('lm_phone')?.value.trim();
  const lm_property = document.getElementById('lm_property')?.value.trim();
  const lm_location = document.getElementById('lm_location')?.value.trim();
  const lm_desc = document.getElementById('lm_desc')?.value.trim();

  const data = {
    name: lm_name,
    phone: lm_phone,
    property_name: lm_property,
    location: lm_location,
    description: lm_desc
  };

  if (Object.values(data).some(v => !v)) {
    alert('All fields are required');
    return;
  }

  fetch('save_landlord_request.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: new URLSearchParams(data).toString()
  })
  .then(r => r.text())
  .then(r => {
    if (r === 'success') {
      alert('Request sent successfully');
      closeLandlordModal();
    } else {
      alert(r);
    }
  })
  .catch(() => alert('Network error'));
}
</script>



</html>