<?php
require_once "db.php";

$booking_success = false;

/* HANDLE BOOKING SUBMISSION */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['book_house'])) {
  $stmt = $conn->prepare("
    INSERT INTO house_bookings 
    (property_id, full_name, house_details, how_soon, phone, preferred_location) 
    VALUES (?,?,?,?,?,?)
  ");
  $stmt->bind_param(
    "isssss",
    $_POST['property_id'],
    $_POST['full_name'],
    $_POST['house_details'],
    $_POST['how_soon'],
    $_POST['phone'],
    $_POST['preferred_location']
  );
  $stmt->execute();
  $stmt->close();
  $booking_success = true;
}

/* FETCH ONLY PROPERTIES WITH VACANT UNITS */
$sql = "
  SELECT 
    p.id,
    p.name,
    p.location,
    p.description,
    p.main_image,
    (
      SELECT COALESCE(SUM(u.vacant_count),0)
      FROM property_units u
      WHERE u.property_id = p.id
    ) AS vacant_units
  FROM properties p
  HAVING vacant_units > 0
  ORDER BY p.created_at DESC
";
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Available Houses | Lifeshed Realtors</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="icon" type="image/png" href="images/Lifeshedlogo.png">
  <link rel="stylesheet" href="css/bootstrap.css">
  <link href="https://fonts.googleapis.com/css?family=Poppins:400,600,700&display=swap" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/responsive.css" rel="stylesheet">

  <style>
    body { background: #f4f7f6; color: #1f2937; font-family: 'Poppins', sans-serif; }
    
    .header_section { background-color: #001f3f; padding: 10px 0; }
    .navbar-brand img { width: 150px; }

    .heading_container h2 { color: #001f3f; font-weight: 700; position: relative; padding-bottom: 10px; }
    .heading_container h2::after { content: ""; width: 60px; height: 4px; background: #FFD700; position: absolute; bottom: 0; left: 0; }

    /* GRID OPTIMIZATION */
    .house-grid { 
      display: grid; 
      grid-template-columns: repeat(4, 1fr); 
      gap: 15px; 
      margin-top: 30px; 
    }

    /* Tablet: 3 columns */
    @media (max-width: 992px) {
      .house-grid { grid-template-columns: repeat(3, 1fr); }
    }

    /* Mobile: 2 columns per row */
    @media (max-width: 576px) {
      .house-grid { 
        grid-template-columns: repeat(2, 1fr); 
        gap: 10px; 
      }
      .house-body { padding: 10px; }
      .house-title { font-size: 0.95rem; }
      .house-location { font-size: 0.75rem; }
      .vacancy-badge { font-size: 10px; padding: 2px 8px; }
      .book-btn { font-size: 0.8rem; padding: 8px 5px; }
      .house-img { height: 140px; }
    }

    .house-card { 
      background: #ffffff; 
      border-radius: 12px; 
      overflow: hidden; 
      border: none; 
      box-shadow: 0 4px 15px rgba(0,0,0,0.05); 
      transition: 0.3s ease; 
      border-bottom: 3px solid #FFD700; 
      display: flex;
      flex-direction: column;
    }
    .house-card:hover { transform: translateY(-5px); }
    .house-img { width: 100%; height: 180px; object-fit: cover; }
    .house-body { padding: 15px; flex-grow: 1; display: flex; flex-direction: column; justify-content: space-between; }
    .house-title { font-weight: 700; color: #001f3f; line-height: 1.2; margin-bottom: 5px; }
    
    .vacancy-badge {
      display: inline-block;
      background: rgba(255, 215, 0, 0.15);
      color: #b8860b;
      border-radius: 50px;
      font-weight: 700;
      margin-bottom: 8px;
      border: 1px solid #FFD700;
    }

    .book-btn { 
      background: #001f3f; 
      color: #FFD700; 
      border: none; 
      font-weight: 600; 
      transition: 0.3s;
      border-radius: 6px;
    }
    .book-btn:hover { background: #FFD700; color: #001f3f; }

    .info_section { background-color: #001f3f; color: #ffffff; padding: 50px 0; }
    .info_section h5 { color: #FFD700; font-weight: 700; }
  </style>
</head>

<body class="sub_page">

  <header class="header_section">
    <div class="container-fluid">
      <nav class="navbar navbar-expand-lg custom_nav-container">
        <a class="navbar-brand" href="index.php">
          <img src="images/Lifeshedlogo.png" alt="Lifeshed Realtors">
        </a>
      </nav>
    </div>
  </header>

  <section class="layout_padding">
    <div class="container">
      <div class="heading_container">
        <h2>Available Houses</h2>
        <p>Premium properties with current vacancies.</p>
      </div>

      <div class="house-grid">
        <?php if($result && $result->num_rows): while($p=$result->fetch_assoc()): ?>
          <div class="house-card">
            <img src="<?= !empty($p['main_image']) && file_exists($p['main_image']) ? $p['main_image'] : 'images/no-image.png' ?>" class="house-img">
            <div class="house-body">
              <div>
                <span class="vacancy-badge"><?= (int)$p['vacant_units'] ?> Vacant</span>
                <div class="house-title"><?= htmlspecialchars($p['name']) ?></div>
                <div class="house-location">📍 <?= htmlspecialchars($p['location']) ?></div>
              </div>
              <button class="btn book-btn w-100 mt-2" data-toggle="modal" data-target="#bookModal<?= $p['id'] ?>">
                Book Now
              </button>
            </div>
          </div>

          <div class="modal fade" id="bookModal<?= $p['id'] ?>">
            <div class="modal-dialog modal-dialog-centered">
              <div class="modal-content">
                <form method="post">
                  <div class="modal-header" style="background:#001f3f; color:#FFD700;">
                    <h5 class="modal-title">Booking: <?= htmlspecialchars($p['name']) ?></h5>
                    <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                  </div>
                  <div class="modal-body">
                    <input type="hidden" name="property_id" value="<?= $p['id'] ?>">
                    <div class="form-group"><label>Full Name</label><input type="text" name="full_name" class="form-control" required></div>
                    <div class="form-group"><label>Phone Number</label><input type="text" name="phone" class="form-control" required></div>
                    <div class="form-group">
                      <label>Move-in Timeline</label>
                      <select name="how_soon" class="form-control">
                        <option>Immediately</option>
                        <option>Within a week</option>
                        <option>Within a month</option>
                      </select>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button type="submit" name="book_house" class="btn btn-primary" style="background:#001f3f; border:none;">Submit Request</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        <?php endwhile; else: ?>
          <div class="col-12 text-center py-5">
            <p style="color:#6b7280;">🚫 No vacancies available right now.</p>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </section>

  <?php if($booking_success): ?>
  <div class="modal fade show" id="successModal" style="display:block; background:rgba(0,0,0,.8); z-index: 10000;">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content text-center">
        <div class="modal-body" style="padding:40px;">
          <h2 style="color: #28a745;">✔ Success!</h2>
          <p>Request received! Our team will contact you shortly.</p>
          <button class="btn btn-dark" onclick="window.location='house.php'">Close</button>
        </div>
      </div>
    </div>
  </div>
  <?php endif; ?>

  <section class="info_section">
    <div class="container">
      <div class="row">
        <div class="col-md-4">
          <h5>Lifeshed Realtors</h5>
          <p>📍 Highlands Mall, Eldoret (G7C8+94P)</p>
          <p>📞 0725 608 170</p>
          <p>✉️ info@lifeshedrealtors.co.ke</p>
        </div>
        <div class="col-md-4">
          <h5>Quick Links</h5>
          <ul class="list-unstyled">
            <li><a href="index.php" class="text-white">Home</a></li>
            <li><a href="about.html" class="text-white">The Story of Lifeshed</a></li>
            <li><a href="house.php" class="text-white">House Listings</a></li>
          </ul>
        </div>
        <div class="col-md-4">
          <h5>Admin Access</h5>
          <a href="login.php" class="btn btn-outline-warning btn-sm">Staff Login</a>
        </div>
      </div>
    </div>
  </section>

  <footer class="footer_section text-center">
    <p>&copy; <span id="displayYear"></span> Lifeshed Realtors. Professionalism & Integrity.</p>
  </footer>

  <script src="js/jquery-3.4.1.min.js"></script>
  <script src="js/bootstrap.js"></script>
  <script>document.getElementById("displayYear").innerHTML = new Date().getFullYear();</script>
</body>
</html>