<?php
require_once "db.php";

require_once 'src/PHPMailer.php';
require_once 'src/SMTP.php';
require_once 'src/Exception.php';

$message = "";
$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $email = trim($_POST["email"] ?? '');

    if ($email) {

        $stmt = $conn->prepare("SELECT id, username FROM users WHERE email = ? LIMIT 1");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows === 1) {

            $user = $result->fetch_assoc();
            $user_id = $user["id"];

            // Generate secure token
            $token = bin2hex(random_bytes(32));
            $expires = date("Y-m-d H:i:s", strtotime("+1 hour"));

            // Delete old tokens
            $delete = $conn->prepare("DELETE FROM password_resets WHERE user_id = ?");
            $delete->bind_param("i", $user_id);
            $delete->execute();

            // Insert new token
            $insert = $conn->prepare(
                "INSERT INTO password_resets (user_id, token, expires_at)
                 VALUES (?, ?, ?)"
            );
            $insert->bind_param("iss", $user_id, $token, $expires);
            $insert->execute();

            $resetLink = "http://localhost/lifeshed/reset_password.php?token=" . $token;

            // Send Email
            $mail = new \PHPMailer\PHPMailer\PHPMailer(true);

            try {
                $mail->isSMTP();
                $mail->Host       = 'smtp.gmail.com';
                $mail->SMTPAuth   = true;
                $mail->Username   = 'your_email@gmail.com'; // CHANGE
                $mail->Password   = 'your_app_password';    // CHANGE
                $mail->SMTPSecure = 'tls';
                $mail->Port       = 587;

                $mail->setFrom('your_email@gmail.com', 'Lifeshed Realtors');
                $mail->addAddress($email);

                $mail->isHTML(true);
                $mail->Subject = 'Password Reset Request';
                $mail->Body    = "
                    <h3>Password Reset</h3>
                    <p>Hello,</p>
                    <p>Click the link below to reset your password:</p>
                    <a href='$resetLink'>$resetLink</a>
                    <p>This link expires in 1 hour.</p>
                ";

                $mail->send();
                $message = "Reset link sent successfully! Please check your email.";
            }
            catch (Exception $e) {
                $error = "Email could not be sent. Error: {$mail->ErrorInfo}";
            }

        } else {
            $error = "No account found with that email.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title>Forgot Password | Lifeshed Realtors</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
  <link href="https://fonts.googleapis.com/css?family=Poppins:400,600,700|Raleway:400,700&display=swap" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet" />
  <link href="css/responsive.css" rel="stylesheet" />

  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: #f4f6f9;
    }

    .forgot-wrapper {
      min-height: calc(100vh - 300px);
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 60px 15px;
    }

    .forgot-card {
      background: #fff;
      padding: 35px;
      border-radius: 16px;
      width: 100%;
      max-width: 400px;
      box-shadow: 0 15px 40px rgba(0,0,0,0.2);
    }

    .forgot-card h2 {
      text-align: center;
      margin-bottom: 20px;
      color: #0f2a44;
    }

    .forgot-card input {
      width: 100%;
      padding: 10px;
      margin-bottom: 15px;
      border-radius: 8px;
      border: 1px solid #ccc;
    }

    .forgot-card button {
      width: 100%;
      padding: 10px;
      border: none;
      border-radius: 8px;
      background: #0f2a44;
      color: #fff;
      font-size: 16px;
      cursor: pointer;
    }

    .success {
      background: #e6ffed;
      color: #006622;
      padding: 10px;
      border-radius: 8px;
      margin-bottom: 15px;
      text-align: center;
    }

    .error {
      background: #ffe5e5;
      color: #b30000;
      padding: 10px;
      border-radius: 8px;
      margin-bottom: 15px;
      text-align: center;
    }
  </style>
</head>

<body>

<!-- 🔹 NAVBAR (MATCHING INDEX) -->
<header class="header_section">
  <div class="container-fluid">
    <nav class="navbar navbar-expand-lg custom_nav-container">
      <a class="navbar-brand" href="index.php">
        <img src="images/logo.png" alt="Lifeshed Realtors" />
      </a>

      <div class="navbar-collapse">
        <div class="custom_menu-btn">
          <button onclick="openNav()">
            <span class="s-1"></span>
            <span class="s-2"></span>
            <span class="s-3"></span>
          </button>
        </div>

        <div id="myNav" class="overlay">
          <div class="overlay-content">
            <a href="index.php">HOME</a>
            <a href="about.html">ABOUT</a>
            <a href="house.html">HOUSE</a>
            <a href="price.html">PRICING</a>
            <a href="contact.html">CONTACT US</a>
          </div>
        </div>
      </div>
    </nav>
  </div>
</header>

<!-- 🔐 FORM -->
<div class="forgot-wrapper">
  <form class="forgot-card" method="POST">
    <h2>Forgot Password</h2>

    <?php if ($message): ?>
      <div class="success"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <?php if ($error): ?>
      <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <input type="email" name="email" placeholder="Enter your registered email" required>

    <button type="submit">Send Reset Link</button>
  </form>
</div>

<!-- 🔹 FULL FOOTER (MATCHING INDEX) -->
<section class="info_section" style="background:#0f2a44; color:#ffffff;">
  <div class="container">
    <div class="row">

      <div class="col-md-3">
        <h5>Lifeshed Realtors</h5>
        <p>Highlands Mall, Eldoret</p>
        <p>0725 608 170</p>
        <p>info@lifeshedrealtors.co.ke</p>
      </div>

      <div class="col-md-3">
        <h5>About Us</h5>
        <p>
          Professional property management, estate agency,
          and consultancy services you can trust.
        </p>
      </div>

      <div class="col-md-3">
        <h5>Quick Links</h5>
        <ul style="list-style:none; padding:0;">
          <li><a href="index.php" style="color:#fff;">Home</a></li>
          <li><a href="about.html" style="color:#fff;">About</a></li>
          <li><a href="house.html" style="color:#fff;">Listings</a></li>
          <li><a href="contact.html" style="color:#fff;">Contact</a></li>
        </ul>
      </div>

      <div class="col-md-3">
        <h5>Admin Access</h5>
        <p>Secure login for authorized staff only.</p>
      </div>

    </div>
  </div>
</section>

<section class="container-fluid footer_section">
  <div class="container">
    <p>&copy; <span id="displayYear"></span> Lifeshed Realtors</p>
  </div>
</section>

<script src="js/jquery-3.4.1.min.js"></script>
<script src="js/bootstrap.js"></script>
<script src="js/custom.js"></script>

</body>
</html>
