<?php
// KEEP DB INCLUDED (needed later / consistency)
require_once "db.php";
?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

  <title>Contact Us | Lifeshed Realtors</title>

  <link rel="icon" type="image/png" href="images/Lifeshedlogo.png">
  <link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
  <link href="https://fonts.googleapis.com/css?family=Poppins:400,600,700&display=swap" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet" />
  <link href="css/responsive.css" rel="stylesheet" />

  <style>
    :root {
        --navy: #001f3f;
        --gold: #FFD700;
    }

    body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }

    /* HEADER STYLES */
    .header_section { background: var(--navy); border-bottom: 2px solid var(--gold); }
    .navbar-brand img { max-width: 180px; }
    
    .login-btn {
      color: var(--navy) !important; 
      background: var(--gold); 
      padding: 8px 25px; 
      border-radius: 5px; 
      font-weight: 700; 
      transition: 0.3s;
      text-transform: uppercase;
      font-size: 14px;
    }
    .login-btn:hover { background: #fff !important; box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3); }

    /* FORM STYLES */
    .glass-form {
      background: #ffffff;
      border-radius: 16px;
      padding: 30px;
      box-shadow: 0 10px 30px rgba(0, 31, 63, 0.1);
      border: 1px solid rgba(0, 31, 63, 0.1);
    }

    .glass-form input, .glass-form textarea, .glass-form select {
      width: 100%; padding: 12px; margin-bottom: 15px; border-radius: 8px; border: 1px solid #ddd; outline: none; background: #fff;
    }

    .glass-form button {
      background: var(--navy); color: var(--gold); border: none; padding: 14px 35px; border-radius: 8px;
      cursor: pointer; font-weight: 700; transition: 0.3s ease; width: 100%; text-transform: uppercase;
    }

    .glass-form button:hover { background: var(--gold); color: var(--navy); transform: translateY(-2px); }

    /* INFO & FOOTER */
    .info_section { background-color: var(--navy); color: #ffffff; padding: 60px 0; }
    .info_section h5 { color: var(--gold); font-weight: 700; margin-bottom: 20px; }
    .footer_section { background: #001226; color: #fff; padding: 20px 0; border-top: 1px solid rgba(255,255,255,0.05); }

    .alert-error { display: none; margin-bottom: 15px; padding: 12px; border-radius: 8px; font-weight: 500; text-align: center; background: #f8d7da; color: #721c24; }
  </style>
</head>

<body class="sub_page">

<div class="hero_area">
  <header class="header_section">
    <div class="container-fluid">
      <nav class="navbar navbar-expand-lg custom_nav-container">
        <a class="navbar-brand" href="index.php">
          <img src="images/Lifeshedlogo.png" alt="Lifeshed Realtors" />
        </a>
        <div class="navbar-collapse d-flex justify-content-end align-items-center">
          <?php if (!isset($_SESSION['user_id'])): ?>
            <a href="login.php" class="login-btn">Login</a>
          <?php endif; ?>
          <div class="custom_menu-btn">
            <button onclick="openNav()">
              <span class="s-1" style="background: var(--gold);"></span>
              <span class="s-2" style="background: var(--gold);"></span>
              <span class="s-3" style="background: var(--gold);"></span>
            </button>
          </div>
          <div id="myNav" class="overlay" style="background-color: rgba(0, 31, 63, 0.95);">
            <div class="overlay-content">
              <a href="index.php">HOME</a>
              <a href="about.html">ABOUT US</a>
              <a href="house.php">HOUSE LISTINGS</a>
              <a href="contact.php">CONTACT</a>
            </div>
          </div>
        </div>
      </nav>
    </div>
  </header>
</div>

<section class="contact_section layout_padding">
  <div class="container">
    <div class="heading_container">
      <h2>Contact Lifeshed Realtors</h2>
      <p style="margin-top:10px;">Visit us at Highlands Mall along Uganda Highway, Eldoret.</p>
    </div>
  </div>

  <div class="container mt-5">
    <div class="row">
      <div class="col-md-7 px-0 mb-4 mb-md-0">
        <div class="map_container" style="height: 520px; border-radius: 16px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.1); border: 4px solid #fff;">
          <iframe 
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3989.756581457193!2d35.266206!3d0.523821!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x1781019df0e32623%3A0x6b18d2d6d84f2f9b!2sHighlands%20Mall!5e0!3m2!1sen!2ske!4v1700000000000!5m2!1sen!2ske" 
            width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
        </div>
      </div>

      <div class="col-md-5">
        <div class="form_container glass-form">
          <div id="alertError" class="alert-error"></div>
          <form id="contactForm">
            <input type="text" name="name" placeholder="Full Name" required>
            <input type="text" name="phone" placeholder="Phone Number" required>
            <input type="email" name="email" placeholder="Email Address (optional)">
            <select name="type" required>
              <option value="">Message Type</option>
              <option value="general">General Inquiry</option>
              <option value="complaint">Complaint</option>
            </select>
            <input type="text" name="subject" placeholder="Subject" required>
            <textarea name="message" style="height: 120px;" placeholder="Your Message" required></textarea>
            <button type="submit" id="submitBtn">Send Message</button>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="modal fade" id="messageSuccessModal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="border-radius: 15px; border: none;">
      <div class="modal-body text-center" style="padding: 45px 30px;">
        <div style="width: 80px; height: 80px; background: #d4edda; color: #28a745; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 40px; margin: 0 auto 20px;">✓</div>
        <h3 style="color: var(--navy); font-weight: 700;">Message Received!</h3>
        <p style="color: #555; font-size: 16px;">Your message has been received by <strong>Lifeshed</strong> and we will get back to you soonest!</p>
        <button type="button" class="btn" data-dismiss="modal" style="background: var(--navy); color: var(--gold); padding: 12px 40px; font-weight: 700; margin-top: 25px; border-radius: 8px; width: 100%;">CLOSE</button>
      </div>
    </div>
  </div>
</div>

<section class="info_section">
  <div class="container">
    <div class="row">
      <div class="col-md-4">
        <h5>Lifeshed Realtors</h5>
        <p>📍 Highlands Mall, Eldoret (Uganda Highway)</p>
        <p>📞 0725 608 170</p>
        <p>✉️ info@lifeshedrealtors.co.ke</p>
      </div>
      <div class="col-md-4">
        <h5>Quick Links</h5>
        <ul class="list-unstyled">
          <li><a href="index.php" class="text-white">Home</a></li>
          <li><a href="house.php" class="text-white">House Listings</a></li>
          <li><a href="contact.php" class="text-white">Contact Us</a></li>
        </ul>
      </div>
      <div class="col-md-4 text-md-right">
        <h5>Admin Access</h5>
        <a href="login.php" class="btn btn-outline-warning btn-sm">Staff Login</a>
      </div>
    </div>
  </div>
</section>

<footer class="footer_section text-center">
  <div class="container">
    <p>© <span id="displayYear"></span> Lifeshed Realtors. Professionalism & Integrity.</p>
  </div>
</footer>

<script type="text/javascript" src="js/jquery-3.4.1.min.js"></script>
<script type="text/javascript" src="js/bootstrap.js"></script>
<script type="text/javascript" src="js/custom.js"></script>

<script>
  document.getElementById("displayYear").innerHTML = new Date().getFullYear();

  document.getElementById('contactForm').addEventListener('submit', function(e) {
    e.preventDefault();
    const btn = document.getElementById('submitBtn');
    btn.innerText = "Processing...";
    btn.disabled = true;

    fetch('send_message.php', { method: 'POST', body: new FormData(this) })
    .then(res => res.text())
    .then(res => {
      if (res.trim() === 'success') {
        $('#messageSuccessModal').modal('show');
        document.getElementById('contactForm').reset();
      } else {
        document.getElementById('alertError').innerText = res;
        document.getElementById('alertError').style.display = 'block';
      }
    })
    .catch(() => {
      alert('Network error. Please try again.');
    })
    .finally(() => {
      btn.innerText = "Send Message";
      btn.disabled = false;
    });
  });
</script>
</body>
</html>