<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
    exit("Unauthorized");
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    exit("Invalid request");
}

$id = (int)$_GET['id'];

/* Mark as read */
$conn->query("UPDATE house_bookings SET status='opened' WHERE id=$id");

/* Fetch booking */
$stmt = $conn->prepare("
  SELECT 
    b.*, 
    p.name AS property_name
  FROM house_bookings b
  LEFT JOIN properties p ON p.id = b.property_id
  WHERE b.id = ?
  LIMIT 1
");
$stmt->bind_param("i",$id);
$stmt->execute();
$res = $stmt->get_result();

if(!$res->num_rows){
  exit("Booking not found");
}

$b = $res->fetch_assoc();
?>

<div style="
position:fixed;
inset:0;
background:rgba(0,0,0,.6);
display:flex;
align-items:center;
justify-content:center;
z-index:9999;
" onclick="closeBooking()">

<div style="
background:#fff;
padding:25px;
width:100%;
max-width:500px;
border-radius:14px;
" onclick="event.stopPropagation()">

<h4>🏠 Booking Details</h4>
<hr>

<p><strong>Name:</strong> <?= htmlspecialchars($b['full_name']) ?></p>
<p><strong>Phone:</strong> <?= htmlspecialchars($b['phone']) ?></p>
<p><strong>Property:</strong> <?= htmlspecialchars($b['property_name']) ?></p>

<?php if($b['house_details']): ?>
<p><strong>House Type:</strong> <?= htmlspecialchars($b['house_details']) ?></p>
<?php endif; ?>

<?php if($b['how_soon']): ?>
<p><strong>How Soon:</strong> <?= htmlspecialchars($b['how_soon']) ?></p>
<?php endif; ?>

<?php if($b['preferred_location']): ?>
<p><strong>Preferred Location:</strong> <?= htmlspecialchars($b['preferred_location']) ?></p>
<?php endif; ?>

<p style="font-size:12px;color:#666;">
Booked on <?= date('F j, Y g:i a', strtotime($b['created_at'])) ?>
</p>

<div style="text-align:right;margin-top:20px;">
  <button onclick="closeBooking()" class="btn btn-secondary">Close</button>
</div>

</div>
</div>
