<?php
require_once "db.php";

/* ===============================
   SESSION / ACCESS CONTROL
================================ */
if (
    !isset($_SESSION['user_id']) ||
    !isset($_SESSION['login_time']) ||
    (time() - $_SESSION['login_time']) > 86400
) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Lifeshed Admin Dashboard</title>
    <link rel="icon" type="image/png" href="images/Lifeshedlogo.png">
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://fonts.googleapis.com/css?family=Poppins:400,600,700&display=swap" rel="stylesheet">

<style>
body{margin:0;font-family:'Poppins',sans-serif;background:#f4f6f9}
a{text-decoration:none;cursor:pointer}
.sidebar{width:260px;background:#0f2a44;color:#fff;display:flex;flex-direction:column}
.sidebar a{padding:14px 25px;color:#fff;display:block;transition:.3s}
.sidebar a:hover{background:rgba(255,255,255,.15);padding-left:32px}
.sidebar a.active{background:rgba(255,255,255,.2);font-weight:600}
.topbar{background:#fff;padding:16px 25px;box-shadow:0 4px 12px rgba(0,0,0,.08)}
.card{background:#fff;padding:25px;border-radius:16px;box-shadow:0 10px 30px rgba(0,0,0,.08)}
.card:hover{transform:translateY(-6px);box-shadow:0 18px 40px rgba(0,0,0,.12)}

.badge{
  background:#dc3545;
  color:#fff;
  font-size:11px;
  padding:3px 7px;
  border-radius:20px;
  margin-left:8px;
  display:none;
}




</style>
</head>

<body>

<div style="display:flex;min-height:100vh">

<!-- SIDEBAR -->
<div class="sidebar">

  <div style="padding:12px 20px;border-bottom:1px solid rgba(255,255,255,.1);text-align:center">
    <a href="index.php">
      <img src="images/Lifeshedlogo.png" style="max-width:120px">
    </a>
    <p style="font-size:12px;opacity:.8">Admin Panel</p>
  </div>

  <div style="flex:1">
    <a id="btn-dashboard" class="active" onclick="loadDashboard()">📊 General Dashboard</a>
    <a onclick="loadPage('property.php','Property Management',this)">🏘 Property Management</a>
    <a onclick="loadPage('bookings.php','Bookings',this)">
  💰 Bookings <span id="badge-bookings" class="badge"></span>
</a>
<a onclick="loadPage('landlord_requests.php','Management Requests',this)">
  💰 Management Requests <span id="badge-requests" class="badge"></span>
</a>
    <a onclick="loadPage('messages.php','Messages',this)">
  💬 Messages <span id="badge-messages" class="badge"></span>
</a>
<a onclick="loadPage('landlords.php','Landlords Management',this)">🏢 Landlords</a>

    <a onclick="loadPage('users.php','User Management',this)">👤 Users</a>

  </div>

  <div style="padding:15px 25px;border-top:1px solid rgba(255,255,255,.1)">
    <a href="logout.php" style="color:#ffb3b3;font-weight:600">🚪 Logout</a>
  </div>
</div>

<!-- MAIN -->
<div style="flex:1;display:flex;flex-direction:column">
  <div class="topbar">
    <h2 id="pageTitle" style="margin:0;color:#0f2a44">General Dashboard</h2>
  </div>

  <div style="padding:30px" id="mainContent"></div>
</div>
</div>

<script>
function setActive(el){
  document.querySelectorAll('.sidebar a').forEach(a=>a.classList.remove('active'));
  if(el) el.classList.add('active');
}

/* ===========================
   LOAD GENERAL DASHBOARD
=========================== */
function loadDashboard(){
  setActive(document.getElementById('btn-dashboard'));
  document.getElementById('pageTitle').innerText='General Dashboard';

  fetch('dashboard_stats.php')
    .then(r=>r.json())
    .then(d=>{
      document.getElementById('mainContent').innerHTML=`
      <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:20px">
        <div class="card">
          <h4>Vacant Houses</h4>
          <h1 style="color:#dc3545;">${d.vacant}</h1>
        </div>
        <div class="card">
          <h4>Total Units</h4>
          <h1 style="color:#0f2a44;">${d.total_units}</h1>
        </div>
        <div class="card">
          <h4>Unread Messages</h4>
          <h1 style="color:#2563eb;">${d.unread_messages}</h1>
        </div>
      </div>`;
    });
}

/* ===========================
   LOAD OTHER PAGES
=========================== */
function loadPage(url,title,el){
  setActive(el);
  document.getElementById('pageTitle').innerText=title;

  fetch(url)
    .then(r=>r.text())
    .then(html=>{
      const c=document.getElementById('mainContent');
      c.innerHTML=html;

      c.querySelectorAll('script').forEach(s=>{
        const n=document.createElement('script');
        n.text=s.textContent;
        document.body.appendChild(n);
        s.remove();
      });

      /* MARK AS READ IF THIS PAGE HAS UNREAD ITEMS */
      if(url === 'bookings.php') markRead('bookings');
      if(url === 'messages.php') markRead('messages');
      if(url === 'landlord_requests.php') markRead('landlord_requests');
    });
}

/* ===========================
   UNREAD BADGES
=========================== */
function loadSidebarCounts(){
  fetch('sidebar_counts.php')
    .then(r=>r.json())
    .then(d=>{
      setBadge('badge-bookings', d.bookings);
      setBadge('badge-messages', d.messages);
      setBadge('badge-requests', d.requests);
    });
}

function setBadge(id, count){
  const el = document.getElementById(id);
  if(!el) return;

  if(count > 0){
    el.style.display = 'inline-block';
    el.innerText = count;
  }else{
    el.style.display = 'none';
  }
}

/* ===========================
   MARK ITEMS AS READ
=========================== */
function markRead(type){
  fetch('mark_read.php?type=' + type)
    .then(()=> loadSidebarCounts()); // refresh badges after marking
}

/* AUTO REFRESH SIDEBAR BADGES EVERY 10 SECONDS */
setInterval(loadSidebarCounts, 10000);

/* INITIAL LOAD */
loadSidebarCounts();
loadDashboard();
</script>




</body>
</html>
