<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    exit("Unauthorized");
}

$username = trim($_POST['username'] ?? '');
$email    = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$role     = $_POST['role'] ?? '';

if ($username === '' || $email === '' || $password === '' || $role === '') {
    exit("All fields required");
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    exit("Invalid email format");
}

$allowed = ['admin','landlord','user'];
if (!in_array($role,$allowed,true)) {
    exit("Invalid role");
}

/* Check duplicate username */
$checkUser = $conn->prepare("SELECT id FROM users WHERE username=?");
$checkUser->bind_param("s",$username);
$checkUser->execute();
$checkUser->store_result();
if ($checkUser->num_rows) exit("Username exists");
$checkUser->close();

/* Check duplicate email */
$checkEmail = $conn->prepare("SELECT id FROM users WHERE email=?");
$checkEmail->bind_param("s",$email);
$checkEmail->execute();
$checkEmail->store_result();
if ($checkEmail->num_rows) exit("Email exists");
$checkEmail->close();

$hash = password_hash($password,PASSWORD_DEFAULT);

$stmt = $conn->prepare("
  INSERT INTO users (username,email,password,role,status,created_at)
  VALUES (?,?,?,?, 'active', NOW())
");
$stmt->bind_param("ssss",$username,$email,$hash,$role);

echo $stmt->execute() ? "success" : "Failed";
