<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
    exit("Unauthorized");
}

$view = $_GET['view'] ?? 'active';
?>

<style>
@keyframes pop {
  from { transform:scale(0.9); opacity:0; }
  to { transform:scale(1); opacity:1; }
}

.locked {
  filter: blur(6px);
  pointer-events: none;
  user-select: none;
}

.modal-bg{
  display:none;
  position:fixed;
  inset:0;
  background:rgba(0,0,0,.5);
  align-items:center;
  justify-content:center;
  z-index:99999;
}

.modal{
  background:#fff;
  padding:25px;
  width:400px;
  border-radius:12px;
  animation:pop .25s ease;
  box-shadow:0 20px 50px rgba(0,0,0,.3);
}

.confirm-btn{
  padding:8px 14px;
  border:none;
  border-radius:6px;
  cursor:pointer;
}
</style>

<!-- SECURITY MODAL -->
<div id="securityModal" class="modal-bg" style="display:flex;">
<div class="modal">
  <h3 style="margin-top:0;color:#0f2a44;">🔐 Security Verification</h3>
  <p>Please re-enter your password to continue.</p>

  <input id="verify_password" type="password"
    placeholder="Enter your password"
    style="width:100%;padding:10px;margin-bottom:15px;border-radius:6px;border:1px solid #ccc;">

  <div style="text-align:right;">
    <button onclick="verifyAccess()" class="confirm-btn" style="background:#0f2a44;color:#fff;">
      Verify
    </button>
  </div>

  <p id="verify_error" style="color:red;font-size:13px;margin-top:10px;"></p>
</div>
</div>

<!-- ADD USER MODAL -->
<div id="addUserModal" class="modal-bg">
<div class="modal">
  <h3>➕ Add User</h3>

  <input id="add_username" placeholder="Username"
    style="width:100%;padding:10px;margin-bottom:10px;border:1px solid #ccc;border-radius:6px;">

  <input id="add_email" type="email" placeholder="Email"
    style="width:100%;padding:10px;margin-bottom:10px;border:1px solid #ccc;border-radius:6px;">

  <input id="add_password" type="password" placeholder="Password"
    style="width:100%;padding:10px;margin-bottom:10px;border:1px solid #ccc;border-radius:6px;">

  <select id="add_role"
    style="width:100%;padding:10px;margin-bottom:15px;border:1px solid #ccc;border-radius:6px;">
    <option value="admin">Admin</option>
    <option value="landlord">Landlord</option>
    <option value="user" selected>User</option>
  </select>

  <div style="text-align:right;">
    <button onclick="closeAddUserModal()" class="confirm-btn">Cancel</button>
    <button onclick="saveUser()" class="confirm-btn" style="background:#0f2a44;color:#fff;">Save</button>
  </div>
</div>
</div>

<!-- EDIT USER MODAL -->
<div id="editUserModal" class="modal-bg">
<div class="modal">
  <h3>✏ Edit User</h3>

  <input type="hidden" id="edit_id">

  <input id="edit_username"
    style="width:100%;padding:10px;margin-bottom:10px;border:1px solid #ccc;border-radius:6px;">

  <input id="edit_email" type="email"
    style="width:100%;padding:10px;margin-bottom:10px;border:1px solid #ccc;border-radius:6px;">

  <select id="edit_role"
    style="width:100%;padding:10px;margin-bottom:15px;border:1px solid #ccc;border-radius:6px;">
    <option value="admin">Admin</option>
    <option value="landlord">Landlord</option>
    <option value="user">User</option>
  </select>

  <div style="text-align:right;">
    <button onclick="closeEditUserModal()" class="confirm-btn">Cancel</button>
    <button onclick="saveEditUser()" class="confirm-btn" style="background:#0f2a44;color:#fff;">Save</button>
  </div>
</div>
</div>

<!-- MAIN CONTENT -->
<div id="usersContent" class="locked">
<div class="card">

<div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:20px;">
  <h3 style="margin:0; color:#0f2a44;">
    <?= $view === 'deleted' ? 'Deleted Users' : 'User Management' ?>
  </h3>

  <?php if ($view !== 'deleted'): ?>
  <button onclick="openAddUserModal()" style="padding:8px 14px;background:#0f2a44;color:#fff;border:none;border-radius:8px;cursor:pointer;">
    ➕ Add User
  </button>
  <?php endif; ?>
</div>

<div style="overflow-x:auto;">
<table style="width:100%;border-collapse:collapse;font-size:14px;">
<thead>
<tr style="background:#f4f6f9;">
  <th>Username</th>
  <th>Email</th>
  <th>ID</th>
  <th>Role</th>
  <th>Status</th>
  <th>Date Added</th>
  <th>Actions</th>
</tr>
</thead>
<tbody>

<?php
$where = ($view === 'deleted')
    ? "WHERE status='deleted'"
    : "WHERE status!='deleted'";

$result = $conn->query("
  SELECT id, username, email, role, status, created_at
  FROM users
  $where
  ORDER BY created_at DESC
");

while($u=$result->fetch_assoc()):
    $role = !empty($u['role']) ? $u['role'] : 'user';
?>
<tr>
  <td><?= htmlspecialchars($u['username']) ?></td>
  <td><?= htmlspecialchars($u['email']) ?></td>
  <td><?= (int)$u['id'] ?></td>
  <td><?= ucfirst($role) ?></td>
  <td><?= ucfirst($u['status']) ?></td>
  <td><?= date('Y-m-d',strtotime($u['created_at'])) ?></td>
  <td>

    <span onclick="openEditUser(
      <?= (int)$u['id'] ?>,
      '<?= htmlspecialchars($u['username'],ENT_QUOTES) ?>',
      '<?= htmlspecialchars($u['email'],ENT_QUOTES) ?>',
      '<?= $role ?>'
    )" style="cursor:pointer;">✏ Edit</span> |

    <span onclick="updateUser(<?= (int)$u['id'] ?>,'freeze')" style="cursor:pointer;">❄ Freeze</span> |
    <span onclick="updateUser(<?= (int)$u['id'] ?>,'delete')" style="cursor:pointer;color:#dc3545;">🗑 Delete</span>

  </td>
</tr>
<?php endwhile; ?>

</tbody>
</table>
</div>
</div>
</div>

<script>
function verifyAccess(){
  document.getElementById('securityModal').style.display='none';
  document.getElementById('usersContent').classList.remove('locked');
}

function openAddUserModal(){ addUserModal.style.display='flex'; }
function closeAddUserModal(){ addUserModal.style.display='none'; }

function saveUser(){
  fetch('user_action.php',{
    method:'POST',
    headers:{'Content-Type':'application/x-www-form-urlencoded'},
    body:`action=add&username=${encodeURIComponent(add_username.value)}&email=${encodeURIComponent(add_email.value)}&password=${encodeURIComponent(add_password.value)}&role=${encodeURIComponent(add_role.value)}`
  })
  .then(r=>r.text())
  .then(r=>{
    if(r==='success'){
      closeAddUserModal();
      loadPage('users.php','User Management');
    } else alert(r);
  });
}

function openEditUser(id,username,email,role){
  edit_id.value=id;
  edit_username.value=username;
  edit_email.value=email;
  edit_role.value=role;
  editUserModal.style.display='flex';
}

function closeEditUserModal(){ editUserModal.style.display='none'; }

function saveEditUser(){
  fetch('user_action.php',{
    method:'POST',
    headers:{'Content-Type':'application/x-www-form-urlencoded'},
    body:`action=edit&user_id=${edit_id.value}&username=${encodeURIComponent(edit_username.value)}&email=${encodeURIComponent(edit_email.value)}&role=${encodeURIComponent(edit_role.value)}`
  })
  .then(r=>r.text())
  .then(r=>{
    if(r==='success'){
      closeEditUserModal();
      loadPage('users.php','User Management');
    } else alert(r);
  });
}

function updateUser(id,action){
  fetch('user_action.php',{
    method:'POST',
    headers:{'Content-Type':'application/x-www-form-urlencoded'},
    body:`action=${action}&user_id=${id}`
  })
  .then(r=>r.text())
  .then(r=>{
    if(r==='success'){
      loadPage('users.php','User Management');
    } else alert(r);
  });
}
</script>
