<?php
require_once "db.php";

if (!isset($_POST['name'], $_POST['phone'], $_POST['type'], $_POST['subject'], $_POST['message'])) {
    http_response_code(400);
    exit("All fields are required");
}

$name    = trim($_POST['name']);
$phone   = trim($_POST['phone']);
$email   = !empty($_POST['email']) ? trim($_POST['email']) : null;
$type    = $_POST['type'];
$subject = trim($_POST['subject']);
$message = trim($_POST['message']);

if ($name === '' || $phone === '' || $subject === '' || $message === '') {
    exit("All fields are required");
}

if (!in_array($type, ['general', 'complaint'], true)) {
    exit("Invalid message type");
}

$stmt = $conn->prepare("
  INSERT INTO messages (name, email, phone, type, subject, message)
  VALUES (?, ?, ?, ?, ?, ?)
");

if (!$stmt) {
    http_response_code(500);
    exit("Query failed");
}

$stmt->bind_param(
    "ssssss",
    $name,
    $email,
    $phone,
    $type,
    $subject,
    $message
);

if ($stmt->execute()) {
    echo "success";
} else {
    http_response_code(500);
    echo "Failed to send message";
}
