<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
  echo json_encode(["status"=>"error","message"=>"Unauthorized"]);
  exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  echo json_encode(["status"=>"error","message"=>"Invalid request"]);
  exit;
}

/* ========= SANITIZE INPUT ========= */
$name        = trim($_POST['name'] ?? '');
$location    = trim($_POST['location'] ?? '');
$type        = $_POST['category'] ?? '';
$bedrooms    = (int)($_POST['bedrooms'] ?? 0);
$bathrooms   = (int)($_POST['bathrooms'] ?? 0);
$description = trim($_POST['description'] ?? '');

if ($name === '' || $location === '' || !in_array($type, ['single_house','apartment'])) {
  echo json_encode(["status"=>"error","message"=>"Missing required fields"]);
  exit;
}

/* ========= IMAGE VALIDATION ========= */
if (!isset($_FILES['images']) || count($_FILES['images']['name']) < 1) {
  echo json_encode(["status"=>"error","message"=>"At least 1 image required"]);
  exit;
}

if (count($_FILES['images']['name']) > 10) {
  echo json_encode(["status"=>"error","message"=>"Maximum 10 images allowed"]);
  exit;
}

/* ========= GENERATE PROPERTY CODE ========= */
$code = strtoupper(substr(md5(time().$name), 0, 8));

/* ========= INSERT PROPERTY ========= */
$stmt = $conn->prepare("
  INSERT INTO properties 
  (name, code, property_type, location, bedrooms, bathrooms, description)
  VALUES (?,?,?,?,?,?,?)
");

$stmt->bind_param(
  "ssssiss",
  $name,
  $code,
  $type,
  $location,
  $bedrooms,
  $bathrooms,
  $description
);

$stmt->execute();
$property_id = $stmt->insert_id;
$stmt->close();

/* ========= IMAGE UPLOAD ========= */
$uploadDir = "uploads/properties/";
if (!is_dir($uploadDir)) {
  mkdir($uploadDir, 0777, true);
}

$mainImage = null;

foreach ($_FILES['images']['tmp_name'] as $i => $tmp) {

  $ext = pathinfo($_FILES['images']['name'][$i], PATHINFO_EXTENSION);
  $fileName = $code . "_" . uniqid() . "." . $ext;
  $path = $uploadDir . $fileName;

  if (move_uploaded_file($tmp, $path)) {

    if ($i === 0) {
      $mainImage = $path;
    }

    $img = $conn->prepare("
      INSERT INTO property_images (property_id, image_path)
      VALUES (?,?)
    ");
    $img->bind_param("is", $property_id, $path);
    $img->execute();
    $img->close();
  }
}

/* ========= SAVE MAIN IMAGE ========= */
if ($mainImage) {
  $u = $conn->prepare("UPDATE properties SET main_image=? WHERE id=?");
  $u->bind_param("si", $mainImage, $property_id);
  $u->execute();
  $u->close();
}

echo json_encode([
  "status" => "success",
  "message" => "Property saved successfully"
]);
