<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
  exit("Unauthorized");
}

$property_id = (int)($_GET['property_id'] ?? 0);
if ($property_id <= 0) {
  exit("<div class='card'>Invalid property</div>");
}

/* PROPERTY */
$p = $conn->query("SELECT * FROM properties WHERE id=$property_id LIMIT 1")->fetch_assoc();
if (!$p) {
  exit("<div class='card'>Property not found</div>");
}

/* UNITS */
$unit = $conn->query("
  SELECT units_count, vacant_count
  FROM property_units
  WHERE property_id=$property_id
  LIMIT 1
")->fetch_assoc();

if (!$unit) {
  $unit = ['units_count'=>0,'vacant_count'=>0];
}

/* IMAGES */
$images = $conn->query("
  SELECT * FROM property_images
  WHERE property_id=$property_id
");

/* LANDLORD */
$landlord = null;
$totalManaged = 0;

if (!empty($p['landlord_id'])) {

  $landlord_id = (int)$p['landlord_id'];

  $landlord = $conn->query("
    SELECT id, name, phone, email
    FROM landlords
    WHERE id = $landlord_id
    LIMIT 1
  ")->fetch_assoc();

  if ($landlord) {
    $totalManaged = $conn->query("
      SELECT COUNT(*) as total
      FROM properties
      WHERE landlord_id = $landlord_id
    ")->fetch_assoc()['total'];
  }
}
?>

<div class="card">

<div class="pm-header">
  <h3>🏠 <?= htmlspecialchars($p['name']) ?></h3>
  <div>
    <button id="editBtn" class="btn-glass" onclick="enableEdit()">✏️ Edit</button>
    <button class="btn-glass" onclick="loadPage('property.php','Property Management')">
      ← Back
    </button>
  </div>
</div>

<div class="pm-grid">

  <!-- PROPERTY INFO -->
  <div class="pm-section">
    <h4>Property Details</h4>

    <label>Name</label>
    <input id="p_name" value="<?= htmlspecialchars($p['name']) ?>" disabled>

    <label>Location</label>
    <input id="p_location" value="<?= htmlspecialchars($p['location']) ?>" disabled>

<label>Category</label>
<select id="p_type" disabled>
  <option value="single_house" <?= $p['property_type']=='single_house'?'selected':'' ?>>
    Single House / Own Compound
  </option>
  <option value="apartment" <?= $p['property_type']=='apartment'?'selected':'' ?>>
    Flats / Apartment
  </option>
</select>


    <label>Description</label>
    <textarea id="p_description" rows="4" disabled><?= htmlspecialchars($p['description']) ?></textarea>
  </div>

  <!-- UNITS -->
  <div class="pm-section">
    <h4>Units & Vacancy</h4>

    <label>Total Units</label>
    <input type="number" id="totalUnits" value="<?= (int)$unit['units_count'] ?>" disabled>

    <label>Vacant Units</label>
    <input type="number" id="vacantUnits" value="<?= (int)$unit['vacant_count'] ?>" disabled>
  </div>

</div>

<!-- IMAGES -->
<div class="pm-section" style="margin-top:30px;">
  <h4>Property Images</h4>
  <div class="image-wrap">
    <?php while($img=$images->fetch_assoc()): ?>
      <img src="<?= $img['image_path'] ?>">
    <?php endwhile; ?>
  </div>
</div>

<!-- LANDLORD SECTION -->
<div class="pm-section landlord-box">

  <h4>👤 Landlord Details</h4>

  <input type="hidden" id="landlord_id" value="<?= $landlord['id'] ?? '' ?>">

  <label>Full Name</label>
  <input id="l_name" value="<?= htmlspecialchars($landlord['name'] ?? '') ?>" disabled>

  <label>Phone Number</label>
  <input id="l_phone" value="<?= htmlspecialchars($landlord['phone'] ?? '') ?>" disabled>

  <label>Email Address</label>
  <input id="l_email" value="<?= htmlspecialchars($landlord['email'] ?? '') ?>" disabled>

  <label>Total Properties Managed</label>
  <input value="<?= (int)$totalManaged ?>" disabled>

</div>

<div style="margin-top:25px;">
  <button id="saveBtn" class="btn-save" onclick="saveProperty()" style="display:none;">
    💾 Save Changes
  </button>
</div>

</div>

<style>
.pm-header{
  display:flex;
  justify-content:space-between;
  align-items:center;
  margin-bottom:25px;
}

.pm-grid{
  display:grid;
  grid-template-columns:1fr 1fr;
  gap:30px;
}

.pm-section{
  background:#fff;
  padding:20px;
  border-radius:12px;
  box-shadow:0 2px 10px rgba(0,0,0,0.05);
}

.landlord-box{
  margin-top:40px;
  background:#f9fbfd;
  border:1px solid #e2e8f0;
}

label{
  font-size:13px;
  font-weight:600;
  margin-top:12px;
  display:block;
}

input, select, textarea{
  width:100%;
  padding:9px;
  border-radius:8px;
  border:1px solid #ccc;
  margin-top:5px;
}

.image-wrap{
  display:flex;
  gap:15px;
  flex-wrap:wrap;
}

.image-wrap img{
  width:140px;
  height:110px;
  object-fit:cover;
  border-radius:10px;
}

.btn-glass{
  background:#0f2a44;
  color:#fff;
  padding:9px 18px;
  border:none;
  border-radius:10px;
  cursor:pointer;
}

.btn-save{
  background:#28a745;
  color:#fff;
  padding:10px 24px;
  border:none;
  border-radius:10px;
  cursor:pointer;
}
</style>

<script>
function enableEdit(){
  document.querySelectorAll('input,select,textarea').forEach(e=>{
    if(e.id !== '' && e.type !== 'hidden') e.disabled = false;
  });
  editBtn.style.display='none';
  saveBtn.style.display='inline-block';
}

function saveProperty(){

  const fd = new FormData();

  fd.append('property_id', <?= $property_id ?>);
  fd.append('name', p_name.value);
  fd.append('location', p_location.value);
  fd.append('property_type', p_type.value);
  fd.append('description', p_description.value);
  fd.append('units_count', totalUnits.value);
  fd.append('vacant_count', vacantUnits.value);

  fd.append('landlord_id', landlord_id.value);
  fd.append('l_name', l_name.value);
  fd.append('l_phone', l_phone.value);
  fd.append('l_email', l_email.value);

  fetch('property_full_save.php', { method:'POST', body:fd })
  .then(r=>r.json())
  .then(r=>{
    if(r.status==='success'){
      alert('✅ Changes saved successfully');
      loadPage('property_manage.php?property_id=<?= $property_id ?>','Manage Property');
    }else{
      alert('❌ Failed to save');
    }
  })
  .catch(()=>alert('❌ Server error'));
}
</script>
