<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
  exit("Unauthorized");
}
?>

<style>
.pm-backdrop{
  position:fixed;
  inset:0;
  background:rgba(0,0,0,0.45);
  backdrop-filter:blur(8px);
  display:flex;
  align-items:center;
  justify-content:center;
  z-index:9999;
}

.pm-modal{
  background:rgba(255,255,255,0.95);
  border-radius:20px;
  padding:25px;
  width:95%;
  max-width:560px;
  max-height:90vh;
  overflow-y:auto;
  box-shadow:0 25px 60px rgba(0,0,0,0.3);
  animation:pop .25s ease;
}

@keyframes pop{
  from{transform:scale(.85);opacity:0}
  to{transform:scale(1);opacity:1}
}

.pm-modal h3{
  margin:0 0 15px;
  color:#0f2a44;
}

.pm-form div{margin-bottom:12px;}

.pm-form input,
.pm-form select,
.pm-form textarea{
  width:100%;
  padding:10px 12px;
  border-radius:10px;
  border:1px solid #ddd;
  font-size:14px;
}

.pm-form textarea{
  resize:vertical;
  min-height:90px;
}

.pm-form input:focus,
.pm-form select:focus,
.pm-form textarea:focus{
  border-color:#0f2a44;
  outline:none;
}

.pm-actions{
  display:flex;
  justify-content:flex-end;
  gap:10px;
  margin-top:15px;
}

.btn-cancel{
  background:#ccc;
  border:none;
  padding:10px 16px;
  border-radius:10px;
  cursor:pointer;
}

.btn-save{
  background:#0f2a44;
  color:#fff;
  border:none;
  padding:10px 18px;
  border-radius:10px;
  cursor:pointer;
  font-weight:600;
}

.helper-text{
  font-size:12px;
  color:#777;
}

.checkbox-row{
  display:flex;
  align-items:center;
  gap:10px;
  margin-bottom:8px;
}
.checkbox-row input{
  width:auto;
  margin:0;
}
.checkbox-row label{
  margin:0;
  cursor:pointer;
}

/* 🔹 Landlord Section */
.landlord-box{
  border:2px solid #000;
  padding:15px;
  border-radius:12px;
  margin-bottom:15px;
}
.landlord-box h4{
  margin:0 0 10px;
}
</style>

<div class="pm-backdrop" onclick="closeAddProperty()">
  <div class="pm-modal" onclick="event.stopPropagation()">

    <h3>Add Property</h3>

    <form class="pm-form" id="propertyForm" onsubmit="saveProperty(event)" enctype="multipart/form-data">

      <!-- ================= PROPERTY DETAILS ================= -->

      <div>
        <input type="text" id="propName" placeholder="Property Name" required>
      </div>

      <div>
        <input type="text" id="propLocation" placeholder="Location (e.g. Eldoret, Langas)" required>
      </div>

      <div>
        <select id="propCategory" onchange="toggleCategoryFields()" required>
          <option value="">Select Category</option>
          <option value="single_house">Single House / Own Compound</option>
          <option value="apartment">Flats / Apartment</option>
        </select>
      </div>

      <div id="singleHouseWrap" style="display:none;">
        <div><input type="number" id="bedrooms" min="0" placeholder="Number of Bedrooms"></div>
        <div><input type="number" id="bathrooms" min="0" placeholder="Number of Bathrooms"></div>
      </div>

      <div id="apartmentWrap" style="display:none;">

        <div>
          <select id="unitType" onchange="toggleUnitType()">
            <option value="">Select Type of Units</option>
            <option value="studio">Studio / Bedsitter</option>
            <option value="1br">1 Bedroom</option>
            <option value="2br">2 Bedroom</option>
            <option value="3br">3 Bedroom</option>
            <option value="4br">4 Bedroom</option>
            <option value="4plus">4+ Bedroom</option>
            <option value="mixed">Mixed</option>
          </select>
        </div>

        <div id="mixedWrap" style="display:none;">
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="studio"> Studio</div>
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="1br"> 1 Bedroom</div>
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="2br"> 2 Bedroom</div>
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="3br"> 3 Bedroom</div>
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="4br"> 4 Bedroom</div>
          <div class="checkbox-row"><input type="checkbox" class="mixedUnit" value="4plus"> 4+ Bedroom</div>
        </div>

        <div id="unitCountWrap" style="display:none;">
          <input type="number" id="unitCount" min="1" placeholder="Total Number of Units">
        </div>

      </div>

      <div>
        <textarea id="description" placeholder="Property Description" required></textarea>
      </div>

      <!-- ================= LANDLORD DETAILS ================= -->

      <div class="landlord-box">
        <h4>👤 Landlord Details</h4>

        <div>
          <input type="text" id="landlordName" placeholder="Landlord Full Name" required>
        </div>

        <div>
          <input type="text" id="landlordPhone" placeholder="Phone Number (e.g. 0712345678)" required>
        </div>

        <div>
          <input type="email" id="landlordEmail" placeholder="Email Address" required>
        </div>
      </div>

      <!-- ================= IMAGES ================= -->

      <div>
        <input type="file" id="images" multiple accept="image/*" onchange="validateImages(this)" required>
        <div class="helper-text">Upload minimum 1 and maximum 10 images</div>
      </div>

      <div class="pm-actions">
        <button type="button" class="btn-cancel" onclick="closeAddProperty()">Cancel</button>
        <button type="submit" class="btn-save">Save Property</button>
      </div>

    </form>

  </div>
</div>

<script>
function toggleCategoryFields(){
  singleHouseWrap.style.display = (propCategory.value === 'single_house') ? 'block' : 'none';
  apartmentWrap.style.display = (propCategory.value === 'apartment') ? 'block' : 'none';
}

function toggleUnitType(){
  mixedWrap.style.display = (unitType.value === 'mixed') ? 'block' : 'none';
  unitCountWrap.style.display = unitType.value ? 'block' : 'none';
}

function validateImages(input){
  if(input.files.length < 1){
    alert('Please upload at least 1 image.');
    input.value='';
  }
  if(input.files.length > 10){
    alert('Maximum 10 images allowed.');
    input.value='';
  }
}

function saveProperty(e){
  e.preventDefault();

  const formData = new FormData();

  /* PROPERTY */
  formData.append('name', propName.value);
  formData.append('location', propLocation.value);
  formData.append('category', propCategory.value);
  formData.append('description', description.value);

  /* LANDLORD */
  formData.append('landlord_name', landlordName.value);
  formData.append('landlord_phone', landlordPhone.value);
  formData.append('landlord_email', landlordEmail.value);

  if(propCategory.value === 'single_house'){
    formData.append('bedrooms', bedrooms.value);
    formData.append('bathrooms', bathrooms.value);
  }

  if(propCategory.value === 'apartment'){
    formData.append('unitType', unitType.value);
    formData.append('unitCount', unitCount.value);

    if(unitType.value === 'mixed'){
      let selected = [];
      document.querySelectorAll('.mixedUnit:checked').forEach(cb=>{
        selected.push(cb.value);
      });
      formData.append('mixedUnits', JSON.stringify(selected));
    }
  }

  for(let i=0;i<images.files.length;i++){
    formData.append('images[]', images.files[i]);
  }

  fetch('property_save.php',{method:'POST',body:formData})
    .then(res=>res.json())
    .then(data=>{
      if(data.status === 'success'){
        alert('✅ Property saved successfully');
        closeAddProperty();
        loadPage('property.php','Property Management');
      }else{
        alert(data.message);
      }
    })
    .catch(()=>alert('❌ Failed to save property'));
}
</script>
