<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
  exit("Unauthorized");
}

/* FETCH PROPERTIES WITH LANDLORD */
$sql = "
  SELECT 
    p.id,
    p.name,
    p.location,
    p.property_type,
    p.main_image,
    l.name   AS landlord_name,
    l.phone  AS landlord_phone,
    l.email  AS landlord_email,

    /* TOTAL UNITS */
    (
      SELECT COALESCE(SUM(u.units_count),0)
      FROM property_units u
      WHERE u.property_id = p.id
    ) AS total_units,

    /* VACANT UNITS */
    (
      SELECT COALESCE(SUM(u.vacant_count),0)
      FROM property_units u
      WHERE u.property_id = p.id
    ) AS vacant_units

  FROM properties p
  LEFT JOIN landlords l ON p.landlord_id = l.id
  ORDER BY p.created_at DESC
";

$result = $conn->query($sql);
?>

<style>
.pm-header{
  display:flex;
  justify-content:space-between;
  align-items:center;
  margin-bottom:20px;
}
.pm-header h3{
  margin:0;
  color:#0f2a44;
}

.btn-glass{
  background:#0f2a44;
  color:#fff;
  padding:10px 18px;
  border-radius:12px;
  border:none;
  cursor:pointer;
  font-weight:600;
}

.pm-table{
  width:100%;
  border-collapse:collapse;
  font-size:14px;
}
.pm-table th,
.pm-table td{
  padding:12px;
  border-bottom:1px solid #eee;
  vertical-align:middle;
}
.pm-table th{
  background:#f4f6f9;
  text-align:left;
}

.property-thumb{
  width:52px;
  height:40px;
  border-radius:6px;
  object-fit:cover;
  border:1px solid #ddd;
}

.empty-state{
  text-align:center;
  padding:40px;
  color:#888;
}

/* landlord text styling */
.landlord-info{
  font-size:13px;
  line-height:1.4;
}
.landlord-info strong{
  display:block;
  color:#0f2a44;
}
</style>

<div class="card">

  <div class="pm-header">
    <h3>Property Management</h3>
    <button class="btn-glass" onclick="openAddProperty()">➕ Add Property</button>
  </div>

  <div style="overflow-x:auto;">
    <table class="pm-table">
      <thead>
        <tr>
          <th>Photo</th>
          <th>Name</th>
          <th>Type</th>
          <th>Location</th>
          <th>Landlord</th>
          <th>Units</th>
          <th>Vacant</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>

<?php if ($result && $result->num_rows): while($p = $result->fetch_assoc()): ?>
<tr>

  <!-- PHOTO -->
  <td>
    <?php if (!empty($p['main_image']) && file_exists($p['main_image'])): ?>
      <img src="<?= $p['main_image'] ?>" class="property-thumb">
    <?php else: ?>
      <img src="assets/no-image.png" class="property-thumb">
    <?php endif; ?>
  </td>

  <!-- NAME -->
  <td><?= htmlspecialchars($p['name']) ?></td>

  <!-- TYPE -->
  <td>
    <?= $p['property_type'] === 'apartment'
        ? 'Apartment / Flats'
        : 'Single House / Own Compound' ?>
  </td>

  <!-- LOCATION -->
  <td><?= htmlspecialchars($p['location']) ?></td>

  <!-- LANDLORD DETAILS -->
  <td>
    <?php if($p['landlord_name']): ?>
      <div class="landlord-info">
        <strong><?= htmlspecialchars($p['landlord_name']) ?></strong>
        📞 <?= htmlspecialchars($p['landlord_phone']) ?><br>
        📧 <?= htmlspecialchars($p['landlord_email']) ?>
      </div>
    <?php else: ?>
      —
    <?php endif; ?>
  </td>

  <!-- TOTAL UNITS -->
  <td>
    <?= $p['property_type'] === 'apartment'
        ? (int)$p['total_units']
        : '1' ?>
  </td>

  <!-- VACANT UNITS -->
  <td style="color:#28a745;font-weight:600;">
    <?= $p['property_type'] === 'apartment'
        ? (int)$p['vacant_units']
        : '—' ?>
  </td>

  <!-- ACTION -->
  <td>
    <span style="color:#0f2a44;cursor:pointer;font-weight:600;"
          onclick="manageProperty(<?= $p['id'] ?>,'<?= htmlspecialchars($p['name'],ENT_QUOTES) ?>')">
      🏠 Manage
    </span>
  </td>

</tr>
<?php endwhile; else: ?>
<tr>
  <td colspan="8">
    <div class="empty-state">
      🏘 No properties added yet.<br>
      Click <strong>Add Property</strong> to get started.
    </div>
  </td>
</tr>
<?php endif; ?>

      </tbody>
    </table>
  </div>

</div>

<div id="addPropertyModal" style="display:none;"></div>

<script>
function openAddProperty(){
  fetch('property_add.php')
    .then(r => r.text())
    .then(html => {
      const modal = document.getElementById('addPropertyModal');
      modal.innerHTML = html;
      modal.style.display = 'flex';

      modal.querySelectorAll('script').forEach(oldScript => {
        const s = document.createElement('script');
        s.text = oldScript.textContent;
        document.body.appendChild(s);
        oldScript.remove();
      });
    });
}

function closeAddProperty(){
  const modal = document.getElementById('addPropertyModal');
  modal.style.display = 'none';
  modal.innerHTML = '';
}

function manageProperty(propertyId, propertyName){
  loadPage(
    'property_manage.php?property_id=' + propertyId,
    'Manage Property – ' + propertyName
  );
}
</script>
