<?php
require_once "db.php";

/* Access control */
if (!isset($_SESSION['user_id'])) {
    exit("Unauthorized");
}

$typeFilter = $_GET['type'] ?? 'all';
?>

<style>
/* ===== MESSAGE STYLES ===== */
.msg-new {
  background:#e9f9ef;
  font-weight:600;
}

.msg-row:hover {
  background:#f4f6f9;
  cursor:pointer;
}

/* ===== MODAL ===== */
.modal-backdrop-custom {
  position:fixed;
  inset:0;
  background:rgba(0,0,0,0.45);
  backdrop-filter: blur(6px);
  display:flex;
  align-items:center;
  justify-content:center;
  z-index:9999;
}

.modal-card {
  background:#ffffff;
  border-radius:18px;
  padding:25px;
  width:90%;
  max-width:520px;
  box-shadow:0 20px 50px rgba(0,0,0,0.25);
  animation: pop 0.25s ease;
}

@keyframes pop {
  from {transform:scale(0.85); opacity:0;}
  to {transform:scale(1); opacity:1;}
}
</style>

<div class="card">

  <!-- HEADER -->
  <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;">
    <h3 style="margin:0;color:#0f2a44;">Messages</h3>

    <select id="msgFilter" onchange="applyMessageFilter()" style="padding:8px 12px;border-radius:10px;">
      <option value="all" <?= $typeFilter==='all'?'selected':'' ?>>All</option>
      <option value="general" <?= $typeFilter==='general'?'selected':'' ?>>General</option>
      <option value="complaint" <?= $typeFilter==='complaint'?'selected':'' ?>>Complaints</option>
    </select>
  </div>

  <!-- TABLE -->
  <div style="overflow-x:auto;">
    <table style="width:100%;border-collapse:collapse;font-size:14px;">
      <thead>
        <tr style="background:#f4f6f9;">
          <th style="padding:12px;">Name</th>
          <th style="padding:12px;">Type</th>
          <th style="padding:12px;">Subject</th>
          <th style="padding:12px;">Date</th>
          <th style="padding:12px;">Actions</th>
        </tr>
      </thead>
      <tbody>

<?php
$where = "";
$params = [];
$types = "";

if ($typeFilter !== 'all') {
    $where = "WHERE type = ?";
    $params[] = $typeFilter;
    $types .= "s";
}

$sql = "
  SELECT id,name,email,phone,type,subject,message,status,created_at
  FROM messages
  $where
  ORDER BY created_at DESC
";

$stmt = $conn->prepare($sql);
if ($params) $stmt->bind_param($types, ...$params);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows):
  while ($m = $res->fetch_assoc()):
?>

<tr id="msg-<?= $m['id'] ?>"
    class="msg-row <?= $m['status']==='new'?'msg-new':'' ?>"
    onclick="openMessage(<?= $m['id'] ?>)">
  <td style="padding:12px;"><?= htmlspecialchars($m['name']) ?></td>
  <td style="padding:12px;"><?= ucfirst($m['type']) ?></td>
  <td style="padding:12px;"><?= htmlspecialchars($m['subject']) ?></td>
  <td style="padding:12px;"><?= date('Y-m-d',strtotime($m['created_at'])) ?></td>
  <td style="padding:12px;">
    <span style="color:#dc3545;font-weight:600;cursor:pointer;"
          onclick="event.stopPropagation(); deleteMessage(<?= $m['id'] ?>)">
      🗑 Delete
    </span>
  </td>
</tr>

<?php endwhile; else: ?>
<tr>
  <td colspan="5" style="padding:18px;text-align:center;color:#999;">
    No messages found
  </td>
</tr>
<?php endif; ?>

      </tbody>
    </table>
  </div>

</div>

<!-- MODAL CONTAINER -->
<div id="messageModal" style="display:none;"></div>

<script>
function applyMessageFilter(){
  const t = document.getElementById('msgFilter').value;
  loadPage('messages.php?type='+t,'Messages');
}

function openMessage(id){
  fetch('message_view.php?id='+id)
    .then(r => r.text())
    .then(html => {
      const modal = document.getElementById('messageModal');
      modal.innerHTML = html;
      modal.style.display = 'flex';

      // Remove highlight instantly
      document.getElementById('msg-'+id)?.classList.remove('msg-new');
    });
}

function closeMessage(){
  const modal = document.getElementById('messageModal');
  modal.style.display = 'none';
  modal.innerHTML = '';
}

function deleteMessage(id){
  if(!confirm('Delete this message permanently?')) return;

  fetch('message_delete.php', {
    method: 'POST',
    headers: {'Content-Type':'application/x-www-form-urlencoded'},
    body: 'id=' + id
  })
  .then(r => r.text())
  .then(r => {
    if(r === 'success'){
      document.getElementById('msg-' + id)?.remove();
    } else {
      alert(r);
    }
  });
}
</script>
