<?php
require_once "db.php";

if (!isset($_GET['id'])) exit("Invalid request");

$landlord_id = (int) $_GET['id'];

/* ---------------- LANDLORD INFO ---------------- */
$stmt = $conn->prepare("SELECT * FROM landlords WHERE id=? LIMIT 1");
$stmt->bind_param("i", $landlord_id);
$stmt->execute();
$landlord = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$landlord) exit("Landlord not found");

/* ---------------- STATS ---------------- */
/* Total properties */
$stmt = $conn->prepare("SELECT COUNT(*) AS c FROM properties WHERE landlord_id=?");
$stmt->bind_param("i", $landlord_id);
$stmt->execute();
$totalProps = $stmt->get_result()->fetch_assoc()['c'] ?? 0;
$stmt->close();

/* Total repairs - only if table exists */
$totalRepairs = 0;
$tableExists = $conn->query("SHOW TABLES LIKE 'repairs'");
if ($tableExists && $tableExists->num_rows > 0) {
    $stmt = $conn->prepare("SELECT COUNT(*) AS c FROM repairs WHERE landlord_id=?");
    $stmt->bind_param("i", $landlord_id);
    $stmt->execute();
    $totalRepairs = $stmt->get_result()->fetch_assoc()['c'] ?? 0;
    $stmt->close();
}
?>

<h2><?= htmlspecialchars($landlord['name']) ?></h2>
<p>Email: <?= htmlspecialchars($landlord['email']) ?></p>
<p>Phone: <?= htmlspecialchars($landlord['phone']) ?></p>

<div class="stat-grid">
    <div class="stat-card">
        <h4>Properties</h4>
        <h2><?= $totalProps ?></h2>
    </div>
    <div class="stat-card">
        <h4>Repairs</h4>
        <h2><?= $totalRepairs ?></h2>
    </div>
</div>

<div class="tab-buttons">
    <button onclick="showTab('properties', this)" class="active">Properties</button>
    <button onclick="showTab('repairs', this)">Repairs</button>
</div>

<div id="tabContent">
    <!-- DEFAULT PROPERTIES TAB -->
    <h3>Add Property</h3>

    <input id="prop_name" placeholder="Property Name">
    <input id="prop_location" placeholder="Location">
    <input id="prop_units" type="number" placeholder="Total Units">
    <input id="prop_rent" type="number" placeholder="Rent Price">

    <button onclick="addProperty(<?= $landlord_id ?>)"
        style="background:#0f2a44;color:#fff;padding:10px 15px;border:none;border-radius:8px;">
        Add Property
    </button>

    <hr>

    <h3>Existing Properties</h3>

    <?php
    $stmt = $conn->prepare("SELECT * FROM properties WHERE landlord_id=?");
    $stmt->bind_param("i", $landlord_id);
    $stmt->execute();
    $props = $stmt->get_result();

    while($p = $props->fetch_assoc()):
    ?>
    <div style="padding:10px 0;border-bottom:1px solid #eee">
        <strong><?= htmlspecialchars($p['name']) ?></strong><br>
        <small><?= htmlspecialchars($p['location']) ?></small>
    </div>
    <?php endwhile; $stmt->close(); ?>
</div>

<script>
function showTab(tab, btn){
    document.querySelectorAll('.tab-buttons button')
        .forEach(b => b.classList.remove('active'));
    btn.classList.add('active');

    fetch(`landlord_tab.php?id=<?= $landlord_id ?>&tab=${tab}`)
        .then(r => r.text())
        .then(html => {
            document.getElementById('tabContent').innerHTML = html;
        });
}

function addProperty(id){
    const name = encodeURIComponent(document.getElementById('prop_name').value.trim());
    const location = encodeURIComponent(document.getElementById('prop_location').value.trim());
    const units = document.getElementById('prop_units').value;
    const rent = document.getElementById('prop_rent').value;

    if (!name || !location || !units || !rent) {
        alert('All fields are required');
        return;
    }

    fetch('landlord_action.php', {
        method: 'POST',
        headers: {'Content-Type':'application/x-www-form-urlencoded'},
        body: `action=add_property&landlord_id=${id}&name=${name}&location=${location}&units=${units}&rent=${rent}`
    })
    .then(r => r.text())
    .then(r => {
        if(r === 'success'){
            alert('Property Added');
            showTab('properties', document.querySelector('.tab-buttons button.active'));
        } else {
            alert(r);
        }
    });
}
</script>
