<?php
require_once "db.php";

if(!isset($_POST['action'])) exit("Invalid");

if($_POST['action']==='add_property'){

    $landlord = (int)$_POST['landlord_id'];
    $name = trim($_POST['name']);
    $location = trim($_POST['location']);
    $units = (int)$_POST['units'];
    $rent = (float)$_POST['rent'];

    if(!$landlord || $name=='' || $location==''){
        exit("Invalid data");
    }

    $stmt = $conn->prepare("
        INSERT INTO properties
        (landlord_id,name,location,total_units,rent,status,created_at)
        VALUES (?,?,?,?,?,'active',NOW())
    ");
    $stmt->bind_param("issid",
        $landlord,$name,$location,$units,$rent
    );

    if($stmt->execute()){
        echo "success";
    } else {
        echo "Database error";
    }
}
