<?php
require_once "db.php";

/* FETCH VACANT HOUSE HIGHLIGHTS (MAX 6) */
$vacantHouses = $conn->query("
  SELECT 
    p.id,
    p.name,
    p.location,
    p.description,
    p.main_image,
    (
      SELECT COALESCE(SUM(u.vacant_count),0)
      FROM property_units u
      WHERE u.property_id = p.id
    ) AS vacant_units
  FROM properties p
  HAVING vacant_units > 0
  ORDER BY p.created_at DESC
  LIMIT 6
");
?>


<!DOCTYPE html>
<html>

<head>
  <!-- Basic -->
  <meta charset="utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <!-- Mobile Metas -->
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <!-- Site Metas -->
  <meta name="keywords" content="" />
  <meta name="description" content="" />
  <meta name="author" content="" />

  <title>Lifeshed Realtors</title>

  <!-- bootstrap core css -->
  <link rel="stylesheet" type="text/css" href="css/bootstrap.css" />

  <!-- fonts style -->
  <link href="https://fonts.googleapis.com/css?family=Poppins:400,700|Raleway:400,700&display=swap" rel="stylesheet">
  <!-- Custom styles for this template -->
  <link href="css/style.css" rel="stylesheet" />
  <!-- responsive style -->
  <link href="css/responsive.css" rel="stylesheet" />
</head>

<body>
  <div class="hero_area">
    <!-- header section strats -->
    <header class="header_section">
      <div class="container-fluid">
        <nav class="navbar navbar-expand-lg custom_nav-container">
          <a class="navbar-brand" href="index.php">
            <img src="images/logo.png" alt="" />
          </a>
          <div class="navbar-collapse" id="">
            <ul class="navbar-nav justify-content-between ">
              <div class="User_option">
                <li class=""><?php if (!isset($_SESSION['user_id'])): ?>
  <a href="login.php" class="nav-link">Login</a>
<?php endif; ?>

       </li>
              </div>
            </ul>

            <div class="custom_menu-btn">
              <button onclick="openNav()">
                <span class="s-1">

                </span>
                <span class="s-2">

                </span>
                <span class="s-3">

                </span>
              </button>
            </div>
            <div id="myNav" class="overlay">
              <div class="overlay-content">
                <a href="index.php">HOME</a>
                <a href="about.html">ABOUT</a>
                <a href="house.php">HOUSE</a>
                <a href="price.html">PRICING</a>
                <a href="contact.php">CONTACT US NOW</a>
              </div>
            </div>
          </div>
        </nav>
      </div>
    </header>
    <!-- end header section -->


    <!-- slider section -->
<section class="slider_section ">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-4 offset-md-1">
        <div class="detail-box">
          <h1>
            <span>Lifeshed</span> <br>
            Realtors <br>
            & Property Managers
          </h1>
          <p>
            We provide reliable property management, rental solutions, and real estate services
            designed to give you peace of mind and lasting value.
          </p>
          <div class="btn-box">
            <a href="house.php" class="">
              View Properties
            </a>
          </div>
        </div>
      </div>
    </div>

  </div>
</section>
<!-- end slider section -->

  </div>



<!-- What we do section -- >
<!-- what we do section -->
<section style="padding: 80px 0; background: linear-gradient(135deg, #f5f7fa, #e4ebf5);">

  <style>
    .what-we-do-heading h2 {
      font-weight: 700;
      margin-bottom: 10px;
    }

    .what-we-do-heading p {
      color: #555;
      margin-bottom: 50px;
    }

    .glass-card {
      height: 100%;
      padding: 30px 25px;
      border-radius: 18px;
      background: rgba(255, 255, 255, 0.25);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      border: 1px solid rgba(255, 255, 255, 0.3);
      box-shadow: 0 8px 32px rgba(31, 38, 135, 0.15);
      transition: all 0.4s ease;
      text-align: center;
      cursor: pointer;
    }

    .glass-card h4 {
      font-weight: 600;
      margin-bottom: 15px;
    }

    .glass-card p {
      color: #444;
      font-size: 15px;
      line-height: 1.6;
    }

    .glass-card:hover {
      transform: translateY(-12px) scale(1.03);
      box-shadow: 0 20px 45px rgba(31, 38, 135, 0.25);
      background: rgba(255, 255, 255, 0.4);
    }
  </style>

  <div class="container">
    <div class="row">
      <div class="col-12 text-center what-we-do-heading">
        <h2>What We Do</h2>
        <p>Professional real estate solutions you can trust</p>
      </div>
    </div>

    <div class="row justify-content-center">

      <div class="col-md-4 mb-4">
        <div class="glass-card">
          <h4>Property Management</h4>
          <p>
            We offer comprehensive property management services including rent
            collection, tenant relations, maintenance coordination, and
            detailed reporting for property owners.
          </p>
        </div>
      </div>

      <div class="col-md-4 mb-4">
        <div class="glass-card">
          <h4>Estate Agency</h4>
          <p>
            Our estate agency services connect buyers, sellers, landlords,
            and tenants through professional marketing, leasing, and sales
            solutions.
          </p>
        </div>
      </div>

      <div class="col-md-4 mb-4">
        <div class="glass-card">
          <h4>Consultancy</h4>
          <p>
            We provide expert real estate consultancy, offering market insights,
            property valuation guidance, and investment advisory services.
          </p>
        </div>
      </div>

    </div>
  </div>
</section>
<!-- end what we do section -->


 <div class="container">
    <div class="row justify-content-center">

      <!-- Book a vacant house -->
      <div class="col-md-4 mb-4">
        <div class="action-card">
          <h4>Book a Vacant House</h4>
          <p>
            Looking for a house to rent? Browse our available properties and
            book a vacant house that suits your needs.
          </p>
          <a href="house.php">View Vacancies</a>
        </div>
      </div>

      <!-- Landlord management request -->
      <div class="col-md-4 mb-4">
        <div class="action-card">
          <h4>Are You a Landlord?</h4>
          <p>
            Let Lifeshed Realtors manage your property professionally.
            Request for property management services today.
          </p>
          <a href="javascript:void(0)" onclick="openLandlordModal()">Request Management</a>

        </div>
      </div>

      <!-- Tenant suggestion box -->
      <div class="col-md-4 mb-4">
        <div class="action-card">
          <h4>Tenant Comments/Complains</h4>
          <p>
            We value your feedback. Share your suggestions or concerns to
            help us improve our services.
          </p>
          <a href="contact.php">Talk To Us</a>


        </div>
      </div>

    </div>
  </div>
</section>
<!-- end action section -->

  <!-- about section -->
<!-- about section -->
<section class="about_section layout_padding-bottom" style="padding-bottom: 80px;">

  <style>
    .about_lifeshed h2 {
      font-weight: 700;
      margin-bottom: 15px;
    }

    .about_lifeshed p {
      color: #444;
      line-height: 1.7;
      margin-bottom: 20px;
    }

    .about_lifeshed ul {
      padding-left: 18px;
      margin-bottom: 25px;
    }

    .about_lifeshed ul li {
      margin-bottom: 8px;
      color: #333;
    }

    .about_lifeshed a {
      display: inline-block;
      padding: 10px 28px;
      background: #2c2c2c;
      color: #fff;
      text-decoration: none;
      border-radius: 6px;
      transition: background 0.3s ease;
    }

    .about_lifeshed a:hover {
      background: #000;
    }

    .about_img img {
      border-radius: 18px;
      box-shadow: 0 15px 40px rgba(0,0,0,0.15);
    }
  </style>









  <div class="square-box">
    <img src="images/square.png" alt="">
  </div>

  <div class="container">
    <div class="row align-items-center">

      <div class="col-md-6">
        <div class="img-box about_img">
          <img src="images/logo.png" alt="Lifeshed Realtors">
        </div>
      </div>

      <div class="col-md-6">
        <div class="detail-box about_lifeshed">
          <div class="heading_container">
            <h2>About Lifeshed Realtors</h2>
          </div>

          <p>
            Lifeshed Realtors is a trusted real estate firm specializing in
            property management, estate agency, and real estate consultancy.
            We are committed to delivering reliable, transparent, and
            value-driven property solutions.
          </p>

          <p>
            Our approach combines market knowledge, professional service,
            and modern systems to ensure property owners, tenants, and
            investors experience seamless real estate management.
          </p>

          <ul>
            <li>✔ Professional property management</li>
            <li>✔ Transparent rent collection & reporting</li>
            <li>✔ Strategic property marketing</li>
            <li>✔ Expert real estate advisory</li>
          </ul>

          <a href="about.html">Learn More</a>
        </div>
      </div>

    </div>
  </div>
</section>
<!-- end about section -->


<!-- Our Happy Partners Section -->
<section style="padding: 70px 0; background: #ffffff; overflow: hidden;">

  <style>
    .partners-heading h2 {
      font-weight: 700;
      margin-bottom: 10px;
    }

    .partners-heading p {
      color: #555;
      margin-bottom: 40px;
    }

    .partners-wrapper {
      width: 100%;
      overflow: hidden;
      position: relative;
    }

    .partners-track {
      display: flex;
      width: max-content;
      animation: scrollPartners 30s linear infinite;
    }

    /* Pause animation on hover */
    .partners-wrapper:hover .partners-track {
      animation-play-state: paused;
    }

    .partner-card {
      min-width: 260px;
      margin: 0 15px;
      padding: 25px 20px;
      border-radius: 16px;
      background: rgba(255, 255, 255, 0.6);
      box-shadow: 0 10px 30px rgba(0,0,0,0.1);
      text-align: center;
      backdrop-filter: blur(8px);
      -webkit-backdrop-filter: blur(8px);
      flex-shrink: 0;
    }

    .partner-card img {
      width: 70px;
      height: 70px;
      object-fit: contain;
      margin-bottom: 15px;
    }

    .partner-card h5 {
      font-weight: 600;
      margin-bottom: 6px;
    }

    .partner-card p {
      font-size: 14px;
      color: #444;
      margin: 0;
    }

    /* TRUE infinite scroll animation */
    @keyframes scrollPartners {
      from {
        transform: translateX(0);
      }
      to {
        transform: translateX(-50%);
      }
    }
  </style>

  <div class="container">
    <div class="row">
      <div class="col-12 text-center partners-heading">
        <h2>Our Happy Partners</h2>
        <p>Trusted collaborations that help us deliver excellence</p>
      </div>
    </div>
  </div>

  <div class="partners-wrapper">
    <div class="partners-track">

      <!-- ORIGINAL SET -->
      <div class="partner-card">
        <img src="images/logo2.webp" alt="Greenfield Holdings">
        <h5>Greenfield Holdings</h5>
        <p>Residential Property Owners</p>
      </div>

      <div class="partner-card">
        <img src="images/logo1.webp" alt="Urban Crest Ltd">
        <h5>Urban Crest Ltd</h5>
        <p>Commercial Real Estate</p>
      </div>

      <div class="partner-card">
        <img src="images/logo3.webp" alt="PrimeStay Homes">
        <h5>PrimeStay Homes</h5>
        <p>Rental Apartments</p>
      </div>

      <div class="partner-card">
        <img src="images/logo2.webp" alt="BlueRock Developers">
        <h5>BlueRock Developers</h5>
        <p>Property Development</p>
      </div>

      <div class="partner-card">
        <img src="images/logo1.webp" alt="Vista Property Group">
        <h5>Vista Property Group</h5>
        <p>Mixed-Use Properties</p>
      </div>

      <div class="partner-card">
        <img src="images/logo3.webp" alt="Elite Living Spaces">
        <h5>Elite Living Spaces</h5>
        <p>Luxury Housing</p>
      </div>

      <!-- DUPLICATE SET (MUST MATCH EXACTLY) -->
      <div class="partner-card">
        <img src="images/logo2.webp" alt="Greenfield Holdings">
        <h5>Greenfield Holdings</h5>
        <p>Residential Property Owners</p>
      </div>

      <div class="partner-card">
        <img src="images/logo1.webp" alt="Urban Crest Ltd">
        <h5>Urban Crest Ltd</h5>
        <p>Commercial Real Estate</p>
      </div>

      <div class="partner-card">
        <img src="images/logo3.webp" alt="PrimeStay Homes">
        <h5>PrimeStay Homes</h5>
        <p>Rental Apartments</p>
      </div>

      <div class="partner-card">
        <img src="images/logo2.webp" alt="BlueRock Developers">
        <h5>BlueRock Developers</h5>
        <p>Property Development</p>
      </div>

      <div class="partner-card">
        <img src="images/logo1.webp" alt="Vista Property Group">
        <h5>Vista Property Group</h5>
        <p>Mixed-Use Properties</p>
      </div>

      <div class="partner-card">
        <img src="images/logo3.webp" alt="Elite Living Spaces">
        <h5>Elite Living Spaces</h5>
        <p>Luxury Housing</p>
      </div>

    </div>
  </div>

</section>
<!-- end our happy partners section -->









<!-- 3 combo column start section -->

<!-- action section -->
<section style="padding: 80px 0; background: linear-gradient(135deg, #f7f9fc, #eef2f7);">

  <style>
    .action-card {
      height: 100%;
      padding: 35px 28px;
      border-radius: 18px;
      background: #ffffff;
      box-shadow: 0 12px 35px rgba(0,0,0,0.1);
      text-align: center;
      transition: all 0.35s ease;
    }

    .action-card:hover {
      transform: translateY(-10px);
      box-shadow: 0 20px 45px rgba(0,0,0,0.18);
    }

    .action-card h4 {
      font-weight: 700;
      margin-bottom: 15px;
    }

    .action-card p {
      color: #444;
      line-height: 1.6;
      margin-bottom: 25px;
    }

    .action-card a {
      display: inline-block;
      padding: 12px 28px;
      background: #2c2c2c;
      color: #ffffff;
      text-decoration: none;
      border-radius: 6px;
      font-weight: 500;
      transition: background 0.3s ease;
    }

    .action-card a:hover {
      background: #000000;
    }
  </style>

 


<!-- 3 column combo end section -->


<!--End of our partners sectuion-->




 <!-- house listings section -->
<section class="sale_section layout_padding-bottom" style="padding:70px 0; background:linear-gradient(135deg,#e9eef5,#f7f9fc);">

  <style>
    .house-grid {
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      gap: 25px;
      margin-top: 40px;
    }

    @media (max-width: 1200px) {
      .house-grid { grid-template-columns: repeat(3, 1fr); }
    }

    @media (max-width: 992px) {
      .house-grid { grid-template-columns: repeat(2, 1fr); }
    }

    @media (max-width: 576px) {
      .house-grid { grid-template-columns: 1fr; }
    }

    .house-card {
      border-radius: 18px;
      overflow: hidden;
      text-decoration: none;
      color: #000;
      background: rgba(255, 255, 255, 0.25);
      backdrop-filter: blur(14px);
      -webkit-backdrop-filter: blur(14px);
      border: 1px solid rgba(255,255,255,0.35);
      box-shadow: 0 8px 32px rgba(31,38,135,0.15);
      transition: all 0.35s ease;
      display: block;
    }

    .house-card:hover {
      transform: translateY(-8px) scale(1.02);
      box-shadow: 0 18px 45px rgba(31,38,135,0.25);
      background: rgba(255,255,255,0.35);
      text-decoration: none;
      color: #000;
    }

    .house-card img {
      width: 100%;
      height: 170px;
      object-fit: cover;
    }

    .house-card-content {
      padding: 15px;
    }

    .house-card-content h6 {
      font-weight: 600;
      margin-bottom: 8px;
    }

    .house-card-content p {
      font-size: 14px;
      margin: 0;
      color: #333;
    }

    .vacant-count {
      display: inline-block;
      margin-top: 8px;
      font-weight: 600;
      font-size: 13px;
      color: #0f2a44;
    }
  </style>

  <div class="container">
    <div class="heading_container text-center">
      <h2>Available Vacant Houses </h2>
      <p>These are houses that are currently vacant and available for rent.</p>
    </div>

    <div class="house-grid">

      <?php if ($vacantHouses && $vacantHouses->num_rows > 0): ?>
        <?php while ($h = $vacantHouses->fetch_assoc()): ?>
          
          <a href="house.php?id=<?= $h['id'] ?>" class="house-card">

            <img src="<?= !empty($h['main_image']) && file_exists($h['main_image']) 
              ? $h['main_image'] 
              : 'images/no-image.png' ?>" alt="">

            <div class="house-card-content">
              <h6><?= htmlspecialchars($h['name']) ?></h6>

              <p>
                📍 <?= htmlspecialchars($h['location']) ?>
              </p>

              <span class="vacant-count">
                <?= (int)$h['vacant_units'] ?> Vacant Unit(s)
              </span>
            </div>

          </a>

        <?php endwhile; ?>
      <?php else: ?>
        <p style="grid-column:1/-1; text-align:center; opacity:0.7;">
          🚫 No vacant houses available at the moment.
        </p>
      <?php endif; ?>

    </div>

    <div class="btn-box" style="margin-top:40px; text-align:center;">
      <a href="house.php">View All Listings</a>
    </div>
  </div>
</section>
<!-- end house listings section -->


  <!-- end sale section -->

<!-- deal section -->
<section class="deal_section layout_padding-bottom">
  <div class="container">
    <div class="row align-items-center">

      <div class="col-md-6">
        <div class="detail-box">
          <div class="heading_container">
            <h2>
              Trusted Real Estate Solutions
            </h2>
          </div>
          <p>
            At Lifeshed Realtors, we simplify property ownership and renting.
            From professional property management to reliable tenant placement,
            we ensure every property is handled with care, transparency, and
            efficiency.
          </p>
          <a href="contact.php">
            Talk to Us Today
          </a>
        </div>
      </div>

      <div class="col-md-6">
        <div class="img-box">
          <div class="box b1">
            <img src="images/d-1.jpg" alt="Lifeshed Realtors Property">
          </div>
          <div class="box b1">
            <img src="images/d-2.jpg" alt="Lifeshed Realtors Management">
          </div>
        </div>
      </div>

    </div>
  </div>
</section>
<!-- end deal section -->


<!-- us section -->
<section class="us_section layout_padding2">
  <div class="container">
    <div class="heading_container">
      <h2>
        Why Choose Lifeshed Realtors
      </h2>
    </div>

    <div class="row">

      <div class="col-md-3 col-sm-6">
        <div class="box">
          <div class="img-box">
            <img src="images/u-1.png" alt="Professional Management">
          </div>
          <div class="detail-box">
            <h5>
              Professional Property Management
            </h5>
            <p>
              We manage properties with transparency, accountability, and
              attention to detail to protect your investment.
            </p>
          </div>
        </div>
      </div>

      <div class="col-md-3 col-sm-6">
        <div class="box">
          <div class="img-box">
            <img src="images/u-2.png" alt="Reliable Tenants">
          </div>
          <div class="detail-box">
            <h5>
              Reliable Tenant Placement
            </h5>
            <p>
              We carefully screen tenants to ensure timely rent payments
              and peaceful occupancy.
            </p>
          </div>
        </div>
      </div>

      <div class="col-md-3 col-sm-6">
        <div class="box">
          <div class="img-box">
            <img src="images/u-3.png" alt="Clear Communication">
          </div>
          <div class="detail-box">
            <h5>
              Clear Communication
            </h5>
            <p>
              Landlords and tenants stay informed through timely updates,
              reports, and support.
            </p>
          </div>
        </div>
      </div>

      <div class="col-md-3 col-sm-6">
        <div class="box">
          <div class="img-box">
            <img src="images/u-4.png" alt="Local Expertise">
          </div>
          <div class="detail-box">
            <h5>
              Local Market Expertise
            </h5>
            <p>
              Our deep understanding of the local real estate market helps
              maximize returns and reduce vacancies.
            </p>
          </div>
        </div>
      </div>

    </div>

    <div class="btn-box">
      <a href="contact.php">
        Talk to Lifeshed Realtors
      </a>
    </div>
  </div>
</section>
<!-- end us section -->

<!-- client section -->
<section class="client_section layout_padding">
  <div class="container-fluid">
    <div class="heading_container">
      <h2>
        What Our Clients Say
      </h2>
    </div>

    <div class="client_container">
      <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
        <div class="carousel-inner">

          <div class="carousel-item active">
            <div class="box">
              <div class="img-box">
                <img src="images/man.avif" alt="Lifeshed Client">
              </div>
              <div class="detail-box">
                <h5>
                  <span>Landlord</span>
                  <hr>
                </h5>
                <p>
                  Lifeshed Realtors has taken away the stress of managing my property.
                  Rent collection is timely, communication is clear, and my units
                  are well maintained.
                </p>
              </div>
            </div>
          </div>

          <div class="carousel-item">
            <div class="box">
              <div class="img-box">
                <img src="images/man.avif" alt="Lifeshed Tenant">
              </div>
              <div class="detail-box">
                <h5>
                  <span>Tenant</span>
                  <hr>
                </h5>
                <p>
                  The Lifeshed team is professional and responsive.
                  Any issues are handled quickly, and the rental process
                  was smooth and transparent.
                </p>
              </div>
            </div>
          </div>

          <div class="carousel-item">
            <div class="box">
              <div class="img-box">
                <img src="images/man.avif" alt="Property Owner">
              </div>
              <div class="detail-box">
                <h5>
                  <span>Property Owner</span>
                  <hr>
                </h5>
                <p>
                  I appreciate their honesty and market knowledge.
                  Lifeshed Realtors helped reduce vacancies and improved
                  the overall value of my investment.
                </p>
              </div>
            </div>
          </div>

        </div>

        <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
          <span class="sr-only">Previous</span>
        </a>
        <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
          <span class="sr-only">Next</span>
        </a>
      </div>
    </div>
  </div>
</section>
<!-- end client section -->

  <!-- end client section -->


            <a href="#"><img src="images/fb.png" alt=""></a>
            <a href="#"><img src="images/twitter.png" alt=""></a>
            <a href="#"><img src="images/linkedin.png" alt=""></a>
            <a href="#"><img src="images/youtube.png" alt=""></a>
          </div>
        </div>
      </div>


<!-- info section -->
<section class="info_section" style="background:#0f2a44; color:#ffffff;">
  <div class="container">
    <div class="row">

      <div class="col-md-3">
        <div class="info_contact">
          <h5 style="color:#ffffff;">
            Lifeshed Realtors
          </h5>

          <div style="display:flex; align-items:center; margin-bottom:8px;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/location.png" width="18px" alt="">
            </div>
            <p style="margin:0;">
              Highlands Mall, Eldoret (G7C8+94P)
            </p>
          </div>

          <div style="display:flex; align-items:center; margin-bottom:8px;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/phone.png" width="12px" alt="">
            </div>
            <p style="margin:0;">
              0725 608 170
            </p>
          </div>

          <div style="display:flex; align-items:center;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/mail.png" width="18px" alt="">
            </div>
            <p style="margin:0;">
              info@lifeshedrealtors.co.ke
            </p>
          </div>
        </div>
      </div>

      <div class="col-md-3">
        <div class="info_info">
          <h5 style="color:#ffffff;">
            About Us
          </h5>
          <p>
            Lifeshed Realtors offers professional property management,
            estate agency, and real estate consultancy services focused
            on value, trust, and long-term partnerships.
          </p>
        </div>
      </div>

      <div class="col-md-3">
        <div class="info_links">
          <h5 style="color:#ffffff;">
            Quick Links
          </h5>
          <ul>
            <li><a href="index.php" style="color:#ffffff;">Home</a></li>
            <li><a href="about.html" style="color:#ffffff;">About Us</a></li>
            <li><a href="house.php" style="color:#ffffff;">House Listings</a></li>
            <li><a href="contact.php" style="color:#ffffff;">Contact Us</a></li>
          </ul>
        </div>
      </div>

<div class="col-md-3">
  <div class="info_form">
    <h5 style="color:#ffffff;">
      Stay Connected
    </h5>

    <form action="admin_dashboard.php" method="get">
      <button style="margin-top:10px; width:100%; padding:10px; font-weight:600;">
        🔐 Log IN
      </button>
    </form>

  </div>
</div>


          <div class="social_box" style="margin-top:15px;">


    </div>
  </div>
</section>
<!-- end info section -->
  <!-- end info_section -->


  <!-- footer section -->
  <section class="container-fluid footer_section ">
    <div class="container">
      <p>
        &copy; <span id="displayYear"></span> All Rights Reserved By
        <a href="https://html.design/">Lifeshed Realtors </a>
      </p>
    </div>
  </section>
  <!-- end  footer section -->


  <script type="text/javascript" src="js/jquery-3.4.1.min.js"></script>
  <script type="text/javascript" src="js/bootstrap.js"></script>
  <script type="text/javascript" src="js/custom.js"></script>
	<!-- Landlord Management Modal -->
<div id="landlordModal" style="
  display:none;
  position:fixed;
  inset:0;
  background:rgba(0,0,0,0.5);
  align-items:center;
  justify-content:center;
  z-index:9999;
">
  <div style="
    background:#fff;
    padding:20px;
    width:100%;
    max-width:420px;
    border-radius:12px;
    animation:pop .2s ease;
  ">
    <h3 style="margin-top:0;color:#0f2a44;">Property Management Request</h3>

    <input id="lm_name" placeholder="Full Name"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <input id="lm_phone" placeholder="Phone Number"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <input id="lm_property" placeholder="Property Name"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <input id="lm_location" placeholder="Property Location"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <textarea id="lm_desc" placeholder="Describe the management you need"
      style="width:100%;padding:10px;height:90px;margin-bottom:15px;"></textarea>

    <div style="display:flex;justify-content:space-between;">
      <button onclick="closeLandlordModal()">Cancel</button>
      <button onclick="submitLandlordRequest()"
        style="background:#0f2a44;color:#fff;border:none;padding:8px 18px;border-radius:6px;">
        Submit
      </button>
    </div>
  </div>
</div>



<!-- Add User Modal -->
<div id="addUserModal" style="
  display:none;
  position:fixed;
  inset:0;
  background:rgba(0,0,0,0.5);
  align-items:center;
  justify-content:center;
  z-index:9999;
">
  <div style="
    background:#fff;
    padding:20px;
    width:100%;
    max-width:400px;
    border-radius:12px;
    animation:pop .2s ease;
  ">
    <h3 style="margin-top:0;color:#0f2a44;">Add User</h3>

    <input id="au_username" placeholder="Username" style="width:100%;padding:10px;margin-bottom:10px;">
    <input id="au_password" type="password" placeholder="Password" style="width:100%;padding:10px;margin-bottom:10px;">

    <select id="au_role" style="width:100%;padding:10px;margin-bottom:15px;">
      <option value="">Select role</option>
      <option value="admin">Admin</option>
      <option value="landlord">Landlord</option>
      <option value="user">User</option>
    </select>

    <div style="display:flex;justify-content:space-between;">
      <button onclick="closeAddUserModal()" style="padding:8px 14px;">Cancel</button>
      <button onclick="submitAddUser()" style="
        padding:8px 14px;
        background:#0f2a44;
        color:#fff;
        border:none;
        border-radius:6px;
      ">Save</button>
    </div>
  </div>
</div>




</body>
<script>
/* ---------- ADD USER MODAL ---------- */
function openAddUserModal(){
  document.getElementById('addUserModal').style.display = 'flex';
}

function closeAddUserModal(){
  document.getElementById('addUserModal').style.display = 'none';

  document.getElementById('au_username').value = '';
  document.getElementById('au_password').value = '';
  document.getElementById('au_role').value     = '';
}

/* ---------- SUBMIT ADD USER (AJAX) ---------- */
function submitAddUser(){

  const username = document.getElementById('au_username').value.trim();
  const password = document.getElementById('au_password').value;
  const role     = document.getElementById('au_role').value;

  if (!username || !password || !role) {
    alert('All fields are required');
    return;
  }

  fetch('add_user.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `username=${encodeURIComponent(username)}&password=${encodeURIComponent(password)}&role=${encodeURIComponent(role)}`
  })
  .then(r => r.text())
  .then(r => {
    if (r === 'success') {

      closeAddUserModal();

      // 🔄 Reload users dynamically (NO PAGE REFRESH)
      if (typeof loadPage === 'function') {
        loadPage('users.php', 'User Management');
      }

    } else {
      alert(r);
    }
  })
  .catch(() => alert('Network error'));

}






/* ---------- LANDLORD MODAL ---------- */
function openLandlordModal(){
  document.getElementById('landlordModal').style.display = 'flex';
}

function closeLandlordModal(){
  document.getElementById('landlordModal').style.display = 'none';

  document.getElementById('lm_name').value = '';
  document.getElementById('lm_phone').value = '';
  document.getElementById('lm_property').value = '';
  document.getElementById('lm_location').value = '';
  document.getElementById('lm_desc').value = '';
}

function submitLandlordRequest(){

  const data = {
    name: lm_name.value.trim(),
    phone: lm_phone.value.trim(),
    property_name: lm_property.value.trim(),
    location: lm_location.value.trim(),
    description: lm_desc.value.trim()
  };

  if (Object.values(data).some(v => !v)) {
    alert('All fields are required');
    return;
  }

  fetch('save_landlord_request.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: new URLSearchParams(data).toString()
  })
  .then(r => r.text())
  .then(r => {
    if (r === 'success') {
      alert('Request sent successfully');
      closeLandlordModal();
    } else {
      alert(r);
    }
  })
  .catch(() => alert('Network error'));
}




</script>


</html>