<?php
require_once "db.php";

$booking_success = false;

/* HANDLE BOOKING SUBMISSION */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['book_house'])) {
  $stmt = $conn->prepare("
    INSERT INTO house_bookings
    (property_id, full_name, house_details, how_soon, phone, preferred_location)
    VALUES (?,?,?,?,?,?)
  ");
  $stmt->bind_param(
    "isssss",
    $_POST['property_id'],
    $_POST['full_name'],
    $_POST['house_details'],
    $_POST['how_soon'],
    $_POST['phone'],
    $_POST['preferred_location']
  );
  $stmt->execute();
  $stmt->close();

  $booking_success = true;
}

/* FETCH ONLY PROPERTIES WITH VACANT UNITS */
$sql = "
  SELECT 
    p.id,
    p.name,
    p.location,
    p.description,
    p.main_image,
    (
      SELECT COALESCE(SUM(u.vacant_count),0)
      FROM property_units u
      WHERE u.property_id = p.id
    ) AS vacant_units
  FROM properties p
  HAVING vacant_units > 0
  ORDER BY p.created_at DESC
";

$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Available Houses</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="css/bootstrap.css">
<link href="https://fonts.googleapis.com/css?family=Poppins:400,600,700&display=swap" rel="stylesheet">
<link href="css/style.css" rel="stylesheet">
<link href="css/responsive.css" rel="stylesheet">

<style>
body{
  background:#ffffff;
  color:#1f2937;
  font-family:'Poppins',sans-serif;
}

.house-grid{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(280px,1fr));
  gap:24px;
  margin-top:40px;
}

.house-card{
  background:#ffffff;
  border-radius:18px;
  overflow:hidden;
  border:1px solid rgba(0,0,0,0.08);
  box-shadow:0 10px 28px rgba(0,0,0,0.12);
  transition:.25s ease;
}

.house-card:hover{ transform:translateY(-5px); }

.house-img{
  width:100%;
  height:200px;
  object-fit:cover;
}

.house-body{ padding:18px; }

.house-title{
  font-size:18px;
  font-weight:700;
  color:#0f2a44;
  margin-bottom:6px;
}

.house-location{
  font-size:14px;
  color:#374151;
  margin-bottom:8px;
}

.house-desc{
  font-size:14px;
  color:#4b5563;
  line-height:1.5;
  margin-bottom:12px;
}

.vacancy-badge{
  display:inline-block;
  background:#28a745;
  color:#ffffff;
  padding:4px 12px;
  border-radius:20px;
  font-size:13px;
  font-weight:600;
  margin-bottom:10px;
}

.book-btn{ width:100%; }
</style>
</head>

<body class="sub_page">

<!-- NAVBAR -->
<div class="hero_area">
  <header class="header_section">
    <div class="container-fluid">
      <nav class="navbar navbar-expand-lg custom_nav-container">
        <a class="navbar-brand" href="index.php">
          <img src="images/logo.png" alt="Lifeshed Realtors">
        </a>
      </nav>
    </div>
  </header>
</div>

<!-- AVAILABLE HOUSES -->
<section class="sale_section layout_padding">
<div class="container-fluid">

<div class="heading_container">
  <h2>Available Houses</h2>
  <p>Only properties with vacant units are listed below</p>
</div>

<div class="house-grid">

<?php if($result && $result->num_rows): while($p=$result->fetch_assoc()): ?>

<div class="house-card">
  <img src="<?= !empty($p['main_image']) && file_exists($p['main_image']) ? $p['main_image'] : 'assets/no-image.png' ?>" class="house-img">

  <div class="house-body">
    <span class="vacancy-badge"><?= (int)$p['vacant_units'] ?> Vacant</span>

    <div class="house-title"><?= htmlspecialchars($p['name']) ?></div>
    <div class="house-location">📍 <?= htmlspecialchars($p['location']) ?></div>
    <div class="house-desc"><?= nl2br(htmlspecialchars($p['description'])) ?></div>

    <button class="btn btn-primary book-btn" data-toggle="modal" data-target="#bookModal<?= $p['id'] ?>">
      Book Now
    </button>
  </div>
</div>

<!-- BOOK MODAL -->
<div class="modal fade" id="bookModal<?= $p['id'] ?>">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">
<form method="post">

<div class="modal-header">
  <h5 class="modal-title">Book <?= htmlspecialchars($p['name']) ?></h5>
  <button type="button" class="close" data-dismiss="modal">&times;</button>
</div>

<div class="modal-body">
<input type="hidden" name="property_id" value="<?= $p['id'] ?>">

<div class="form-group">
<label>Full Name</label>
<input type="text" name="full_name" class="form-control" required>
</div>

<div class="form-group">
<label>Which type of house are you looking for?</label>
<input type="text" name="house_details" class="form-control">
</div>

<div class="form-group">
<label>How Soon?</label>
<select name="how_soon" class="form-control">
<option>Immediately</option>
<option>Within a week</option>
<option>Within a month</option>
</select>
</div>

<div class="form-group">
<label>Phone Number</label>
<input type="text" name="phone" class="form-control" required>
</div>

<div class="form-group">
<label>Preferred Location</label>
<input type="text" name="preferred_location" class="form-control">
</div>
</div>

<div class="modal-footer">
<button type="submit" name="book_house" class="btn btn-success">
Submit Booking
</button>
</div>

</form>
</div>
</div>
</div>

<?php endwhile; else: ?>
<p style="font-size:18px;color:#6b7280;">🚫 No vacant houses available at the moment.</p>
<?php endif; ?>

</div>
</div>
</section>

<!-- SUCCESS MODAL -->
<?php if($booking_success): ?>
<div class="modal fade show" id="successModal" style="display:block;background:rgba(0,0,0,.6);">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content text-center">
      <div class="modal-body" style="padding:30px;">
        <h4>🏠✅ House Booked Successfully!</h4>
        <p style="margin-top:10px;">
          You will be contacted by the admin!
        </p>
        <button class="btn btn-primary" onclick="window.location='house.php'">
          OK
        </button>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>

<section class="info_section" style="background:#0f2a44; color:#ffffff;">
  <div class="container">
    <div class="row">

      <div class="col-md-3">
        <div class="info_contact">
          <h5 style="color:#ffffff;">
            Lifeshed Realtors
          </h5>

          <div style="display:flex; align-items:center; margin-bottom:8px;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/location.png" width="18px" alt="">
            </div>
            <p style="margin:0;">
              Highlands Mall, Eldoret (G7C8+94P)
            </p>
          </div>

          <div style="display:flex; align-items:center; margin-bottom:8px;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/phone.png" width="12px" alt="">
            </div>
            <p style="margin:0;">
              0725 608 170
            </p>
          </div>

          <div style="display:flex; align-items:center;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/mail.png" width="18px" alt="">
            </div>
            <p style="margin:0;">
              info@lifeshedrealtors.co.ke
            </p>
          </div>
        </div>
      </div>

      <div class="col-md-3">
        <div class="info_info">
          <h5 style="color:#ffffff;">
            About Us
          </h5>
          <p>
            Lifeshed Realtors offers professional property management,
            estate agency, and real estate consultancy services focused
            on value, trust, and long-term partnerships.
          </p>
        </div>
      </div>

      <div class="col-md-3">
        <div class="info_links">
          <h5 style="color:#ffffff;">
            Quick Links
          </h5>
          <ul>
            <li><a href="index.php" style="color:#ffffff;">Home</a></li>
            <li><a href="about.html" style="color:#ffffff;">About Us</a></li>
            <li><a href="house.php" style="color:#ffffff;">House Listings</a></li>
            <li><a href="contact.php" style="color:#ffffff;">Contact Us</a></li>
          </ul>
        </div>
      </div>

<div class="col-md-3">
  <div class="info_form">
    <h5 style="color:#ffffff;">
      Stay Connected
    </h5>

    <form action="admin_dashboard.php" method="get">
      <button style="margin-top:10px; width:100%; padding:10px; font-weight:600;">
        🔐 Log IN
      </button>
    </form>

  </div>
</div>


          <div class="social_box" style="margin-top:15px;">


    </div>
  </div>
</section>
<!-- end info section -->
  <!-- end info_section -->


  <!-- footer section -->
  <section class="container-fluid footer_section ">
    <div class="container">
      <p>
        &copy; <span id="displayYear"></span> All Rights Reserved By
        <a href="https://html.design/">Lifeshed Realtors </a>
      </p>
    </div>
  </section>
  <!-- end  footer section -->


  <script type="text/javascript" src="js/jquery-3.4.1.min.js"></script>
  <script type="text/javascript" src="js/bootstrap.js"></script>
  <script type="text/javascript" src="js/custom.js"></script>
	<!-- Landlord Management Modal -->
<div id="landlordModal" style="
  display:none;
  position:fixed;
  inset:0;
  background:rgba(0,0,0,0.5);
  align-items:center;
  justify-content:center;
  z-index:9999;
">
  <div style="
    background:#fff;
    padding:20px;
    width:100%;
    max-width:420px;
    border-radius:12px;
    animation:pop .2s ease;
  ">
    <h3 style="margin-top:0;color:#0f2a44;">Property Management Request</h3>

    <input id="lm_name" placeholder="Full Name"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <input id="lm_phone" placeholder="Phone Number"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <input id="lm_property" placeholder="Property Name"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <input id="lm_location" placeholder="Property Location"
      style="width:100%;padding:10px;margin-bottom:10px;">

    <textarea id="lm_desc" placeholder="Describe the management you need"
      style="width:100%;padding:10px;height:90px;margin-bottom:15px;"></textarea>

    <div style="display:flex;justify-content:space-between;">
      <button onclick="closeLandlordModal()">Cancel</button>
      <button onclick="submitLandlordRequest()"
        style="background:#0f2a44;color:#fff;border:none;padding:8px 18px;border-radius:6px;">
        Submit
      </button>
    </div>
  </div>
</div>


<script src="js/jquery-3.4.1.min.js"></script>
<script src="js/bootstrap.js"></script>

</body>
</html>
