<?php
require_once "db.php";

if (!isset($_SESSION['user_id'])) {
  exit;
}

/* TOTAL UNITS & VACANT */
$units = $conn->query("
  SELECT 
    COALESCE(SUM(units_count),0) AS total_units,
    COALESCE(SUM(vacant_count),0) AS vacant
  FROM property_units
")->fetch_assoc();

/* UNREAD MESSAGES */
$msg = $conn->query("
  SELECT COUNT(*) AS unread 
  FROM messages 
  WHERE status = 'new'
")->fetch_assoc();

echo json_encode([
  "total_units" => (int)$units['total_units'],
  "vacant" => (int)$units['vacant'],
  "unread_messages" => (int)$msg['unread']
]);
