<?php
// KEEP DB INCLUDED (needed later / consistency)
require_once "db.php";
?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

  <title>Contact Us | Lifeshed Realtors</title>

  <link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
  <link href="https://fonts.googleapis.com/css?family=Poppins:400,700|Raleway:400,700&display=swap" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet" />
  <link href="css/responsive.css" rel="stylesheet" />

  <!-- GLASS MORPHISM STYLES -->
  <style>
    .glass-form {
      background: rgba(255, 255, 255, 0.15);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      border-radius: 16px;
      padding: 30px;
      box-shadow: 0 8px 32px rgba(0, 0, 0, 0.25);
      border: 1px solid rgba(255, 255, 255, 0.3);
    }

    .glass-form input,
    .glass-form textarea,
    .glass-form select {
      width: 100%;
      padding: 12px;
      margin-bottom: 15px;
      border-radius: 8px;
      border: none;
      outline: none;
      background: rgba(255, 255, 255, 0.85);
    }

    .glass-form button {
      background: #0f2a44;
      color: #fff;
      border: none;
      padding: 12px 25px;
      border-radius: 30px;
      cursor: pointer;
      transition: 0.3s ease;
    }

    .glass-form button:hover {
      background: #143c63;
    }

    .alert-box {
      display: none;
      margin-bottom: 15px;
      padding: 12px;
      border-radius: 8px;
      font-weight: 500;
    }

    .alert-success {
      background: #e6ffed;
      color: #155724;
    }

    .alert-error {
      background: #ffe5e5;
      color: #b30000;
    }
  </style>
</head>

<body class="sub_page">

<!-- HEADER (UNCHANGED) -->
<div class="hero_area">
  <header class="header_section">
    <div class="container-fluid">
      <nav class="navbar navbar-expand-lg custom_nav-container">
        <a class="navbar-brand" href="index.php">
          <img src="images/logo.png" alt="Lifeshed Realtors" />
        </a>
        <div class="navbar-collapse">
          <div class="custom_menu-btn">
            <button onclick="openNav()">
              <span class="s-1"></span>
              <span class="s-2"></span>
              <span class="s-3"></span>
            </button>
          </div>
          <div id="myNav" class="overlay">
            <div class="overlay-content">
              <a href="index.php">HOME</a>
              <a href="about.html">ABOUT US</a>
              <a href="house.html">HOUSE LISTINGS</a>
              <a href="contact.php">CONTACT</a>
            </div>
          </div>
        </div>
      </nav>
    </div>
  </header>
</div>

<!-- CONTACT SECTION -->
<section class="contact_section layout_padding-top">
  <div class="container">
    <div class="heading_container">
      <h2>Get In Touch With Us</h2>
      <p style="margin-top:10px;">
        We’re here to help you with property management, rentals, and real estate consultancy.
      </p>
    </div>
  </div>

  <div class="container-fluid">
    <div class="row">

      <!-- MAP -->
      <div class="col-md-6 px-0">
        <div class="map_container">
          <div class="map-responsive">
            <iframe
              src="https://www.google.com/maps?q=G7C8+94P,+Highlands+Mall,+Eldoret&output=embed"
              frameborder="0"
              style="border:0; width:100%; height:100%;"
              allowfullscreen>
            </iframe>
          </div>
        </div>
      </div>

      <!-- FORM -->
      <div class="col-lg-4 col-md-5">
        <div class="form_container glass-form">

          <div id="alertSuccess" class="alert-box alert-success"></div>
          <div id="alertError" class="alert-box alert-error"></div>

          <form id="contactForm">

            <input type="text" name="name" placeholder="Full Name" required>

            <input type="text" name="phone" placeholder="Phone Number" required>

            <input type="email" name="email" placeholder="Email Address (optional)">

            <select name="type" required>
              <option value="">Message Type</option>
              <option value="general">General Inquiry</option>
              <option value="complaint">Complaint</option>
            </select>

            <input type="text" name="subject" placeholder="Subject" required>

            <textarea name="message" class="message-box" placeholder="Your Message" required></textarea>

            <div class="d-flex">
              <button type="submit">Send Message</button>
            </div>

          </form>
        </div>
      </div>

    </div>
  </div>
</section>

<!-- FOOTER & SCRIPTS (UNCHANGED) -->
<script src="js/jquery-3.4.1.min.js"></script>
<script src="js/bootstrap.js"></script>
<script src="js/custom.js"></script>

<!-- info section -->
<section class="info_section" style="background:#0f2a44; color:#ffffff;">
  <div class="container">
    <div class="row">

      <div class="col-md-3">
        <div class="info_contact">
          <h5 style="color:#ffffff;">
            Lifeshed Realtors
          </h5>

          <div style="display:flex; align-items:center; margin-bottom:8px;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/location.png" width="18px" alt="">
            </div>
            <p style="margin:0;">
              Highlands Mall, Eldoret (G7C8+94P)
            </p>
          </div>

          <div style="display:flex; align-items:center; margin-bottom:8px;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/phone.png" width="12px" alt="">
            </div>
            <p style="margin:0;">
              0725 608 170
            </p>
          </div>

          <div style="display:flex; align-items:center;">
            <div class="img-box" style="margin-right:10px;">
              <img src="images/mail.png" width="18px" alt="">
            </div>
            <p style="margin:0;">
              info@lifeshedrealtors.co.ke
            </p>
          </div>
        </div>
      </div>

      <div class="col-md-3">
        <div class="info_info">
          <h5 style="color:#ffffff;">
            About Us
          </h5>
          <p>
            Lifeshed Realtors offers professional property management,
            estate agency, and real estate consultancy services focused
            on value, trust, and long-term partnerships.
          </p>
        </div>
      </div>

      <div class="col-md-3">
        <div class="info_links">
          <h5 style="color:#ffffff;">
            Quick Links
          </h5>
          <ul>
            <li><a href="index.php" style="color:#ffffff;">Home</a></li>
            <li><a href="about.html" style="color:#ffffff;">About Us</a></li>
            <li><a href="property.html" style="color:#ffffff;">House Listings</a></li>
            <li><a href="contact.php" style="color:#ffffff;">Contact Us</a></li>
            <li><a href="services.html" style="color:#ffffff;">Our Services</a></li>
          </ul>
        </div>
      </div>

<div class="col-md-3">
  <div class="info_form">
    <h5 style="color:#ffffff;">
      Stay Connected
    </h5>

    <form action="admin_dashboard.php" method="get">
      <button style="margin-top:10px; width:100%; padding:10px; font-weight:600;">
        🔐 Log IN
      </button>
    </form>

  </div>
</div>


          <div class="social_box" style="margin-top:15px;">
            <a href="#"><img src="images/fb.png" alt=""></a>
            <a href="#"><img src="images/twitter.png" alt=""></a>
            <a href="#"><img src="images/linkedin.png" alt=""></a>
            <a href="#"><img src="images/youtube.png" alt=""></a>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>
<!-- end info section -->
  <!-- end info_section -->


  <!-- footer section -->
  <section class="container-fluid footer_section ">
    <div class="container">
      <p>
        &copy; <span id="displayYear"></span> All Rights Reserved By
        <a href="https://html.design/">Lifeshed Realtors </a>
      </p>
    </div>
  </section>
  <!-- end  footer section -->


  <script type="text/javascript" src="js/jquery-3.4.1.min.js"></script>
  <script type="text/javascript" src="js/bootstrap.js"></script>
  <script type="text/javascript" src="js/custom.js"></script>


<!-- Add User Modal -->
<div id="addUserModal" style="
  display:none;
  position:fixed;
  inset:0;
  background:rgba(0,0,0,0.5);
  align-items:center;
  justify-content:center;
  z-index:9999;
">
  <div style="
    background:#fff;
    padding:20px;
    width:100%;
    max-width:400px;
    border-radius:12px;
    animation:pop .2s ease;
  ">
    <h3 style="margin-top:0;color:#0f2a44;">Add User</h3>

    <input id="au_username" placeholder="Username" style="width:100%;padding:10px;margin-bottom:10px;">
    <input id="au_password" type="password" placeholder="Password" style="width:100%;padding:10px;margin-bottom:10px;">

    <select id="au_role" style="width:100%;padding:10px;margin-bottom:15px;">
      <option value="">Select role</option>
      <option value="admin">Admin</option>
      <option value="landlord">Landlord</option>
      <option value="user">User</option>
    </select>

    <div style="display:flex;justify-content:space-between;">
      <button onclick="closeAddUserModal()" style="padding:8px 14px;">Cancel</button>
      <button onclick="submitAddUser()" style="
        padding:8px 14px;
        background:#0f2a44;
        color:#fff;
        border:none;
        border-radius:6px;
      ">Save</button>
    </div>
  </div>
</div>



<!-- AJAX SUBMIT -->
<script>
document.getElementById('contactForm').addEventListener('submit', function(e) {
  e.preventDefault();

  const formData = new FormData(this);

  fetch('send_message.php', {
    method: 'POST',
    body: formData
  })
  .then(res => res.text())
  .then(res => {
    const successBox = document.getElementById('alertSuccess');
    const errorBox   = document.getElementById('alertError');

    successBox.style.display = 'none';
    errorBox.style.display   = 'none';

    if (res.trim() === 'success') {
      successBox.textContent = 'Your message has been sent successfully.';
      successBox.style.display = 'block';
      document.getElementById('contactForm').reset();
    } else {
      errorBox.textContent = res;
      errorBox.style.display = 'block';
    }
  })
  .catch(() => {
    document.getElementById('alertError').textContent = 'Network error. Please try again.';
    document.getElementById('alertError').style.display = 'block';
  });
});
</script>

</body>
</html>
