<?php
require_once "db.php";

/* SECURITY */
if (!isset($_SESSION['user_id'])) {
  exit("Unauthorized");
}

/* DELETE BOOKING (AJAX) */
if (isset($_POST['delete_booking_id'])) {
  $id = (int)$_POST['delete_booking_id'];
  $stmt = $conn->prepare("DELETE FROM house_bookings WHERE id = ?");
  $stmt->bind_param("i", $id);
  echo $stmt->execute() ? "success" : "error";
  exit;
}

/* FETCH BOOKINGS */
$sql = "
  SELECT 
    hb.*,
    p.name AS property_name
  FROM house_bookings hb
  LEFT JOIN properties p ON p.id = hb.property_id
  ORDER BY hb.created_at DESC
";
$result = $conn->query($sql);
?>

<style>
/* MODAL */
.modal {
  display:none;
  position:fixed;
  inset:0;
  background:rgba(0,0,0,0.5);
  align-items:center;
  justify-content:center;
  z-index:1000;
}
.modal-content {
  background:#fff;
  width:500px;
  max-width:95%;
  border-radius:10px;
  padding:20px;
}
.modal h4 { margin-bottom:15px; }
.modal p { margin:6px 0; }
.close-btn {
  float:right;
  cursor:pointer;
  font-size:18px;
  color:#ef4444;
}

/* BUTTONS */
.btn {
  padding:6px 10px;
  border-radius:6px;
  border:none;
  cursor:pointer;
  font-size:13px;
}
.btn-view { background:#2563eb; color:#fff; }
.btn-delete { background:#dc2626; color:#fff; }
</style>

<div class="card">
  <h3 style="margin-bottom:20px;">🏠 House Bookings</h3>

<?php if($result && $result->num_rows): ?>
<div style="overflow-x:auto;">
<table style="width:100%;border-collapse:collapse;">
  <thead>
    <tr style="background:#f1f5f9;">
      <th style="padding:10px;">Property</th>
      <th>Name</th>
      <th>Phone</th>
      <th>House Type</th>
      <th>Date</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
<?php while($b=$result->fetch_assoc()): ?>
<tr id="row<?= $b['id'] ?>" style="border-bottom:1px solid #e5e7eb;">
  <td style="padding:10px;"><?= htmlspecialchars($b['property_name'] ?? '—') ?></td>
  <td><?= htmlspecialchars($b['full_name']) ?></td>
  <td><?= htmlspecialchars($b['phone']) ?></td>
  <td><?= htmlspecialchars($b['house_details']) ?></td>
  <td><?= date('d M Y', strtotime($b['created_at'])) ?></td>
  <td>
    <button class="btn btn-view"
      onclick='openModal(<?= json_encode($b) ?>)'>View</button>
    <button class="btn btn-delete"
      onclick="deleteBooking(<?= $b['id'] ?>)">Delete</button>
  </td>
</tr>
<?php endwhile; ?>
  </tbody>
</table>
</div>
<?php else: ?>
<p style="color:#6b7280;">No bookings yet.</p>
<?php endif; ?>
</div>

<!-- MODAL -->
<div class="modal" id="bookingModal">
  <div class="modal-content">
    <span class="close-btn" onclick="closeModal()">✖</span>
    <h4>Booking Details</h4>
    <div id="modalBody"></div>
  </div>
</div>

<script>
function openModal(data) {
  let html = `
    <p><b>Property:</b> ${data.property_name ?? '—'}</p>
    <p><b>Full Name:</b> ${data.full_name}</p>
    <p><b>Phone:</b> ${data.phone}</p>
    <p><b>House Type:</b> ${data.house_details}</p>
    <p><b>How Soon:</b> ${data.how_soon}</p>
    <p><b>Preferred Location:</b> ${data.preferred_location}</p>
    <p><b>Date:</b> ${data.created_at}</p>
  `;
  document.getElementById('modalBody').innerHTML = html;
  document.getElementById('bookingModal').style.display = 'flex';
}

function closeModal() {
  document.getElementById('bookingModal').style.display = 'none';
}

function deleteBooking(id) {
  if (!confirm("Delete this booking?")) return;

  let fd = new FormData();
  fd.append("delete_booking_id", id);

  fetch("bookings.php", {
    method:"POST",
    body:fd
  })
  .then(res => res.text())
  .then(r => {
    if (r.trim() === "success") {
      document.getElementById("row"+id).remove();
    } else {
      alert("Failed to delete booking");
    }
  });
}
</script>
