<?php
require_once "db.php";

/* Access control */
if (!isset($_SESSION['user_id'])) {
    exit("Unauthorized");
}

/* Fetch bookings */
$result = $conn->query("
    SELECT 
        b.id,
        b.full_name,
        b.phone,
        b.created_at,
        IFNULL(b.status, 'new') AS status,
        p.name AS property_name
    FROM house_bookings b
    LEFT JOIN properties p ON p.id = b.property_id
    ORDER BY b.created_at DESC
");
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>House Bookings</title>
<link rel="stylesheet" href="css/bootstrap.css">

<style>
.booking-row {
  cursor:pointer;
}
.booking-row.unread {
  font-weight:700;
}
</style>
</head>

<body>

<div class="container mt-5">
  <h3>🏠 House Bookings</h3>

  <table class="table table-hover mt-3">
    <thead>
      <tr>
        <th>Client</th>
        <th>Property</th>
        <th>Phone</th>
        <th>Date</th>
        <th width="120">Action</th>
      </tr>
    </thead>
    <tbody>

<?php if($result && $result->num_rows): while($b = $result->fetch_assoc()): ?>
<tr class="booking-row <?= $b['status']==='new' ? 'unread' : '' ?>"
    onclick="viewBooking(<?= $b['id'] ?>)">
  <td><?= htmlspecialchars($b['full_name']) ?></td>
  <td><?= htmlspecialchars($b['property_name']) ?></td>
  <td><?= htmlspecialchars($b['phone']) ?></td>
  <td><?= date('M j, Y g:i a', strtotime($b['created_at'])) ?></td>
  <td>
    <button class="btn btn-sm btn-danger"
      onclick="event.stopPropagation(); deleteBooking(<?= $b['id'] ?>)">
      Delete
    </button>
  </td>
</tr>
<?php endwhile; else: ?>
<tr>
  <td colspan="5">No bookings found</td>
</tr>
<?php endif; ?>

    </tbody>
  </table>
</div>

<!-- MODAL CONTAINER -->
<div id="bookingModal"></div>

<script>
function viewBooking(id){
  fetch('booking_view.php?id='+id)
  .then(res=>res.text())
  .then(html=>{
    document.getElementById('bookingModal').innerHTML = html;
  });
}

function closeBooking(){
  document.getElementById('bookingModal').innerHTML = '';
  location.reload(); // keeps list updated (read/bold status)
}

function deleteBooking(id){
  if(!confirm('Delete this booking?')) return;

  fetch('booking_delete.php',{
    method:'POST',
    headers:{'Content-Type':'application/x-www-form-urlencoded'},
    body:'id='+id
  })
  .then(res=>res.text())
  .then(res=>{
    if(res==='success') location.reload();
    else alert(res);
  });
}
</script>

</body>
</html>
