<?php
require_once "db.php";

/* ===============================
   SESSION / ACCESS CONTROL
================================ */
if (
    !isset($_SESSION['user_id']) ||
    !isset($_SESSION['login_time']) ||
    (time() - $_SESSION['login_time']) > 86400
) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Lifeshed Admin Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://fonts.googleapis.com/css?family=Poppins:400,600,700&display=swap" rel="stylesheet">

<style>
body{margin:0;font-family:'Poppins',sans-serif;background:#f4f6f9}
a{text-decoration:none;cursor:pointer}
.sidebar{width:260px;background:#0f2a44;color:#fff;display:flex;flex-direction:column}
.sidebar a{padding:14px 25px;color:#fff;display:block;transition:.3s}
.sidebar a:hover{background:rgba(255,255,255,.15);padding-left:32px}
.sidebar a.active{background:rgba(255,255,255,.2);font-weight:600}
.topbar{background:#fff;padding:16px 25px;box-shadow:0 4px 12px rgba(0,0,0,.08)}
.card{background:#fff;padding:25px;border-radius:16px;box-shadow:0 10px 30px rgba(0,0,0,.08)}
.card:hover{transform:translateY(-6px);box-shadow:0 18px 40px rgba(0,0,0,.12)}
</style>
</head>

<body>

<div style="display:flex;min-height:100vh">

<!-- SIDEBAR -->
<div class="sidebar">

  <div style="padding:12px 20px;border-bottom:1px solid rgba(255,255,255,.1);text-align:center">
    <a href="index.php">
      <img src="images/logo.png" style="max-width:120px">
    </a>
    <p style="font-size:12px;opacity:.8">Admin Panel</p>
  </div>

  <div style="flex:1">
    <a id="btn-dashboard" class="active" onclick="loadDashboard()">📊 General Dashboard</a>
    <a onclick="loadPage('property.php','Property Management',this)">🏘 Property Management</a>
    <a onclick="loadPage('bookings.php','Bookings',this)">💰 Bookings</a>
<a onclick="loadPage('landlord_requests.php','Management Requests',this)">💰Management Requests</a>
    <a onclick="loadPage('messages.php','Messages',this)">💬 Messages</a>
<a onclick="loadPage('landlords.php','Landlords Management',this)">🏢 Landlords</a>

    <a onclick="loadPage('users.php','User Management',this)">👤 Users</a>

  </div>

  <div style="padding:15px 25px;border-top:1px solid rgba(255,255,255,.1)">
    <a href="logout.php" style="color:#ffb3b3;font-weight:600">🚪 Logout</a>
  </div>
</div>

<!-- MAIN -->
<div style="flex:1;display:flex;flex-direction:column">
  <div class="topbar">
    <h2 id="pageTitle" style="margin:0;color:#0f2a44">General Dashboard</h2>
  </div>

  <div style="padding:30px" id="mainContent"></div>
</div>
</div>

<script>
function setActive(el){
  document.querySelectorAll('.sidebar a').forEach(a=>a.classList.remove('active'));
  if(el) el.classList.add('active');
}

function loadDashboard(){
  setActive(document.getElementById('btn-dashboard'));
  document.getElementById('pageTitle').innerText='General Dashboard';

  fetch('dashboard_stats.php')
    .then(r=>r.json())
    .then(d=>{
      document.getElementById('mainContent').innerHTML=`
      <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:20px">
        <div class="card">
          <h4>Vacant Houses</h4>
          <h1 style="color:#dc3545;">${d.vacant}</h1>
        </div>
        <div class="card">
          <h4>Total Units</h4>
          <h1 style="color:#0f2a44;">${d.total_units}</h1>
        </div>
        <div class="card">
          <h4>Unread Messages</h4>
          <h1 style="color:#2563eb;">${d.unread_messages}</h1>
        </div>
      </div>`;
    });
}

function loadPage(url,title,el){
  setActive(el);
  document.getElementById('pageTitle').innerText=title;

  fetch(url)
    .then(r=>r.text())
    .then(html=>{
      const c=document.getElementById('mainContent');
      c.innerHTML=html;

      c.querySelectorAll('script').forEach(s=>{
        const n=document.createElement('script');
        n.text=s.textContent;
        document.body.appendChild(n);
        s.remove();
      });
    });
}

/* INITIAL LOAD */
loadDashboard();
</script>



</body>
</html>
