<?php
require_once 'require_login.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Header & Footer</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      font-family: 'Old Standard TT', serif;
      background: url('images/bg.jpg') center/cover no-repeat fixed;
      color: #fff;
      display: flex;
      flex-direction: column;
    }
.hero {
      flex: 1;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 80px 20px 20px;
      background: rgba(0, 0, 0, 0.5);
    }

    .overlay-text {
      background: rgba(0, 0, 0, 0.7);
      border-radius: 10px;
      padding: 20px;
      max-width: 90%;
      text-align: left;
      display: flex;
      align-items: center;
      gap: 20px;
      flex-wrap: wrap;
    }

    .overlay-text img {
      width: 100px;
      height: auto;
      border-radius: 8px;
      flex-shrink: 0;
    }

    .overlay-text .text-content {
      color: #fff;
      font-size: 16px;
      flex: 1;
    }

    .shop-button {
      display: flex;
      justify-content: center;
      margin: 30px auto;
    }

    .shop-button button {
      background: #fff;
      color: #000;
      padding: 12px 30px;
      font-size: 18px;
      border: none;
      cursor: pointer;
      font-weight: bold;
      border-radius: 5px;
      transition: 0.3s ease;
    }

    .shop-button button:hover {
      background: #ccc;
    }

    .gallery {
      display: flex;
      justify-content: center;
      gap: 10px;
      padding: 30px 10px;
      background: rgba(0, 0, 0, 0.8);
      flex-wrap: wrap;
    }

    .gallery img {
      width: 140px;
      height: 200px;
      object-fit: cover;
      border-radius: 10px;
      filter: grayscale(100%);
      transition: transform 0.3s ease;
    }

    .gallery img:hover {
      transform: scale(1.05);
      filter: grayscale(0%);
    }

    /* Header */
    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px 30px;
      background-color: rgba(17, 17, 17, 0.8);
      position: relative;
    }

    .header-left {
      display: flex;
      align-items: center;
      gap: 20px;
    }

    .logo img {
      height: 40px; /* Adjust height as needed */
    }

    .belagidds-btn {
      background: #444;
      color: #fff;
      border: none;
      padding: 8px 16px;
      border-radius: 5px;
      cursor: pointer;
    }

    .header-right {
      display: flex;
      align-items: center;
      gap: 20px;
    }

    .cart-icon {
      font-size: 1.3rem;
      cursor: pointer;
      color: white;
    }

    .account-dropdown {
      position: relative;
    }

    .account-button {
      background: #444;
      color: #fff;
      border: none;
      padding: 8px 16px;
      border-radius: 5px;
      cursor: pointer;
    }

    .dropdown-menu {
      display: none;
      position: absolute;
      right: 0;
      top: 100%;
      background-color: #222;
      border: 1px solid #333;
      border-radius: 5px;
      overflow: hidden;
      z-index: 10;
    }

    .dropdown-menu a {
      display: block;
      color: #fff;
      text-decoration: none;
      padding: 10px 15px;
      transition: background 0.3s;
    }

    .dropdown-menu a:hover {
      background-color: #333;
    }

    .account-dropdown:hover .dropdown-menu {
      display: block;
    }
    /*Cart wrapper  */
    .cart-wrapper {
  position: relative;
  display: inline-block;
  color: #fff;
}

.cart-badge {
  position: absolute;
  top: -8px;
  right: -10px;
  background: red;
  color: white;
  font-size: 8px;
  font-weight: bold;
  border-radius: 20%;
  padding: 3px 6px;
  min-width: 4px;
  text-align: center;
}


    /* Footer */
    footer {
      background-color: rgba(17, 17, 17, 0.8);
      padding: 30px 20px;
      text-align: center;
    }

    .social-icons {
      margin-bottom: 15px;
    }

    .social-icons a {
      color: #fff;
      font-size: 1.4rem;
      margin: 0 10px;
      transition: color 0.3s;
    }

    .social-icons a:hover {
      color: #888;
    }

    .copyright {
      font-size: 0.9rem;
      color: #aaa;
    }
  </style>
</head>
<body>

<!-- Header -->
<header>
  <div class="header-left">
    <a href="/fix/index.php" class="logo"><img src="/fix/images/TAJI YETU.PNG" alt="Logo"></a>
    <button class="belagidds-btn">Belagidds</button>
  </div>

  <div class="header-right">
    <a href="/fix/cart.php" class="cart-wrapper">
  <i class="fas fa-shopping-cart cart-icon"></i>
  <?php
    $cart_count = 0;
    if (isset($_SESSION['cart'])) {
      foreach ($_SESSION['cart'] as $item) {
        $cart_count += $item['quantity'];
      }
    }
  ?>
  <span class="cart-badge"><?= $cart_count ?></span>
</a>


    <div class="account-dropdown">
      <button class="account-button">
        <?php if (isset($_SESSION['user_id'])): ?>
          <?= htmlspecialchars($_SESSION['name']) ?>
        <?php else: ?>
          Account
        <?php endif; ?>
        <i class="fas fa-caret-down"></i>
      </button>

      <div class="dropdown-menu">
        <?php if (isset($_SESSION['user_id'])): ?>
          <a href="/fix/profile.php">Profile</a>
          <a href="/fix/orders.php">Orders</a>
          <a href="/fix/logout.php">Logout</a>
        <?php else: ?>
          <a href="/fix/login.php">Login</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</header>
   <section class="hero">
    <div class="overlay-text">
      <img src="images/bg.jpg" alt="Model Image">
      <div class="text-content">
        <p>90% of the money made from these Belagids outfits
        go into the development and advancement of the Belagids vision.</p>
      </div>
    </div>
  </section>

  <div class="shop-button">
    <button onclick="window.location.href='listing.php'">Shop now</button>

  </div>

  <section class="gallery">
    <img src="images/bw.jpeg" alt="Outfit 1">
    <img src="images/girl.jpeg" alt="Outfit 2">
    <img src="images/cargo pants.jpeg" alt="Outfit 3">
    <img src="images/girl2.jpeg" alt="Outfit 4">
    <img src="images/short black.jpeg" alt="Outfit 5">
  </section>


  <!-- Footer -->
  <footer>
    <div class="social-icons">
      <a href="https://www.facebook.com/share/19B3wm2Xdn/"><i class="fab fa-facebook-f"></i></a>
      <a href="https://x.com/BellaGidds?t=XuTmK5KeSViKkiYy-dhCHw&s=09"><i class="fab fa-twitter"></i></a>
      <a href="https://www.instagram.com/belagids?igsh=MThsZ21xNXB2cXBrYg=="><i class="fab fa-instagram"></i></a>
      <a href="https://www.tiktok.com/@belagids?_t=ZM-8y36Xmrl6Jy&_r=1"><i class="fab fa-tiktok"></i></a>
    </div>
    <div class="copyright">
      &copy; 2025 TAJI YETU. All rights reserved.
    </div>
  </footer>

</body>
</html>
