<?php
session_start();

// Enforce login
if (!isset($_SESSION['user'])) {
  $_SESSION['redirect_after_login'] = 'checkout.php';
  header('Location: login.php');
  exit();
}

// Handle inactivity auto logout (10 min = 600 sec)
$inactiveLimit = 600;
if (isset($_SESSION['last_activity']) && time() - $_SESSION['last_activity'] > $inactiveLimit) {
  unset($_SESSION['user']);
  header('Location: login.php');
  exit();
}
$_SESSION['last_activity'] = time();

$cart = $_SESSION['cart'] ?? [];
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Checkout</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: sans-serif;
      margin: 0;
      padding: 0;
      background: #f0f0f0;
    }

    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px 30px;
      background-color: rgba(17, 17, 17, 0.8);
      position: sticky;
      top: 0;
      z-index: 1000;
      flex-wrap: wrap;
    }

    .header-left {
      display: flex;
      align-items: center;
      gap: 20px;
    }

    .logo img {
      height: 40px;
    }

    .belagidds-btn {
      background-color: transparent;
      color: #fff;
      border: none;
      padding: 8px 16px;
      border-radius: 5px;
      cursor: pointer;
    }

    .header-right {
      display: flex;
      align-items: center;
      gap: 20px;
    }

    .cart-icon {
      font-size: 1.3rem;
      cursor: pointer;
      color: #fff;
    }

    .account-dropdown {
      position: relative;
    }

    .account-button {
      background-color: transparent;
      color: #fff;
      border: none;
      padding: 8px 16px;
      border-radius: 5px;
      cursor: pointer;
    }

    .dropdown-menu {
      display: none;
      position: absolute;
      right: 0;
      top: 100%;
      background-color: #222;
      border: 1px solid #333;
      border-radius: 5px;
      overflow: hidden;
      z-index: 10;
    }

    .dropdown-menu a {
      display: block;
      color: #fff;
      text-decoration: none;
      padding: 10px 15px;
      transition: background 0.3s;
    }

    .dropdown-menu a:hover {
      background-color: #333;
    }

    .account-dropdown:hover .dropdown-menu {
      display: block;
    }

    .checkout-container {
      display: flex;
      flex-wrap: wrap;
      gap: 30px;
      max-width: 1200px;
      margin: 50px auto;
      padding: 20px;
    }

    .cart-box, form {
      background: white;
      padding: 25px;
      border-radius: 10px;
      flex: 1 1 450px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }

    h2, h4 {
      text-align: center;
      margin-bottom: 30px;
    }

    input, textarea {
      width: 100%;
      padding: 10px;
      margin-bottom: 15px;
      border-radius: 6px;
      border: 1px solid #ccc;
      font-size: 14px;
    }

    button {
      background: black;
      color: white;
      padding: 12px;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      width: 100%;
      font-size: 16px;
    }

    #cart-items ul {
      list-style: none;
      padding: 0;
      margin: 0;
    }

    #cart-items li {
      display: flex;
      align-items: center;
      justify-content: space-between;
      gap: 10px;
      padding: 10px 0;
      border-bottom: 1px solid #eee;
    }

    #cart-items img {
      width: 60px;
      height: 60px;
      object-fit: cover;
      border-radius: 5px;
    }

    .item-info {
      flex-grow: 1;
    }

    .item-price {
      min-width: 80px;
      text-align: right;
    }

    .total {
      font-weight: bold;
      text-align: right;
      margin-top: 10px;
    }

    .tip-section {
      display: flex;
      flex-wrap: wrap;
      gap: 10px;
      margin-bottom: 20px;
    }

    .tip-section label {
      background: #f8f8f8;
      padding: 8px 12px;
      border-radius: 6px;
      border: 1px solid #ccc;
      cursor: pointer;
      display: flex;
      align-items: center;
      gap: 5px;
    }

    .tip-section input[type="radio"] {
      accent-color: black;
      cursor: pointer;
    }

    .notes-label {
      font-weight: bold;
      margin: 10px 0 5px;
      display: block;
    }

    textarea#notes {
      height: 100px;
      resize: vertical;
    }

    .action-buttons {
      display: flex;
      justify-content: space-between;
      gap: 10px;
    }

    .action-buttons a, .action-buttons button {
      flex: 1;
    }

    footer {
      background: rgba(17, 17, 17, 0.9);
      padding: 20px;
      text-align: center;
      color: #ccc;
      margin-top: 50px;
    }

    .social-links {
      display: flex;
      justify-content: center;
      gap: 15px;
      margin-top: 15px;
    }

    .social-icon {
      width: 24px;
      height: 24px;
    }
    /*Cart wrapper  */
    .cart-wrapper {
  position: relative;
  display: inline-block;
  color: #fff;
}

.cart-badge {
  position: absolute;
  top: -8px;
  right: -10px;
  background: red;
  color: white;
  font-size: 8px;
  font-weight: bold;
  border-radius: 20%;
  padding: 3px 6px;
  min-width: 4px;
  text-align: center;
}

  </style>
</head>
<body>
  <!-- Header -->
<header>
  <div class="header-left">
    <a href="/fix/index.php" class="logo"><img src="/fix/images/TAJI YETU.PNG" alt="Logo"></a>
    <button class="belagidds-btn">Belagidds</button>
  </div>

  <div class="header-right">
  <!--  <a href="/fix/cart.php" class="cart-wrapper">
  <i class="fas fa-shopping-cart cart-icon"></i>
  <
    $cart_count = 0;
    if (isset($_SESSION['cart'])) {
      foreach ($_SESSION['cart'] as $item) {
        $cart_count += $item['quantity'];
      }
    }
  ?>
  <span class="cart-badge"><= $cart_count ?></span>
</a>-->

    <div class="account-dropdown">
      <button class="account-button">
        <?php if (isset($_SESSION['user_id'])): ?>
          <?= htmlspecialchars($_SESSION['name']) ?>
        <?php else: ?>
          Account
        <?php endif; ?>
        <i class="fas fa-caret-down"></i>
      </button>

      <div class="dropdown-menu">
        <?php if (isset($_SESSION['user_id'])): ?>
          <a href="/fix/profile.php">Profile</a>
          <a href="/fix/orders.php">Orders</a>
          <a href="/fix/logout.php">Logout</a>
        <?php else: ?>
          <a href="/fix/login.php">Login</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</header>

  <div class="checkout-container">
    <div class="cart-box">
      <h4>Your Cart</h4>
      <div id="cart-items">
        <ul id="items-list"></ul>
        <div class="total" id="subtotal">Subtotal: Ksh 0</div>
        <div class="total">Shipping Fee: Ksh 300</div>
        <div class="total">Tip: <span id="tip-amount">Ksh 0</span></div>
        <div class="total" id="total-price">Total: Ksh 0</div>
      </div>
    </div>

    <form id="checkout-form">
      <input type="text" name="name" id="name" placeholder="Full Name" required />
      <input type="tel" name="phone" id="phone" placeholder="Phone Number" required />
      <textarea name="address" id="address" placeholder="Delivery Address" required></textarea>

      <div class="tip-section">
        <label><input type="radio" name="tipOption" value="5"> 5%</label>
        <label><input type="radio" name="tipOption" value="10"> 10%</label>
        <label><input type="radio" name="tipOption" value="15"> 15%</label>
        <label><input type="radio" name="tipOption" value="20"> 20%</label>
        <label>Custom Tip (KES): <input type="number" id="customTip" min="0" style="width: 80px;" /></label>
      </div>

      <label for="notes" class="notes-label">Leave us a note</label>
      <textarea name="notes" id="notes" placeholder="e.g., Deliver Monday only or call before delivery"></textarea>

      <div class="action-buttons">
        <a href="product p.html"><button type="button">Keep Shopping</button></a>
        <button type="submit">Pay</button>
      </div>
    </form>
  </div>

  <footer>
    <p>&copy; 2025 Taji Yetu. All rights reserved. | Nairobi, Kenya</p>
    <div class="social-links">
      <a href="https://www.facebook.com/share/19B3wm2Xdn/" target="_blank"><img src="images/fc.png" class="social-icon" alt="Facebook"></a>
      <a href="https://www.instagram.com/belagids" target="_blank"><img src="images/in.png" class="social-icon" alt="Instagram"></a>
      <a href="https://x.com/BellaGidds" target="_blank"><img src="images/x.png" class="social-icon" alt="Twitter"></a>
      <a href="https://www.tiktok.com/@belagids" target="_blank"><img src="images/t.png" class="social-icon" alt="TikTok"></a>
    </div>
  </footer>

  <script>
    const itemsList = document.getElementById('items-list');
    const subtotalEl = document.getElementById('subtotal');
    const totalEl = document.getElementById('total-price');
    const tipAmountEl = document.getElementById('tip-amount');
    const customTipInput = document.getElementById('customTip');
    const SHIPPING_FEE = 300;
    let subtotal = 0;

    fetch('get_cart.php')
      .then(res => res.json())
      .then(data => {
        const cart = data.cart || [];
        if (cart.length === 0) {
          itemsList.innerHTML = '<li>Your cart is empty.</li>';
          return;
        }
        cart.forEach(item => {
          const li = document.createElement('li');
          const quantity = parseInt(item.quantity) || 1;
          const price = parseFloat(item.price.toString().replace(/[^\d.-]/g, ''));
          const lineTotal = quantity * price;
          subtotal += lineTotal;
          const img = document.createElement('img');
          img.src = item.image && item.image.trim() !== '' ? `uploads/${item.image}` : 'images/placeholder.png';
          img.alt = item.name || 'Product';
          const info = document.createElement('div');
          info.className = 'item-info';
          info.innerHTML = `<strong>${item.name}</strong><br>(${quantity}x)`;
          const priceEl = document.createElement('div');
          priceEl.className = 'item-price';
          priceEl.textContent = `Ksh ${lineTotal.toLocaleString()}`;
          li.appendChild(img);
          li.appendChild(info);
          li.appendChild(priceEl);
          itemsList.appendChild(li);
        });
        subtotalEl.textContent = `Subtotal: Ksh ${subtotal.toLocaleString()}`;
        updateTotal();
      });

    function getTipValue() {
      const selectedRadio = document.querySelector('input[name="tipOption"]:checked');
      const custom = parseInt(customTipInput.value);
      if (!isNaN(custom) && custom > 0) {
        if (selectedRadio) selectedRadio.checked = false;
        return custom;
      }
      if (selectedRadio) {
        const percent = parseInt(selectedRadio.value);
        return Math.round((subtotal * percent) / 100);
      }
      return 0;
    }

    function updateTotal() {
      const tip = getTipValue();
      const finalTotal = subtotal + SHIPPING_FEE + tip;
      tipAmountEl.textContent = `Ksh ${tip.toLocaleString()}`;
      totalEl.textContent = `Total: Ksh ${finalTotal.toLocaleString()}`;
    }

    document.querySelectorAll('input[name="tipOption"]').forEach(radio => {
      radio.addEventListener('change', () => {
        customTipInput.value = '';
        updateTotal();
      });
    });

    customTipInput.addEventListener('input', updateTotal);

    document.getElementById('checkout-form').addEventListener('submit', function(e) {
      e.preventDefault();
      const name = this.name.value;
      const phone = this.phone.value;
      const address = this.address.value;
      const notes = this.notes.value;
      const tipAmount = getTipValue();

      fetch('checkout.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ name, phone, address, notes, tip: tipAmount, shipping: SHIPPING_FEE })
      })
      .then(res => res.text())
      .then(data => {
        alert(data);
        window.location.href = 'thankyou.html';
      })
      .catch(err => {
        console.error(err);
        alert("Something went wrong!");
      });
    });
  </script>
</body>
</html>
