<?php
session_start();
$cart = $_SESSION['cart'] ?? [];
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Your Cart - Taji Yetu</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      font-family: 'Old Standard TT', serif;
      background: url('images/1.png') center/cover no-repeat fixed;
      color: #fff;
      padding: 20px;
    }

    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 20px;
    }

    header img {
      width: 120px;
    }

    .account-dropdown {
      position: relative;
    }

    .account-btn {
      background: #fff;
      color: #000;
      padding: 8px 15px;
      border: none;
      border-radius: 5px;
      cursor: pointer;
      font-weight: bold;
    }

    .dropdown-menu {
      display: none;
      position: absolute;
      right: 0;
      top: 40px;
      background: #fff;
      color: #000;
      border-radius: 5px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.2);
      min-width: 130px;
      z-index: 1000;
    }

    .dropdown-menu a {
      display: block;
      padding: 10px 15px;
      text-decoration: none;
      color: #000;
    }

    .dropdown-menu a:hover {
      background: #eee;
    }

    .account-dropdown:hover .dropdown-menu {
      display: block;
    }

    .cart-container {
      max-width: 900px;
      margin: 100px auto 0;
      background: rgba(0, 0, 0, 0.8);
      border-radius: 12px;
      padding: 20px;
    }

    .cart-item {
      display: flex;
      align-items: center;
      margin-bottom: 20px;
      background: rgba(255, 255, 255, 0.05);
      border-radius: 8px;
      overflow: hidden;
    }

    .cart-item img {
      width: 100px;
      height: 100px;
      object-fit: cover;
    }

    .cart-details {
      padding: 10px 20px;
      flex-grow: 1;
    }

    .cart-details h3 {
      font-size: 18px;
      margin-bottom: 5px;
    }

    .cart-details p {
      font-size: 14px;
      color: #ccc;
    }

    .quantity-controls {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-top: 10px;
    }

    .quantity-controls button {
      padding: 4px 10px;
      font-weight: bold;
      border: none;
      border-radius: 5px;
      cursor: pointer;
    }

    .remove-button {
      background: #fff;
      color: #000;
      border: none;
      padding: 6px 12px;
      font-weight: bold;
      border-radius: 5px;
      cursor: pointer;
    }

    .remove-button:hover {
      background: #ccc;
    }

    .total-price {
      text-align: right;
      font-size: 18px;
      margin-top: 20px;
      color: #fff;
      font-weight: bold;
    }

    .checkout-button {
      margin-top: 30px;
      background: #fff;
      color: #000;
      padding: 12px 24px;
      font-size: 16px;
      border: none;
      font-weight: bold;
      border-radius: 8px;
      cursor: pointer;
      display: block;
      margin-left: auto;
      margin-right: auto;
    }

    .checkout-button:hover {
      background: #ccc;
    }
    

  </style>
</head>
<body>
<!-- Header -->
<header>
  <div class="header-left">
    <a href="/fix/index.php" class="logo"><img src="/fix/images/TAJI YETU.PNG" alt="Logo"></a>
    <button class="belagidds-btn">Belagidds</button>
  </div>

  <div class="header-right">
    <a href="/fix/cart.php" class="cart-wrapper">
  <i class="fas fa-shopping-cart cart-icon"></i>
  <?php
    $cart_count = 0;
    if (isset($_SESSION['cart'])) {
      foreach ($_SESSION['cart'] as $item) {
        $cart_count += $item['quantity'];
      }
    }
  ?>
  <span class="cart-badge"><?= $cart_count ?></span>
</a>

    <div class="account-dropdown">
      <button class="account-button">
        <?php if (isset($_SESSION['user_id'])): ?>
          <?= htmlspecialchars($_SESSION['name']) ?>
        <?php else: ?>
          Account
        <?php endif; ?>
        <i class="fas fa-caret-down"></i>
      </button>

      <div class="dropdown-menu">
        <?php if (isset($_SESSION['user_id'])): ?>
          <a href="/fix/profile.php">Profile</a>
          <a href="/fix/orders.php">Orders</a>
          <a href="/fix/logout.php">Logout</a>
        <?php else: ?>
          <a href="/fix/login.php">Login</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</header>

<div class="cart-container">
  <h1>Your Cart</h1>
  <?php if (empty($cart)): ?>
    <p>Your cart is empty.</p>
  <?php else: ?>
    <?php $total = 0; ?>
    <?php foreach ($cart as $index => $item): ?>
      <?php $itemTotal = $item['price'] * $item['quantity']; $total += $itemTotal; ?>
      <div class="cart-item">
        <img src="/fix/uploads/<?= htmlspecialchars($item['image']) ?>" alt="<?= htmlspecialchars($item['name']) ?>">
        <div class="cart-details">
          <h3><?= htmlspecialchars($item['name']) ?></h3>
          <p>Price: Ksh <?= number_format($item['price']) ?></p>
          <div class="quantity-controls">
            <form action="update_cart.php" method="post" style="display:inline;">
              <input type="hidden" name="action" value="decrease">
              <input type="hidden" name="index" value="<?= $index ?>">
              <button type="submit">-</button>
            </form>
            <span><?= $item['quantity'] ?></span>
            <form action="update_cart.php" method="post" style="display:inline;">
              <input type="hidden" name="action" value="increase">
              <input type="hidden" name="index" value="<?= $index ?>">
              <button type="submit">+</button>
            </form>
          </div>
          <p>Total: Ksh <?= number_format($itemTotal) ?></p>
        </div>
        <form action="update_cart.php" method="post">
          <input type="hidden" name="action" value="remove">
          <input type="hidden" name="index" value="<?= $index ?>">
          <button class="remove-button" type="submit">Remove</button>
        </form>
      </div>
    <?php endforeach; ?>
    <<div class="total-price">Total: Ksh <?= number_format($total) ?></div>
<div style="display: flex; justify-content: center; gap: 20px; flex-wrap: wrap; margin-top: 20px;">
  <a href="listing.html">
    <button class="checkout-button" style="background-color: #eee; color: #000;">Keep Shopping</button>
  </a>
  <a href="checkout.php">
    <button class="checkout-button">Proceed to Checkout</button>
  </a>
</div>

  <?php endif; ?>
</div>

<footer>
  <p style="text-align:center; color:#ccc; margin-top:40px;">&copy; 2025 Taji Yetu. All rights reserved.</p>
</footer>
</body>
</html>
