<?php
// Include PHPMailer classes
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

// Database connection
$conn = new mysqli("localhost", "root", "", "bella");
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}
session_start();
include 'db_connect.php'; // Your DB connection script

if (!isset($_SESSION['user_id'])) {
    die("You must be logged in to save measurements.");
}

$user_id = $_SESSION['user_id'];
$gender = $_POST['gender'];
$address = $_POST['address'];
$bust = $_POST['bust'] ?? null;
$waist = $_POST['waist'];
$hips = $_POST['hips'] ?? null;
$shoulders = $_POST['shoulders'];
$chest = $_POST['chest'] ?? null;
$timestamp = date('Y-m-d H:i:s');

// Clear any existing measurements older than 3 months
mysqli_query($conn, "DELETE FROM measurements WHERE user_id = $user_id AND created_at < NOW() - INTERVAL 3 MONTH");

// Insert new measurements
$stmt = $conn->prepare("
    INSERT INTO measurements 
    (user_id, gender, bust, waist, hips, shoulders, chest, address, created_at)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$stmt->bind_param(
    "issdddsds", 
    $user_id, $gender, $bust, $waist, $hips, $shoulders, $chest, $address, $timestamp
);

if ($stmt->execute()) {
  echo "Measurements saved successfully!";

    // You can redirect instead
    // header(\"Location: success_page.php\");
} else {
  echo "Error: " . $stmt->error;

}

$stmt->close();
$conn->close();
?>
