<?php
session_start();
$conn = new mysqli("localhost", "root", "", "bella");

// Redirect if not logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: login.html");
  exit();
}

$userId = $_SESSION['user_id'];

// Fetch user basic info
$userStmt = $conn->prepare("SELECT firstName, lastName, email, phone FROM users WHERE id = ?");
$userStmt->bind_param("i", $userId);
$userStmt->execute();
$userStmt->bind_result($firstName, $lastName, $email, $phone);
$userStmt->fetch();
$userStmt->close();

// Fetch user measurements
$measStmt = $conn->prepare("SELECT chest, waist, hips, bust, shoulders, gender  FROM measurements WHERE user_id = ?");
$measStmt->bind_param("i", $userId);
$measStmt->execute();
$measStmt->bind_result($chest, $waist, $hips, $bust, $shoulders, $gender);
$measStmt->fetch();
$measStmt->close(); 

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>My Profile - Taji Yetu</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f4f4f4;
      margin: 0;
      padding: 0;
    }

    .container {
      max-width: 600px;
      margin: 50px auto;
      background: #fff;
      padding: 30px;
      border-radius: 8px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    h1 {
      text-align: center;
      margin-bottom: 30px;
    }

    .info-group {
      margin-bottom: 20px;
    }

    .info-group label {
      font-weight: bold;
      display: block;
      margin-bottom: 5px;
    }

    .info-group p {
      margin: 0;
      color: #333;
      background: #eee;
      padding: 10px;
      border-radius: 4px;
    }

    .logout-btn {
      text-align: center;
      margin-top: 30px;
    }

    .logout-btn a {
      background: #000;
      color: #fff;
      padding: 10px 20px;
      text-decoration: none;
      border-radius: 5px;
      font-weight: bold;
    }

    .logout-btn a:hover {
      background: #444;
    }
  </style>
</head>
<body>

  <div class="container">
    <h1>My Profile</h1>

    <div class="info-group">
      <label>First Name:</label>
      <p><?= htmlspecialchars($firstName) ?></p>
    </div>

    <div class="info-group">
      <label>Last Name:</label>
      <p><?= htmlspecialchars($lastName) ?></p>
    </div>

    <div class="info-group">
      <label>Email:</label>
      <p><?= htmlspecialchars($email) ?></p>
    </div>

    <div class="info-group">
      <label>Phone:</label>
      <p><?= htmlspecialchars($phone) ?></p>
    </div>

    <h2>Measurements</h2>

    <div class="info-group">
      <label>Gender:</label>
      <p><?= htmlspecialchars($gender) ?></p>
    </div>
      <div class="info-group">
      <label>Chest:</label>
      <p><?= htmlspecialchars($chest) ?> cm</p>
    </div>

    <div class="info-group">
      <label>Waist:</label>
      <p><?= htmlspecialchars($waist) ?> cm</p>
    </div>

    <div class="info-group">
      <label>Shoulders:</label>
      <p><?= htmlspecialchars($shoulders) ?> cm</p>
    </div>

    <div class="info-group">
      <label>Bust:</label>
      <p><?= htmlspecialchars($bust) ?> cm</p>
    </div>

    <div class="logout-btn">
      <a href="logout.php">Logout</a>
    </div>
  </div>

</body>
</html>
