<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Product Details</title>
  <link href="https://fonts.googleapis.com/css2?family=Old+Standard+TT:wght@700&display=swap" rel="stylesheet">
  <style>
    body {
      font-family: 'Old Standard TT', serif;
      background: url('images/1.png') center/cover no-repeat fixed;
      color: #fff;
      padding: 20px;
      margin: 0;
    }

    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      background: rgba(0, 0, 0, 0.6);
      padding: 15px 25px;
      border-radius: 10px;
      margin-bottom: 30px;
    }

    .logo-title {
      display: flex;
      align-items: center;
      font-size: 24px;
      font-weight: bold;
      color: #fff;
    }

    header img {
      height: 32px;
      margin-right: 12px;
    }

    .cart-button {
      background: #fff;
      color: #000;
      padding: 10px 18px;
      border: none;
      font-weight: bold;
      border-radius: 6px;
      cursor: pointer;
      transition: 0.3s ease;
    }

    .cart-button:hover {
      background: #ccc;
    }

    .container {
      max-width: 800px;
      margin: auto;
      background: rgba(0, 0, 0, 0.85);
      padding: 30px;
      border-radius: 12px;
      text-align: center;
    }

    .container img {
      width: 100%;
      max-height: 420px;
      object-fit: cover;
      border-radius: 10px;
      margin-bottom: 20px;
    }

    .product-name {
      font-size: 30px;
      margin-bottom: 10px;
      font-weight: bold;
    }

    .product-price {
      font-size: 22px;
      color: #bbb;
      margin-bottom: 20px;
    }

    .product-description {
      font-size: 16px;
      color: #ddd;
      margin-bottom: 30px;
    }

    .action-buttons {
      display: flex;
      justify-content: center;
      gap: 20px;
      flex-wrap: wrap;
    }

    .action-buttons button {
      background: #fff;
      color: #000;
      padding: 12px 24px;
      border: none;
      font-weight: bold;
      border-radius: 8px;
      cursor: pointer;
      transition: 0.3s ease;
    }

    .action-buttons button:hover {
      background: #ccc;
    }

    .floating-cart {
      position: fixed;
      bottom: 20px;
      right: 20px;
      background: #fff;
      color: #000;
      padding: 10px 16px;
      font-weight: bold;
      border: none;
      border-radius: 50px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.4);
      cursor: pointer;
      z-index: 1000;
      transition: 0.3s ease;
    }

    .floating-cart:hover {
      background: #ccc;
    }
  </style>
</head>
<body>

  <header>
    <div class="logo-title">
      <img src="images/crown.png" alt="Crown Logo" />
      <span>Taji Yetu</span>
    </div>
    <button onclick="window.location.href='cart.html'" class="cart-button">ðŸ›’ Cart</button>
  </header>

  <div class="container">
    <img id="product-image" src="" alt="Product Image">
    <div class="product-name" id="product-name"></div>
    <div class="product-price" id="product-price"></div>
    <div class="product-description" id="product-description"></div>

    <div class="action-buttons">
      <button onclick="addToCart()">Add to Cart</button>
      <button onclick="window.history.back()">Back to Shop</button>
    </div>
  </div>

  <button class="floating-cart" onclick="window.location.href='cart.html'">ðŸ›’</button>

  <script>
    const products = {
      1: {
        name: "Black Warrior Coat",
        price: "Ksh 5,000",
        description: "A bold, dark outerwear piece inspired by warrior culture and streetwear fusion.",
        image: "images/bw.jpeg"
      },
      2: {
        name: "Dark Elegance Robe",
        price: "Ksh 4,500",
        description: "Elegant dark robe for those who want comfort with class.",
        image: "images/girl.jpeg"
      },
      3: {
        name: "Shadow Cargo Pants",
        price: "Ksh 3,200",
        description: "Functional and stylish cargo pants in deep tones.",
        image: "images/cargo pants.jpeg"
      },
      4: {
        name: "Urban Drape Set",
        price: "Ksh 6,000",
        description: "An urban outfit set perfect for avant-garde fashion lovers.",
        image: "images/girl2.jpeg"
      },
      5: {
        name: "Tactical Black Shorts",
        price: "Ksh 2,800",
        description: "Lightweight and tactical-inspired shorts for daily wear.",
        image: "images/short black.jpeg"
      }
    };

    const params = new URLSearchParams(window.location.search);
    const id = params.get('id');

    if (products[id]) {
      const product = products[id];
      document.getElementById('product-name').textContent = product.name;
      document.getElementById('product-price').textContent = product.price;
      document.getElementById('product-description').textContent = product.description;
      document.getElementById('product-image').src = product.image;
    } else {
      document.querySelector('.container').innerHTML = "<h2>Product not found</h2>";
    }

    function addToCart() {
      if (!products[id]) return;

      const cart = JSON.parse(localStorage.getItem('cart')) || [];
      const product = products[id];

      cart.push({
        id: id,
        name: product.name,
        price: product.price,
        image: product.image
      });

      localStorage.setItem('cart', JSON.stringify(cart));
      alert(`${product.name} added to cart!`);
    }
  </script>

</body>
</html>
s