<?php
session_start();
$isLoggedIn = isset($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Taji Yetu - Bella Gidds</title>
  <link href="https://fonts.googleapis.com/css2?family=Old+Standard+TT:wght@700&display=swap" rel="stylesheet">
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; }

    html, body {
      height: 100%;
      overflow-x: hidden;
    }

    body {
      font-family: 'Old Standard TT', serif;
      background: url('images/bg.jpg') center/cover no-repeat fixed;
      color: #fff;
      display: flex;
      flex-direction: column;
    }

    header {
      position: absolute;
      top: 20px;
      left: 20px;
      font-size: 28px;
      font-weight: bold;
      color: #fff;
      z-index: 10;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    header img {
      height: 30px;
    }

    .account-dropdown {
      position: absolute;
      top: 20px;
      right: 20px;
      z-index: 100;
    }

    .account-btn {
      background: #fff;
      color: #000;
      padding: 8px 15px;
      border: none;
      border-radius: 5px;
      cursor: pointer;
      font-weight: bold;
    }

    .dropdown-menu {
      display: none;
      position: absolute;
      right: 0;
      top: 40px;
      background: #fff;
      color: #000;
      border-radius: 5px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.2);
      min-width: 130px;
    }

    .dropdown-menu a {
      display: block;
      padding: 10px 15px;
      text-decoration: none;
      color: #000;
    }

    .dropdown-menu a:hover {
      background: #eee;
    }

    .hero {
      flex: 1;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 80px 20px 20px;
      background: rgba(0, 0, 0, 0.5);
    }

    .overlay-text {
      background: rgba(0, 0, 0, 0.7);
      border-radius: 10px;
      padding: 20px;
      max-width: 90%;
      text-align: left;
      display: flex;
      align-items: center;
      gap: 20px;
      flex-wrap: wrap;
    }

    .overlay-text img {
      width: 100px;
      height: auto;
      border-radius: 8px;
      flex-shrink: 0;
    }

    .overlay-text .text-content {
      color: #fff;
      font-size: 16px;
      flex: 1;
    }

    .shop-button {
      display: flex;
      justify-content: center;
      margin: 30px auto;
    }

    .shop-button button {
      background: #fff;
      color: #000;
      padding: 12px 30px;
      font-size: 18px;
      border: none;
      cursor: pointer;
      font-weight: bold;
      border-radius: 5px;
      transition: 0.3s ease;
    }

    .shop-button button:hover {
      background: #ccc;
    }

    .gallery {
      display: flex;
      justify-content: center;
      gap: 10px;
      padding: 30px 10px;
      background: rgba(0, 0, 0, 0.8);
      flex-wrap: wrap;
    }

    .gallery img {
      width: 140px;
      height: 200px;
      object-fit: cover;
      border-radius: 10px;
      filter: grayscale(100%);
      transition: transform 0.3s ease;
    }

    .gallery img:hover {
      transform: scale(1.05);
      filter: grayscale(0%);
    }

.social-links {
  display: flex;
  justify-content: center;
  align-items: center;
  gap: 12px;
  margin-top: 30px;
}

.social-icon {
  width: 24px;
  height: 24px;
  object-fit: contain;
  transition: transform 0.2s ease, opacity 0.2s ease;
}

.social-icon:hover {
  transform: scale(1.1);
  opacity: 0.8;
}


    footer {
      background: rgba(0, 0, 0, 0.9);
      color: #ccc;
      padding: 20px;
      text-align: center;
      font-size: 14px;
    }

    .social-icons {
      margin-top: 10px;
    }

    .social-icons a {
      margin: 0 10px;
      color: #ccc;
      text-decoration: none;
      font-size: 18px;
    }

    .social-icons a:hover {
      color: #fff;
    }

    @media (max-width: 600px) {
      .overlay-text {
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
      }

      .overlay-text img {
        width: 80px;
      }

      .overlay-text .text-content {
        font-size: 14px;
      }

      .gallery img {
        width: 100px;
        height: 160px;
      }

      .shop-button button {
        padding: 10px 20px;
        font-size: 16px;
      }
    }
  </style>
</head>
<body>

 <header style="position: relative; height: 80px;">
  <img src="images/TAJI YETU.png" alt="Taji Yetu Logo" style="width: 120px; height: auto;" />
</header>


  <!-- Account Dropdown -->
  <div class="account-dropdown">
    <button class="account-btn" onclick="toggleDropdown()">Account ▾</button>
    <div class="dropdown-menu" id="accountMenu">
      <?php if ($isLoggedIn): ?>
        <a href="profile.php">My Profile</a>
        <a href="logout.php">Log Out</a>
      <?php else: ?>
        <a href="login.html" onclick="saveRedirect('profile.php')">Sign In</a>
      <?php endif; ?>
    </div>
  </div>

  <section class="hero">
    <div class="overlay-text">
      <img src="images/bg.jpg" alt="Model Image">
      <div class="text-content">
        <p>90% of the money made from these Belagids outfits
        go into the development and advancement of the Belagids vision.</p>
      </div>
    </div>
  </section>

  <div class="shop-button">
    <button onclick="handleShopNow()">Shop now</button>
  </div>

  <section class="gallery">
    <img src="images/bw.jpeg" alt="Outfit 1">
    <img src="images/girl.jpeg" alt="Outfit 2">
    <img src="images/cargo pants.jpeg" alt="Outfit 3">
    <img src="images/girl2.jpeg" alt="Outfit 4">
    <img src="images/short black.jpeg" alt="Outfit 5">
  </section>

  <footer>
    &copy; 2025 Taji Yetu. All rights reserved. | Nairobi, Kenya
    <div class="social-links">
  <a href="https://facebook.com/" target="_blank">
    <img src="images/fc.png" alt="Facebook" class="social-icon" />
  </a>
  <a href="https://instagram.com/" target="_blank">
    <img src="images/in.png" alt="Instagram" class="social-icon" />
  </a>
  <a href="https://twitter.com/" target="_blank">
    <img src="images/x.png" alt="Twitter" class="social-icon" />
  </a>
  <a href="https://tiktok.com/" target="_blank">
    <img src="images/t.png" alt="TikTok" class="social-icon" />
  </a>
</div>
  </footer>

  <script>
    function handleShopNow() {
      <?php if ($isLoggedIn): ?>
        window.location.href = 'product p.html';
      <?php else: ?>
        localStorage.setItem('redirectAfterLogin', 'product p.html');
        window.location.href = 'login.html';
      <?php endif; ?>
    }

    function toggleDropdown() {
      const menu = document.getElementById('accountMenu');
      menu.style.display = (menu.style.display === 'block') ? 'none' : 'block';
    }

    function saveRedirect(page) {
      localStorage.setItem('redirectAfterLogin', page);
    }

    document.addEventListener('click', function(e) {
      const menu = document.getElementById('accountMenu');
      if (!e.target.closest('.account-dropdown')) {
        menu.style.display = 'none';
      }
    });
  </script>

</body>
</html>
