<?php
session_start();
require_once "db.php"; // Use PDO connection

// Only admin can view
if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] != 1) {
    die("Unauthorized access");
}

// Get order ID
$order_id = intval($_GET['id'] ?? 0);
if (!$order_id) {
    die("Invalid order ID");
}

try {
    // Fetch order info
    $stmt = $conn->prepare("SELECT o.id, o.status, o.total_price, o.created_at, u.firstName, u.lastName, u.email 
                            FROM orders o 
                            JOIN users u ON o.user_id = u.id 
                            WHERE o.id = :oid");
    $stmt->bindValue(':oid', $order_id, PDO::PARAM_INT);
    $stmt->execute();
    $order = $stmt->fetch(PDO::FETCH_ASSOC);
    $stmt = null;

    if (!$order) die("Order not found");

    $customer_name = trim(($order['firstName'] ?? '') . " " . ($order['lastName'] ?? ''));
    $customer_email = $order['email'] ?? '';

    // Fetch order items
    $stmt = $conn->prepare("SELECT p.name, p.image, oi.qty, oi.price 
                            FROM order_items oi 
                            JOIN products p ON oi.product_id = p.id 
                            WHERE oi.order_id = :oid");
    $stmt->bindValue(':oid', $order_id, PDO::PARAM_INT);
    $stmt->execute();
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $stmt = null;
} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>View Order #<?= $order['id'] ?></title>
<link rel="icon" href="images/taji-yetu.png" type="image/png">
<link href="css/bootstrap.min.css" rel="stylesheet">
<link href="css/bootstrap-icons.css" rel="stylesheet">
<link href="css/tooplate-mini-finance.css" rel="stylesheet">
<style>
body { background:#000; color:#fff; }
table { color:#fff; }
table thead th { background:#222; }
table tbody tr { background:#111; }
table tbody tr:hover { background:#222; }
</style>
</head>
<body>

<canvas id="bgCanvas" style="position:fixed; top:0; left:0; width:100%; height:100%; z-index:-1;"></canvas>

<?php include "navbar.php"; ?>
<?php include "sidebar.php"; ?>

<main class="main-wrapper col-md-9 ms-sm-auto py-4 col-lg-9 px-md-4 border-start">
    <div class="title-group mb-3">
        <h1 class="h2 mb-0">Order #<?= $order['id'] ?></h1>
        <p>Placed on <?= date("F j, Y, g:i A", strtotime($order['created_at'])) ?></p>
        <p>Customer: <?= htmlspecialchars($customer_name) ?> (<?= htmlspecialchars($customer_email) ?>)</p>
        <p>Status: <strong><?= htmlspecialchars($order['status']) ?></strong></p>
    </div>

    <div class="table-responsive mb-4">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Image</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <th>Subtotal</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($items as $item): ?>
                <tr>
                    <td><?= htmlspecialchars($item['name']) ?></td>
                    <td><img src="uploads/<?= htmlspecialchars($item['image']) ?>" alt="<?= htmlspecialchars($item['name']) ?>" style="width:60px;height:60px;object-fit:cover;"></td>
                    <td><?= $item['qty'] ?></td>
                    <td>Ksh <?= number_format($item['price']) ?></td>
                    <td>Ksh <?= number_format($item['price'] * $item['qty']) ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <h4>Total Price: Ksh <?= number_format($order['total_price']) ?></h4>

    <a href="admin-orders.php" class="btn btn-secondary mt-3">Back to Orders</a>
</main>

<?php include "footer.php"; ?>
<script src="js/bootstrap.bundle.min.js"></script>
<script>
// Particles background
const canvas = document.getElementById('bgCanvas');
const ctx = canvas.getContext('2d');
let particles = [];
function resizeCanvas(){ canvas.width=window.innerWidth; canvas.height=window.innerHeight; }
window.addEventListener('resize', resizeCanvas);
resizeCanvas();

for(let i=0;i<80;i++){
    particles.push({x:Math.random()*canvas.width, y:Math.random()*canvas.height, r:Math.random()*2+1});
}

function animate(){
    ctx.clearRect(0,0,canvas.width,canvas.height);
    ctx.fillStyle='white';
    particles.forEach(p=>{
        ctx.beginPath();
        ctx.arc(p.x,p.y,p.r,0,Math.PI*2);
        ctx.fill();
        p.y -= 0.3;
        if(p.y<0)p.y=canvas.height;
    });
    requestAnimationFrame(animate);
}
animate();
</script>
</body>
</html>
