<?php
require_once 'db.php'; // centralized PDO connection
session_start();

// Only handle POST requests
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $firstName = trim($_POST['firstName']);
    $lastName  = trim($_POST['lastName']);
    $email     = trim($_POST['email']);
    $phone     = trim($_POST['phone']);
    $password  = $_POST['password'];

    // Validate inputs
    if (empty($firstName) || empty($lastName) || empty($email) || empty($phone) || empty($password)) {
        die("All fields are required.");
    }

    // Check if email exists already
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = :email");
    $stmt->execute(['email' => $email]);
    if ($stmt->fetch(PDO::FETCH_ASSOC)) {
        die("Email already registered. <a href='login.php'>Login here</a>");
    }

    // Hash password securely
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // Insert new user
    $stmt = $conn->prepare("INSERT INTO users (firstName, lastName, phone, email, password, profile_pic, is_admin) 
                            VALUES (:firstName, :lastName, :phone, :email, :password, 'images/default-user.png', 0)");
    $success = $stmt->execute([
        'firstName' => $firstName,
        'lastName'  => $lastName,
        'phone'     => $phone,
        'email'     => $email,
        'password'  => $hashedPassword
    ]);

    if ($success) {
        header("Location: login.php?registered=1");
        exit;
    } else {
        echo "Error: Unable to register user.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Register - Taji Yetu</title>
<link rel="icon" href="images/taji-yetu.png" type="image/png">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
body { margin:0; font-family:'Segoe UI',sans-serif; background:#000; color:#fff; position:relative; }
#particles-js { position:fixed; top:0; left:0; width:100%; height:100%; z-index:0; pointer-events:none; }

.container { max-width:400px; margin:80px auto; padding:25px; background:#1a1a1a; border-radius:12px; box-shadow:0 4px 20px rgba(0,0,0,0.5); position:relative; z-index:2; }
h1 { text-align:center; margin-bottom:25px; color:#f0f0f0; }
form { display:flex; flex-direction:column; gap:15px; }
input { padding:10px 12px; border-radius:6px; border:none; background:#2a2a2a; color:#fff; font-size:14px; }
input::placeholder { color:#777; }
button { padding:10px 15px; border:none; border-radius:8px; background:#fff; color:#000; font-weight:bold; cursor:pointer; transition:all 0.3s; }
button:hover { background:#555; color:#fff; }

a { color:#fff; text-align:center; display:block; margin-top:10px; font-size:14px; }
a:hover { text-decoration:underline; }

@media(max-width:480px){ .container { margin:40px 20px; padding:20px; } }
</style>
</head>
<body>
<div id="particles-js"></div>

<div class="container">
    <h1>Register</h1>
    <form method="post" action="">
        <input type="text" name="firstName" placeholder="First Name" required>
        <input type="text" name="lastName" placeholder="Last Name" required>
        <input type="email" name="email" placeholder="Email" required>
        <input type="text" name="phone" placeholder="Phone" required>
        <input type="password" name="password" placeholder="Password" required>
        <button type="submit">Register</button>
    </form>
    <a href="login.php">Already have an account? Login</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
<script>
particlesJS("particles-js", {
  "particles": {
    "number":{"value":80,"density":{"enable":true,"value_area":800}},
    "color":{"value":"#ffffff"},
    "shape":{"type":"circle"},
    "opacity":{"value":0.8,"random":true,"anim":{"enable":true,"speed":1,"opacity_min":0.1,"sync":false}},
    "size":{"value":2,"random":true,"anim":{"enable":true,"speed":4,"size_min":0.1,"sync":false}},
    "move":{"enable":true,"speed":0.3,"direction":"top","random":true,"straight":false,"out_mode":"out","bounce":false}
  },
  "interactivity":{"events":{"onhover":{"enable":false},"onclick":{"enable":false}},"modes":{}},
  "retina_detect":true
});
</script>
</body>
</html>
