<?php
require_once 'db.php';
session_start();

$id = $_GET['id'] ?? '';
$product = null;
if ($id) {
    $stmt = $conn->prepare("SELECT * FROM products WHERE id = :id");
    $stmt->execute(['id' => $id]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);
}

$is_admin = isset($_SESSION['is_admin']) ? intval($_SESSION['is_admin']) : 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= $product ? htmlspecialchars($product['name']) : 'Product Not Found' ?> - Taji Yetu</title>
<link rel="icon" href="images/taji-yetu.png" type="image/png">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
<?php if($is_admin): ?><link rel="stylesheet" href="admin-sidebar.css"><?php endif; ?>
<style>
body {
    margin:0;
    font-family:'Segoe UI',sans-serif;
    background:#000;
    color:#fff;
    min-height:100vh;
    display:flex;
    flex-direction:column;
}
main {
    flex:1;
    padding-top:70px;
    display:flex;
    justify-content:center;
    align-items:flex-start;
    padding-bottom:20px;
    <?php if($is_admin): ?>margin-left:250px;<?php endif; ?>
}
.product-container {
    display:flex;
    gap:30px;
    max-width:1100px;
    width:100%;
    align-items:flex-start;
    flex-wrap:wrap;
}
.product-image {
    position:relative;
    flex:1 1 400px;
    display:flex;
    justify-content:center;
    align-items:flex-start;
}
.product-image img {
    width:100%;
    max-height:65vh;
    border-radius:10px;
    box-shadow:0 8px 20px rgba(0,0,0,0.8);
    object-fit:contain;
}
.added-badge {
    position:absolute;
    top:10px;
    right:10px;
    background:rgba(255,127,0,0.9);
    color:#fff;
    padding:4px 10px;
    border-radius:6px;
    display:none;
    align-items:center;
    gap:6px;
    font-size:13px;
    font-weight:bold;
    z-index:10;
}
.added-badge i { color:#fff; }

.product-details {
    flex:1 1 400px;
    background:#222;
    padding:12px 15px;
    border-radius:10px;
    display:flex;
    flex-direction:column;
    gap:60px;
    align-items:center;
    text-align:center;
}
.product-details h1 {
    font-size:1.5rem;
    display:flex;
    align-items:center;
    justify-content:center;
    gap:8px;
    margin:0;
}
.product-details p { font-size:15px; margin:0; line-height:1.3; }
.measurement-tag {
    display:inline-flex;
    align-items:center;
    justify-content:center;
    gap:4px;
    background:#333;
    padding:3px 8px;
    border-radius:6px;
    font-size:0.8rem;
    margin:2px;
}
.button-group {
    display:flex;
    gap:10px;
    margin-top:8px;
    flex-wrap:wrap;
}
.button-group a {
    background:#fff;
    color:#000;
    font-weight:bold;
    padding:7px 12px;
    border-radius:6px;
    text-decoration:none;
    display:flex;
    align-items:center;
    gap:6px;
    transition:all 0.3s;
}
.button-group a:hover {
    background:#FF7F00;
    color:#fff;
    transform:scale(1.05);
}
.button-group .remove-cart {
    padding:7px;
    width:38px;
    justify-content:center;
}
.toast {
    position:fixed;
    top:80px; right:20px;
    background:#333; color:#fff;
    padding:10px 16px; border-radius:6px;
    opacity:0; transform:translateY(-20px);
    transition:all 0.4s;
    z-index:9999; font-weight:bold;
}
.toast.show { opacity:1; transform:translateY(0); }

#continue-shop {
    position:fixed; left:10px; top:100px;
    background:#fff; color:#000; border-radius:50%;
    width:50px; height:50px;
    display:flex; justify-content:center; align-items:center;
    cursor:pointer; font-size:20px;
    z-index:9999;
}
#continue-shop span {
    position:absolute; top:-10px; left:60px;
    background:#fff; color:#000;
    padding:6px 12px; border-radius:6px;
    font-weight:bold; opacity:0; transform:translateX(-20px);
    transition:all 0.4s;
}
#continue-shop.show span { opacity:1; transform:translateX(0); }

footer { margin-top:auto; background:#111; color:#fff; padding:40px 20px; }

@media(max-width:768px){
    main { flex-direction:column; gap:20px; margin-left:0 !important; }
    .product-container { flex-direction:column; gap:20px; }
    .button-group { flex-direction:row; justify-content:center; }
    .product-details { width:95%; padding:10px; }
}
</style>
</head>
<body>
<?php include 'navbar.php'; ?>
<?php if($is_admin) include 'admin-sidebar.php'; ?>

<main>
<?php if($product): ?>
<div class="product-container">
    <div class="product-image">
        <img src="uploads/<?= htmlspecialchars($product['image']) ?>" alt="<?= htmlspecialchars($product['name']) ?>">
        <div class="added-badge"><i class="fa-solid fa-cart-shopping"></i> In Cart</div>
    </div>
    <div class="product-details">
        <h1><i class="fa-solid fa-shirt"></i> <?= htmlspecialchars($product['name']) ?></h1>
        <p><?= htmlspecialchars($product['description']) ?></p>
        <?php
            $measurements = json_decode($product['measurements'], true);
            if(!empty($measurements)){
                foreach($measurements as $m){
                    if(!empty($m)) echo '<span class="measurement-tag"><i class="fa-solid fa-ruler"></i>'.$m.'</span>';
                }
            }
        ?>
        <p><strong>Price:</strong> Ksh <?= number_format($product['price']) ?></p>

        <div class="button-group">
            <a href="#" class="add-to-cart" data-id="<?= $product['id'] ?>"><i class="fa-solid fa-cart-plus"></i> Add to cart</a>
            <a href="cart.php"><i class="fa-solid fa-eye"></i> View cart</a>
            <a href="#" class="remove-cart" data-id="<?= $product['id'] ?>"><i class="fa-solid fa-trash"></i></a>
        </div>
    </div>
</div>
<?php else: ?>
<h2>Product not found.</h2>
<?php endif; ?>
</main>

<div id="toast" class="toast"></div>
<div id="continue-shop"><i class="fa-solid fa-bag-shopping"></i><span>Continue Shopping!</span></div>
<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
<script>
// Toast
function showToast(msg){const t=document.getElementById('toast');t.textContent=msg;t.classList.add('show');setTimeout(()=>t.classList.remove('show'),2000);}

// Badge
const addBtn = document.querySelector('.add-to-cart');
const removeBtn = document.querySelector('.remove-cart');
const addedBadge = document.querySelector('.added-badge');

function updateCartBadge(inCart){
    addedBadge.style.display = inCart ? 'flex' : 'none';
}

// Check cart status
function checkCartStatus(){
    fetch('update_cart.php',{method:'POST',body:new URLSearchParams({check_item:1,id:<?= (int)$id ?>})})
    .then(r=>r.json()).then(d=>updateCartBadge(d.in_cart));
}
checkCartStatus();

// Add to Cart
addBtn?.addEventListener('click', async e=>{
    e.preventDefault();
    const res = await fetch('update_cart.php',{method:'POST',body:new URLSearchParams({add_item:1,id:addBtn.dataset.id})});
    const data = await res.json();
    if(data.success){ updateCartBadge(true); showToast("Added to cart"); }
});

// Remove from Cart
removeBtn?.addEventListener('click', async e=>{
    e.preventDefault();
    const res = await fetch('update_cart.php',{method:'POST',body:new URLSearchParams({remove_item:1,id:removeBtn.dataset.id})});
    const data = await res.json();
    if(data.success){ updateCartBadge(false); showToast("Removed from cart"); }
});

// Continue Shopping popup
const contShop = document.getElementById('continue-shop');
setInterval(()=>{contShop.classList.add('show'); setTimeout(()=>contShop.classList.remove('show'),3000);},7000);
contShop.addEventListener('click',()=>window.location.href='listing.php');
</script>
</body>
</html>
