<?php
require_once 'db.php'; // centralized PDO connection
session_start();
session_unset();
session_destroy();

// Start a fresh session to store the one-time notice
session_start();
$_SESSION['logged_out'] = true;
header("Location: index.php");
exit;
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Logged Out | Taji Yetu</title>
<link rel="icon" href="images/taji-yetu.png" type="image/png">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
<style>
*{margin:0;padding:0;box-sizing:border-box;}
body{font-family:'Segoe UI',sans-serif;background:#000;color:#fff;min-height:100vh;display:flex;flex-direction:column;position:relative;overflow-x:hidden;}
main{padding-top:70px;text-align:center;position:relative;z-index:2;}

/* Message box */
.message-box{
  background:rgba(30,30,30,0.95);
  color:#fff;
  max-width:500px;
  margin:100px auto;
  padding:20px;
  border-radius:10px;
  box-shadow:0 0 20px rgba(255,255,255,0.2);
  animation:fadeUp 0.6s ease forwards;
}
.message-box a{
  display:inline-block;
  margin-top:15px;
  padding:6px 12px;
  background:#fff;
  color:#000;
  text-decoration:none;
  border-radius:5px;
  font-weight:bold;
  transition:all 0.3s ease;
}
.message-box a:hover{background:#000;color:#fff;}

/* Page title & animations */
@keyframes fadeUp{0%{opacity:0;transform:translateY(10px);}100%{opacity:1;transform:translateY(0);}}
.pagetitle{color:#fff;text-align:center;margin:15px 0;font-size:1.5em;opacity:0;transform:translateY(-10px);animation:entry 1s forwards;}
@keyframes entry{to{opacity:1;transform:translateY(0);}}

/* Particles background */
#particles-js{ position:fixed; top:0;left:0;width:100%;height:100%; background:#000; z-index:0; overflow:hidden; }

/* Footer */
footer{background:rgba(0,0,0,0.85);color:#fff;padding:40px 20px;display:flex;flex-wrap:wrap;justify-content:space-between;gap:20px;}
footer .column{flex:1; min-width:150px;}
footer h4{font-weight:bold;margin-bottom:10px;}
footer a{color:#fff;text-decoration:none;}
footer a:hover{text-decoration:underline;}
footer p{margin-top:10px;font-size:14px;}

/* Mobile adjustments */
@media (max-width:768px){
  main {padding:50px 20px;}
}
</style>
</head>
<body>
<div id="particles-js"></div>

<main>
  <div class="message-box">
    <h2>You have been logged out</h2>
    <p>Thank you for visiting Taji Yetu.</p>
    <a href="index.php">Return to Home</a>
  </div>
</main>

<footer>
  <div class="column">
    <h4>Taji Yetu</h4>
    <p>&copy; <?=date('Y')?> Taji Yetu. All rights reserved.</p>
  </div>
  <div class="column">
    <h4>Quick Links</h4>
    <a href="index.php">Home</a><br>
    <a href="shop.php">Shop</a>
  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
<script>
// Initialize particles
particlesJS("particles-js", {
  "particles": {
    "number": {"value":80,"density":{"enable":true,"value_area":800}},
    "color":{"value":"#ffffff"},
    "shape":{"type":"circle"},
    "opacity":{"value":0.8,"random":true,"anim":{"enable":true,"speed":1,"opacity_min":0.1,"sync":false}},
    "size":{"value":2,"random":true,"anim":{"enable":true,"speed":4,"size_min":0.1,"sync":false}},
    "move":{"enable":true,"speed":0.3,"direction":"top","random":true,"straight":false,"out_mode":"out","bounce":false}
  },
  "interactivity":{"events":{"onhover":{"enable":false},"onclick":{"enable":false}},"modes":{}},
  "retina_detect":true
});
</script>
</body>
</html>
