<?php
session_start();
require_once 'db.php'; // Updated to use PDO

// Redirect if not logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php?redirect=" . urlencode($_SERVER['REQUEST_URI']));
    exit();
}

$userId = $_SESSION['user_id'];

// Fetch current measurements using PDO
try {
    $stmt = $conn->prepare("SELECT gender, chest, waist, shoulders, bust FROM measurements WHERE user_id = :user_id");
    $stmt->execute([':user_id' => $userId]);
    $data = $stmt->fetch(PDO::FETCH_ASSOC);

    $gender = $data['gender'] ?? '';
    $chest = $data['chest'] ?? '';
    $waist = $data['waist'] ?? '';
    $shoulders = $data['shoulders'] ?? '';
    $bust = $data['bust'] ?? '';
} catch (PDOException $e) {
    error_log("Measurement Fetch Error: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Edit Measurements - Taji Yetu</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" href="images/taji-yetu.png" type="image/png">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
<style>
body {
  margin: 0;
  font-family: 'Inter', sans-serif;
  background: #000;
  color: #fff;
  overflow-x: hidden;
  position: relative;
}
canvas#bg {
  position: fixed;
  top: 0; left: 0;
  width: 100%; height: 100%;
  z-index: -1;
  background: #000;
}
.container {
  max-width: 600px;
  margin: 100px auto;
  background: rgba(255,255,255,0.05);
  padding: 25px;
  border-radius: 20px;
  box-shadow: 0 0 20px rgba(255,255,255,0.1);
  backdrop-filter: blur(8px);
}
h1 {
  text-align: center;
  margin-bottom: 25px;
  color: #fff;
  font-weight: 600;
}
form {
  display: flex;
  flex-direction: column;
  gap: 15px;
}
input, select {
  padding: 12px;
  border-radius: 6px;
  border: 1px solid #555;
  background: #111;
  color: #fff;
  font-size: 14px;
}
input:focus, select:focus {
  outline: none;
  border-color: #fff;
}
button {
  padding: 12px;
  border: none;
  border-radius: 6px;
  font-size: 16px;
  cursor: pointer;
  transition: 0.3s;
}
button.save-btn {
  background: #fff;
  color: #000;
}
button.save-btn:hover {
  background: #ccc;
}
button.cancel-btn {
  background: #333;
  color: #fff;
}
button.cancel-btn:hover {
  background: #555;
}
@media (max-width:768px){
  .container { margin: 60px 15px; }
}
</style>
</head>
<body>
<canvas id="bg"></canvas>
<?php include "navbar.php"; ?>

<div class="container">
  <h1>Edit Measurements</h1>
  <form action="save-measurements.php" method="post">
    <select name="gender" required>
      <option value="" <?= empty($gender) ? 'selected' : '' ?>>Add your gender</option>
      <option value="Male" <?= $gender === 'Male' ? 'selected' : '' ?>>Male</option>
      <option value="Female" <?= $gender === 'Female' ? 'selected' : '' ?>>Female</option>
    </select>
    <input type="number" step="0.1" name="chest" placeholder="Chest (cm)" value="<?= htmlspecialchars($chest) ?>">
    <input type="number" step="0.1" name="waist" placeholder="Waist (cm)" value="<?= htmlspecialchars($waist) ?>">
    <input type="number" step="0.1" name="shoulders" placeholder="Shoulders (cm)" value="<?= htmlspecialchars($shoulders) ?>">
    <input type="number" step="0.1" name="bust" placeholder="Bust (cm)" value="<?= htmlspecialchars($bust) ?>">
    <div style="display:flex; gap:10px;">
      <button type="submit" class="save-btn">Save</button>
      <a href="profile.php"><button type="button" class="cancel-btn">Cancel</button></a>
    </div>
  </form>
</div>

<script>
const canvas = document.getElementById('bg');
const ctx = canvas.getContext('2d');
let particles = [];

function resize() {
  canvas.width = window.innerWidth;
  canvas.height = window.innerHeight;
}
window.addEventListener('resize', resize);
resize();

for (let i = 0; i < 80; i++) {
  particles.push({
    x: Math.random() * canvas.width,
    y: Math.random() * canvas.height,
    size: Math.random() * 2 + 1
  });
}

function animate() {
  ctx.fillStyle = "#000";
  ctx.fillRect(0, 0, canvas.width, canvas.height);
  ctx.fillStyle = "white";
  particles.forEach(p => {
    ctx.beginPath();
    ctx.arc(p.x, p.y, p.size, 0, Math.PI * 2);
    ctx.fill();
    p.y -= 0.3;
    if (p.y < 0) p.y = canvas.height;
  });
  requestAnimationFrame(animate);
}
animate();
</script>

<?php include "footer.php"; ?>
</body>
</html>
